/*
 * Decompiled with CFR 0.152.
 */
package org.violetmoon.quark.content.client.module;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Locale;
import java.util.Optional;
import java.util.function.BiPredicate;
import java.util.regex.Pattern;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.gui.screens.inventory.InventoryScreen;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.ItemEnchantments;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.ItemStackHandler;
import org.jetbrains.annotations.Nullable;
import org.violetmoon.quark.api.IQuarkButtonAllowed;
import org.violetmoon.quark.base.client.handler.ClientUtil;
import org.violetmoon.quark.base.client.handler.InventoryButtonHandler;
import org.violetmoon.quark.base.config.QuarkGeneralConfig;
import org.violetmoon.quark.base.config.type.RGBAColorConfig;
import org.violetmoon.quark.base.handler.InventoryTransferHandler;
import org.violetmoon.quark.base.handler.SimilarBlockTypeHandler;
import org.violetmoon.quark.content.management.client.screen.widgets.MiniInventoryButton;
import org.violetmoon.zeta.client.event.load.ZClientSetup;
import org.violetmoon.zeta.client.event.play.ZRenderContainerScreen;
import org.violetmoon.zeta.client.event.play.ZScreen;
import org.violetmoon.zeta.config.Config;
import org.violetmoon.zeta.event.bus.LoadEvent;
import org.violetmoon.zeta.event.bus.PlayEvent;
import org.violetmoon.zeta.module.ZetaLoadModule;
import org.violetmoon.zeta.module.ZetaModule;

@ZetaLoadModule(category="client")
public class ChestSearchingModule
extends ZetaModule {
    @Config
    public RGBAColorConfig overlayColor = RGBAColorConfig.forColor(0.0, 0.0, 0.0, 0.67);

    public boolean searchBarShown() {
        return false;
    }

    public boolean namesMatch(ItemStack stack) {
        return false;
    }

    @ZetaLoadModule(clientReplacement=true)
    public static class Client
    extends ChestSearchingModule {
        private EditBox searchBar;
        private String text = "";
        public boolean searchEnabled = false;
        private long lastClick;
        private int matched;

        @Override
        public boolean searchBarShown() {
            return this.searchEnabled;
        }

        @LoadEvent
        public final void clientSetup(ZClientSetup event) {
            InventoryButtonHandler.addButtonProvider(this, InventoryButtonHandler.ButtonTargetType.CONTAINER_INVENTORY, 1, (parent, x, y) -> new MiniInventoryButton(parent, 3, parent.getXSize() - 30, 5, "quark.gui.button.filter", b -> {
                if (this.searchBar != null) {
                    this.searchEnabled = !this.searchEnabled;
                    this.updateSearchStatus();
                    this.searchBar.setFocused(true);
                }
            }).setTextureShift(() -> this.searchEnabled), null);
        }

        @PlayEvent
        public void initGui(ZScreen.Init.Post event) {
            Screen gui = event.getScreen();
            boolean apiAllowed = gui instanceof IQuarkButtonAllowed;
            if (!(gui instanceof InventoryScreen) && gui instanceof AbstractContainerScreen) {
                AbstractContainerScreen chest = (AbstractContainerScreen)gui;
                if (apiAllowed || QuarkGeneralConfig.isScreenAllowed(gui)) {
                    Minecraft mc = gui.getMinecraft();
                    if (apiAllowed || InventoryTransferHandler.accepts(chest.getMenu(), (Player)mc.player)) {
                        this.searchBar = new EditBox(mc.font, 18, 6, 117, 10, (Component)Component.literal((String)this.text));
                        this.searchBar.setValue(this.text);
                        this.searchBar.setMaxLength(50);
                        this.searchBar.setBordered(false);
                        this.updateSearchStatus();
                        return;
                    }
                }
            }
            this.searchBar = null;
        }

        private void updateSearchStatus() {
            if (this.searchBar != null) {
                this.searchBar.setEditable(this.searchEnabled);
                this.searchBar.setVisible(this.searchEnabled);
                if (!this.searchEnabled) {
                    this.searchBar.setFocused(false);
                }
            }
        }

        @PlayEvent
        public void charTyped(ZScreen.CharacterTyped.Pre event) {
            if (this.searchBar != null && this.searchBar.isFocused() && this.searchEnabled) {
                this.searchBar.charTyped(event.getCodePoint(), event.getModifiers());
                this.text = this.searchBar.getValue();
                event.setCanceled(true);
            }
        }

        @PlayEvent
        public void onKeypress(ZScreen.KeyPressed.Pre event) {
            if (this.searchBar != null && this.searchBar.isFocused() && this.searchEnabled) {
                this.searchBar.keyPressed(event.getKeyCode(), event.getScanCode(), event.getModifiers());
                this.text = this.searchBar.getValue();
                event.setCanceled(event.getKeyCode() != 256);
            }
        }

        @PlayEvent
        public void onClick(ZScreen.MouseButtonPressed.Pre event) {
            Screen screen;
            if (this.searchBar != null && this.searchEnabled && (screen = event.getScreen()) instanceof AbstractContainerScreen) {
                AbstractContainerScreen containerScreen = (AbstractContainerScreen)screen;
                boolean isMouseOver = this.searchBar.isMouseOver(event.getMouseX() - (double)containerScreen.getGuiLeft(), event.getMouseY() - (double)containerScreen.getGuiTop());
                if (event.getButton() == 1 && isMouseOver) {
                    this.searchBar.setValue("");
                    this.text = "";
                }
                this.searchBar.setFocused(isMouseOver);
            }
        }

        @PlayEvent
        public void renderForeground(ZRenderContainerScreen.Foreground event) {
            if (this.searchBar != null && this.searchEnabled) {
                GuiGraphics guiGraphics = event.getGuiGraphics();
                PoseStack matrix = guiGraphics.pose();
                AbstractContainerScreen gui = event.getContainerScreen();
                matrix.pushPose();
                this.drawBackground(guiGraphics, (Screen)gui, this.searchBar.getX() - 11, this.searchBar.getY() - 3);
                if (!this.text.isEmpty()) {
                    AbstractContainerMenu container = gui.getMenu();
                    this.matched = 0;
                    for (Slot s : container.slots) {
                        if (!s.isActive()) continue;
                        ItemStack stack = s.getItem();
                        if (!this.namesMatch(stack, this.text)) {
                            int x = s.x;
                            int y = s.y;
                            guiGraphics.fill(x, y, x + 16, y + 16, this.overlayColor.getColor());
                            continue;
                        }
                        ++this.matched;
                    }
                }
                if (this.matched == 0 && !this.text.isEmpty()) {
                    this.searchBar.setTextColor(0xFF5555);
                } else {
                    this.searchBar.setTextColor(0xFFFFFF);
                }
                this.searchBar.render(guiGraphics, 0, 0, 0.0f);
                matrix.popPose();
            }
        }

        private void drawBackground(GuiGraphics guiGraphics, Screen gui, int x, int y) {
            if (gui == null) {
                return;
            }
            RenderSystem.setShader(GameRenderer::getPositionTexShader);
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            guiGraphics.blit(ClientUtil.GENERAL_ICONS, x, y, 0.0f, 0.0f, 126, 13, 256, 256);
        }

        @Override
        public boolean namesMatch(ItemStack stack) {
            return !this.searchEnabled || this.namesMatch(stack, this.text);
        }

        public boolean namesMatch(ItemStack stack, String search) {
            if ((search = ChatFormatting.stripFormatting((String)search.trim().toLowerCase(Locale.ROOT))) == null || search.isEmpty()) {
                return true;
            }
            if (stack.isEmpty()) {
                return false;
            }
            Item item = stack.getItem();
            ResourceLocation res = BuiltInRegistries.ITEM.getKey((Object)item);
            if (SimilarBlockTypeHandler.isShulkerBox(res)) {
                CompoundTag cmp = ((CustomData)stack.get(DataComponents.BLOCK_ENTITY_DATA)).copyTag();
                ClientLevel level = Minecraft.getInstance().level;
                if (cmp != null && level != null) {
                    Iterator handler;
                    BlockEntity be;
                    if (!cmp.contains("id")) {
                        cmp = cmp.copy();
                        cmp.putString("id", "minecraft:shulker_box");
                    }
                    if ((be = BlockEntity.loadStatic((BlockPos)BlockPos.ZERO, (BlockState)((BlockItem)item).getBlock().defaultBlockState(), (CompoundTag)cmp, (HolderLookup.Provider)level.registryAccess())) != null && ((Optional)((Object)(handler = Optional.ofNullable((IItemHandler)level.getCapability(Capabilities.ItemHandler.BLOCK, be.getBlockPos(), null))))).isPresent()) {
                        IItemHandler items = (IItemHandler)((Optional)((Object)handler)).orElse((ItemStackHandler)new ItemStackHandler());
                        for (int i = 0; i < items.getSlots(); ++i) {
                            if (!this.namesMatch(items.getStackInSlot(i), search)) continue;
                            return true;
                        }
                    }
                }
            }
            String name = stack.getHoverName().getString();
            name = ChatFormatting.stripFormatting((String)name.trim().toLowerCase(Locale.ROOT));
            StringMatcher matcher = String::contains;
            if (search.length() >= 3 && search.startsWith("\"") && search.endsWith("\"")) {
                search = search.substring(1, search.length() - 1);
                matcher = String::equals;
            }
            if (search.length() >= 3 && search.startsWith("/") && search.endsWith("/")) {
                search = search.substring(1, search.length() - 1);
                matcher = (s1, s2) -> Pattern.compile(s2).matcher((CharSequence)s1).find();
            }
            if (stack.isEnchanted()) {
                ItemEnchantments enchants = (ItemEnchantments)stack.get(DataComponents.ENCHANTMENTS);
                for (Holder e : enchants.keySet()) {
                    if (e == null || !matcher.test(Enchantment.getFullname((Holder)e, (int)enchants.getLevel(e)).toString().toLowerCase(Locale.ROOT), search)) continue;
                    return true;
                }
            }
            ArrayList potionNames = new ArrayList();
            if (stack.has(DataComponents.POTION_CONTENTS)) {
                PotionContents.addPotionTooltip((Iterable)((PotionContents)stack.get(DataComponents.POTION_CONTENTS)).getAllEffects(), component -> potionNames.add(component), (float)1.0f, (float)Item.TooltipContext.EMPTY.tickRate());
                for (Component s : potionNames) {
                    if (!matcher.test(ChatFormatting.stripFormatting((String)s.toString().trim().toLowerCase(Locale.ROOT)), search)) continue;
                    return true;
                }
            }
            if (stack.has(DataComponents.STORED_ENCHANTMENTS)) {
                ItemEnchantments enchantments = (ItemEnchantments)stack.get(DataComponents.STORED_ENCHANTMENTS);
                for (Holder e : enchantments.keySet()) {
                    int lvl;
                    if (!matcher.test(Enchantment.getFullname((Holder)e, (int)(lvl = enchantments.getLevel(e))).toString().toLowerCase(Locale.ROOT), search)) continue;
                    return true;
                }
            }
            for (String tabDisplayName : BuiltInRegistries.CREATIVE_MODE_TAB.stream().filter(tab -> tab.contains(stack)).map(tab -> tab.getDisplayName().getString().toLowerCase(Locale.ROOT)).toList()) {
                if (!matcher.test(tabDisplayName, search)) continue;
                return true;
            }
            ResourceLocation itemName = BuiltInRegistries.ITEM.getKey((Object)item);
            @Nullable String modDisplayName = this.zeta().getModDisplayName(itemName.getNamespace());
            if (modDisplayName != null && matcher.test(modDisplayName.toLowerCase(Locale.ROOT), search)) {
                return true;
            }
            return matcher.test(name, search);
        }

        private static interface StringMatcher
        extends BiPredicate<String, String> {
        }
    }
}

