/*
 * Decompiled with CFR 0.152.
 */
package org.violetmoon.quark.base.client.config;

import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.PauseScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.TitleScreen;
import net.minecraft.client.resources.language.I18n;
import org.jetbrains.annotations.Nullable;
import org.violetmoon.quark.base.client.config.QButton;
import org.violetmoon.quark.base.config.QuarkGeneralConfig;
import org.violetmoon.zeta.client.event.play.ZScreen;
import org.violetmoon.zeta.event.bus.PlayEvent;

public class QButtonHandler {
    @PlayEvent
    public static void onGuiInit(ZScreen.Init.Post event) {
        if (!QuarkGeneralConfig.enableQButton) {
            return;
        }
        Set<String> targetButtonTranslationKeys = QButtonHandler.getTargetButtons(event.getScreen());
        if (targetButtonTranslationKeys == null || targetButtonTranslationKeys.isEmpty()) {
            return;
        }
        Set targetButtonNames = targetButtonTranslationKeys.stream().map(x$0 -> I18n.m_118938_((String)x$0, (Object[])new Object[0])).collect(Collectors.toSet());
        List listeners = event.getListenersList();
        for (GuiEventListener listener : listeners) {
            AbstractWidget widget;
            if (!(listener instanceof AbstractWidget) || !targetButtonNames.contains((widget = (AbstractWidget)listener).m_6035_().getString())) continue;
            int x = widget.m_252754_();
            x = QuarkGeneralConfig.qButtonOnRight ? (x += widget.m_5711_() + 4) : (x -= 24);
            QButton qButton = new QButton(x, widget.m_252907_());
            event.addListener((GuiEventListener)qButton);
            return;
        }
    }

    @Nullable
    private static Set<String> getTargetButtons(Screen gui) {
        if (gui instanceof TitleScreen) {
            if (QuarkGeneralConfig.qButtonOnRight) {
                return Set.of("menu.online");
            }
            return Set.of("fml.menu.mods.title", "fml.menu.mods");
        }
        if (gui instanceof PauseScreen) {
            if (QuarkGeneralConfig.qButtonOnRight) {
                return Set.of("menu.shareToLan", "menu.playerReporting");
            }
            return Set.of("menu.options");
        }
        return null;
    }
}

