/*
 * Decompiled with CFR 0.152.
 */
package org.violetmoon.quark.content.tweaks.client.screen;

import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import org.violetmoon.quark.base.client.handler.ClientUtil;
import org.violetmoon.quark.content.tweaks.client.emote.EmoteDescriptor;

public final class NotButton {
    private final int x;
    private final int y;
    private final int width;
    private final int height;
    private final Object label;
    private final Runnable onClick;
    private boolean oldMouseDown;

    public NotButton(int x, int y, int width, int height, Object label, Runnable onClick) {
        this.x = x;
        this.y = y;
        this.width = width;
        this.height = height;
        this.label = label;
        this.onClick = onClick;
    }

    public void draw(GuiGraphics gfx, int mouseX, int mouseY, boolean mouseDown) {
        boolean hovered = mouseX >= this.x && mouseY >= this.y && mouseX < this.x + this.width && mouseY < this.y + this.height;
        RenderSystem.enableBlend();
        RenderSystem.enableDepthTest();
        int bgColor = Minecraft.m_91087_().f_91066_.m_92143_(hovered ? -1610612736 : Integer.MIN_VALUE);
        gfx.m_280509_(this.x, this.y, this.x + this.width, this.y + this.height, bgColor);
        gfx.m_280246_(1.0f, 1.0f, 1.0f, 1.0f);
        Object object = this.label;
        if (object instanceof Component) {
            Component comp = (Component)object;
            this.drawTextLabel(gfx, comp);
        } else {
            object = this.label;
            if (object instanceof String) {
                String s = (String)object;
                this.drawTextLabel(gfx, (Component)Component.m_237113_((String)s));
            } else {
                object = this.label;
                if (object instanceof EmoteDescriptor) {
                    EmoteDescriptor emote = (EmoteDescriptor)object;
                    this.drawEmote(gfx, emote, hovered);
                }
            }
        }
        if (!this.oldMouseDown && mouseDown && hovered) {
            this.onClick.run();
        }
        this.oldMouseDown = mouseDown;
    }

    void drawTextLabel(GuiGraphics gfx, Component blah) {
        gfx.m_280653_(Minecraft.m_91087_().f_91062_, blah, (this.x + this.x + this.width) / 2, (this.y + this.y + this.height) / 2 - 4, -1);
    }

    void drawEmote(GuiGraphics guiGraphics, EmoteDescriptor desc, boolean hovered) {
        Minecraft mc = Minecraft.m_91087_();
        RenderSystem.setShader(GameRenderer::m_172817_);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        guiGraphics.m_280163_(desc.texture, this.x + 4, this.y + 4, 0.0f, 0.0f, 16, 16, 16, 16);
        ResourceLocation tierTexture = desc.getTierTexture();
        if (tierTexture != null) {
            guiGraphics.m_280163_(tierTexture, this.x + 4, this.y + 4, 0.0f, 0.0f, 16, 16, 16, 16);
        }
        if (hovered) {
            String name = desc.getLocalizedName();
            ClientUtil.drawChatBubble(guiGraphics, this.x, this.y, mc.f_91062_, name, 1.0f, false);
        }
    }
}

