/*
 * Decompiled with CFR 0.152.
 */
package org.violetmoon.quark.content.building.block;

import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.NoteBlockInstrument;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.MapColor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.violetmoon.quark.content.building.module.RainbowLampsModule;
import org.violetmoon.zeta.block.ZetaGlassBlock;
import org.violetmoon.zeta.module.ZetaModule;

public class RainbowLampBlock
extends ZetaGlassBlock {
    public final float[] colorComponents;
    public static final BooleanProperty LIT = BlockStateProperties.f_61443_;
    private String corundumDescriptionId;

    public RainbowLampBlock(String regname, int color, @Nullable ZetaModule module, MapColor mapColor) {
        super(regname, module, true, BlockBehaviour.Properties.m_284310_().m_60913_(0.3f, 0.0f).m_284180_(mapColor).m_280658_(NoteBlockInstrument.HAT).m_60918_(SoundType.f_154654_).m_60953_(b -> (Boolean)b.m_61143_((Property)LIT) != false ? RainbowLampsModule.lightLevel : 0).m_60955_());
        float r = (float)(color >> 16 & 0xFF) / 255.0f;
        float g = (float)(color >> 8 & 0xFF) / 255.0f;
        float b2 = (float)(color & 0xFF) / 255.0f;
        this.colorComponents = new float[]{r, g, b2};
        if (module == null) {
            return;
        }
        this.setCreativeTab(CreativeModeTabs.f_257028_);
        this.setCreativeTab(CreativeModeTabs.f_256725_);
    }

    @NotNull
    public String m_7705_() {
        if (RainbowLampsModule.isCorundum()) {
            if (this.corundumDescriptionId == null) {
                this.corundumDescriptionId = super.m_7705_().replaceAll("crystal", "corundum");
            }
            return this.corundumDescriptionId;
        }
        return super.m_7705_();
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext ctx) {
        return (BlockState)this.m_49966_().m_61124_((Property)LIT, (Comparable)Boolean.valueOf(ctx.m_43725_().m_276867_(ctx.m_8083_())));
    }

    public void m_6861_(@NotNull BlockState state, @NotNull Level world, @NotNull BlockPos pos, @NotNull Block blockIn, @NotNull BlockPos fromPos, boolean isMoving) {
        boolean flag;
        if (!world.f_46443_ && (flag = ((Boolean)state.m_61143_((Property)LIT)).booleanValue()) != world.m_276867_(pos)) {
            if (flag) {
                world.m_186460_(pos, (Block)this, 4);
            } else {
                world.m_7731_(pos, (BlockState)state.m_61122_((Property)LIT), 2);
            }
        }
    }

    public void m_213897_(@NotNull BlockState state, @NotNull ServerLevel world, @NotNull BlockPos pos, @NotNull RandomSource rand) {
        if (((Boolean)state.m_61143_((Property)LIT)).booleanValue() && !world.m_276867_(pos)) {
            world.m_7731_(pos, (BlockState)state.m_61122_((Property)LIT), 2);
        }
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{LIT});
    }

    @Nullable
    public float[] getBeaconColorMultiplierZeta(BlockState state, LevelReader world, BlockPos pos, BlockPos beaconPos) {
        return (Boolean)state.m_61143_((Property)LIT) != false ? this.colorComponents : null;
    }
}

