/*
 * Decompiled with CFR 0.152.
 */
package org.violetmoon.quark.content.mobs.client.model;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Mth;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;
import org.violetmoon.quark.content.mobs.entity.Shiba;

public class ShibaModel
extends EntityModel<Shiba> {
    private final ModelPart main;
    private final ModelPart head;
    private final ModelPart rEar;
    private final ModelPart lEar;
    private final ModelPart tongue;
    private final ModelPart torso;
    private final ModelPart tail;
    private final ModelPart rFrontLeg;
    private final ModelPart lFrontLeg;
    private final ModelPart rBackLeg;
    private final ModelPart lBackLeg;
    private boolean sleeping = false;

    public ShibaModel(ModelPart root) {
        this.main = root.m_171324_("main");
        this.head = this.main.m_171324_("head");
        this.rEar = this.head.m_171324_("rEar");
        this.lEar = this.head.m_171324_("lEar");
        this.tongue = this.head.m_171324_("tongue");
        this.torso = this.main.m_171324_("torso");
        this.tail = this.torso.m_171324_("tail");
        this.rFrontLeg = this.main.m_171324_("rFrontLeg");
        this.lFrontLeg = this.main.m_171324_("lFrontLeg");
        this.rBackLeg = this.main.m_171324_("rBackLeg");
        this.lBackLeg = this.main.m_171324_("lBackLeg");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition mesh = new MeshDefinition();
        PartDefinition root = mesh.m_171576_();
        PartDefinition main = root.m_171599_("main", CubeListBuilder.m_171558_(), PartPose.f_171404_);
        PartDefinition head = main.m_171599_("head", CubeListBuilder.m_171558_().m_171514_(16, 0).m_171481_(-4.0f, -10.0f, -4.0f, 8.0f, 11.0f, 6.0f).m_171514_(44, 0).m_171481_(-1.5f, -6.0f, -8.0f, 3.0f, 3.0f, 4.0f), PartPose.m_171419_((float)0.0f, (float)15.0f, (float)-5.0f));
        head.m_171599_("rEar", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171481_(-1.0f, 0.0f, -3.0f, 2.0f, 2.0f, 3.0f), PartPose.m_171419_((float)3.0f, (float)-12.0f, (float)2.0f));
        head.m_171599_("lEar", CubeListBuilder.m_171558_().m_171480_().m_171514_(0, 0).m_171481_(-1.0f, 0.0f, -3.0f, 2.0f, 2.0f, 3.0f), PartPose.m_171419_((float)-3.0f, (float)-12.0f, (float)2.0f));
        head.m_171599_("tongue", CubeListBuilder.m_171558_().m_171514_(36, 34).m_171481_(-1.0f, 0.0f, -3.0f, 2.0f, 0.0f, 3.0f), PartPose.m_171419_((float)0.0f, (float)-4.0f, (float)-8.0f));
        PartDefinition torso = main.m_171599_("torso", CubeListBuilder.m_171558_().m_171514_(36, 10).m_171481_(-3.0f, 0.0f, -4.0f, 6.0f, 14.0f, 8.0f), PartPose.m_171419_((float)0.0f, (float)13.0f, (float)-7.0f));
        torso.m_171599_("tail", CubeListBuilder.m_171558_().m_171514_(0, 32).m_171481_(-2.0f, -3.0f, -3.0f, 4.0f, 6.0f, 6.0f), PartPose.m_171419_((float)0.0f, (float)14.0f, (float)4.0f));
        main.m_171599_("rFrontLeg", CubeListBuilder.m_171558_().m_171514_(0, 21).m_171481_(-2.0f, 0.0f, -1.0f, 3.0f, 8.0f, 3.0f), PartPose.m_171419_((float)3.0f, (float)16.0f, (float)-5.0f));
        main.m_171599_("lFrontLeg", CubeListBuilder.m_171558_().m_171480_().m_171514_(0, 21).m_171481_(-1.0f, 0.0f, -1.0f, 3.0f, 8.0f, 3.0f), PartPose.m_171419_((float)-3.0f, (float)16.0f, (float)-5.0f));
        main.m_171599_("rBackLeg", CubeListBuilder.m_171558_().m_171514_(12, 18).m_171481_(-2.0f, -1.0f, -2.0f, 3.0f, 10.0f, 4.0f), PartPose.m_171419_((float)3.0f, (float)15.0f, (float)4.0f));
        main.m_171599_("lBackLeg", CubeListBuilder.m_171558_().m_171480_().m_171514_(12, 18).m_171481_(-1.0f, -1.0f, -2.0f, 3.0f, 10.0f, 4.0f), PartPose.m_171419_((float)-3.0f, (float)15.0f, (float)4.0f));
        return LayerDefinition.m_171565_((MeshDefinition)mesh, (int)80, (int)48);
    }

    public void transformToHead(PoseStack matrix) {
        this.head.m_104299_(matrix);
    }

    public void prepareMobModel(@NotNull Shiba shiba, float limbSwing, float limbSwingAmount, float partialTickTime) {
        BlockState state = shiba.m_146900_();
        this.sleeping = state.m_204336_(BlockTags.f_13038_);
        this.setRotationAngle(this.rFrontLeg, Mth.m_14089_((float)(limbSwing * 0.6662f)) * 1.4f * limbSwingAmount, 0.0f, 0.0f);
        this.setRotationAngle(this.lFrontLeg, Mth.m_14089_((float)(limbSwing * 0.6662f + (float)Math.PI)) * 1.4f * limbSwingAmount, 0.0f, 0.0f);
        this.setRotationAngle(this.rBackLeg, Mth.m_14089_((float)(limbSwing * 0.6662f + (float)Math.PI)) * 1.4f * limbSwingAmount, 0.0f, 0.0f);
        this.setRotationAngle(this.lBackLeg, Mth.m_14089_((float)(limbSwing * 0.6662f)) * 1.4f * limbSwingAmount, 0.0f, 0.0f);
    }

    public void setupAnim(Shiba shiba, float limbSwing, float limbSwingAmount, float ageInTicks, float yaw, float pitch) {
        this.main.m_104227_(0.0f, 0.0f, 0.0f);
        this.lBackLeg.m_104227_(-3.0f, 15.0f, 4.0f);
        this.rBackLeg.m_104227_(3.0f, 15.0f, 4.0f);
        this.setRotationAngle(this.main, 0.0f, 0.0f, 0.0f);
        this.setRotationAngle(this.torso, 1.5708f, 0.0f, 0.0f);
        this.setRotationAngle(this.head, Mth.m_14089_((float)(ageInTicks * 0.6f)) * 0.01f, yaw * ((float)Math.PI / 180), Mth.m_14031_((float)(ageInTicks * 0.06f)) * 0.06f);
        this.setRotationAngle(this.tail, Mth.m_14089_((float)(ageInTicks * 0.1f)) * 0.1f, Mth.m_14031_((float)(ageInTicks * 0.15f)) * 0.12f, Mth.m_14089_((float)(ageInTicks * 0.3f)) * 0.2f);
        this.setRotationAngle(this.lEar, 0.0f, Mth.m_14089_((float)(ageInTicks * 0.08f)) * 0.05f - 0.05f, 0.0f);
        this.setRotationAngle(this.rEar, 0.0f, Mth.m_14031_((float)(ageInTicks * 0.07f)) * 0.05f + 0.05f, 0.0f);
        boolean tongueOut = false;
        BlockState state = shiba.m_146900_();
        boolean sleep = state.m_204336_(BlockTags.f_13038_);
        if (shiba.m_21825_()) {
            tongueOut = true;
            if (sleep) {
                this.main.m_104227_(16.0f, 18.0f, 0.0f);
                this.setRotationAngle(this.main, 0.0f, 0.0f, 1.5708f);
                this.setRotationAngle(this.lBackLeg, Mth.m_14089_((float)(ageInTicks * 0.2f)) * 0.1f, 0.0f, Mth.m_14031_((float)(ageInTicks * 0.18f)) * 0.12f);
                this.setRotationAngle(this.rBackLeg, Mth.m_14031_((float)(ageInTicks * 0.22f)) * 0.08f, 0.0f, Mth.m_14089_((float)(ageInTicks * 0.16f)) * 0.11f);
                this.setRotationAngle(this.rFrontLeg, Mth.m_14089_((float)(ageInTicks * 0.19f)) * 0.1f, 0.0f, Mth.m_14031_((float)(ageInTicks * 0.21f)) * 0.12f);
                this.setRotationAngle(this.lFrontLeg, Mth.m_14031_((float)(ageInTicks * 0.18f)) * 0.08f, 0.0f, Mth.m_14089_((float)(ageInTicks * 0.2f)) * 0.11f);
            } else {
                this.setRotationAngle(this.torso, 1.0f, 0.0f, 0.0f);
                this.lBackLeg.m_104227_(-3.0f, 19.0f, 2.0f);
                this.rBackLeg.m_104227_(3.0f, 19.0f, 2.0f);
                this.setRotationAngle(this.lBackLeg, -1.0f, -0.5f, 0.0f);
                this.setRotationAngle(this.rBackLeg, -1.0f, -0.5f, 0.0f);
                this.setRotationAngle(this.lFrontLeg, -0.5f, 0.5f, 0.0f);
                this.setRotationAngle(this.rFrontLeg, -0.5f, 0.5f, 0.0f);
            }
        }
        if (tongueOut && shiba.getMouthItem().m_41619_()) {
            this.tongue.m_104227_(0.0f, -4.0f, -6.75f + Mth.m_14089_((float)(ageInTicks * 0.19f)) * 0.25f);
            this.setRotationAngle(this.tongue, Mth.m_14089_((float)(ageInTicks * 0.19f)) * 0.1f + 0.2f, 0.0f, 0.0f);
        } else {
            this.tongue.m_104227_(0.0f, -4.0f, -5.0f);
            this.setRotationAngle(this.tongue, 0.0f, 0.0f, 0.0f);
        }
    }

    public void m_7695_(PoseStack matrixStack, @NotNull VertexConsumer buffer, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        matrixStack.m_85836_();
        if (this.sleeping) {
            matrixStack.m_85837_(0.0, 0.12, 0.0);
        }
        this.main.m_104299_(matrixStack);
        matrixStack.m_85836_();
        if (this.f_102610_) {
            matrixStack.m_252880_(0.0f, 0.3125f, 0.0f);
        }
        this.head.m_104306_(matrixStack, buffer, packedLight, packedOverlay, red, green, blue, alpha);
        matrixStack.m_85849_();
        matrixStack.m_85836_();
        if (this.f_102610_) {
            matrixStack.m_252880_(0.0f, 0.75f, 0.0f);
            matrixStack.m_85841_(0.5f, 0.5f, 0.5f);
        }
        this.torso.m_104301_(matrixStack, buffer, packedLight, packedOverlay);
        this.rFrontLeg.m_104301_(matrixStack, buffer, packedLight, packedOverlay);
        this.rBackLeg.m_104301_(matrixStack, buffer, packedLight, packedOverlay);
        this.lFrontLeg.m_104301_(matrixStack, buffer, packedLight, packedOverlay);
        this.lBackLeg.m_104301_(matrixStack, buffer, packedLight, packedOverlay);
        matrixStack.m_85849_();
        matrixStack.m_85849_();
    }

    public void setRotationAngle(ModelPart modelRenderer, float x, float y, float z) {
        modelRenderer.f_104203_ = x;
        modelRenderer.f_104204_ = y;
        modelRenderer.f_104205_ = z;
    }
}

