/*
 * Decompiled with CFR 0.152.
 */
package org.violetmoon.quark.content.world.feature;

import java.util.Arrays;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.data.worldgen.placement.PlacementUtils;
import net.minecraft.util.RandomSource;
import net.minecraft.util.valueproviders.ConstantInt;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.levelgen.blockpredicates.BlockPredicate;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;
import net.minecraft.world.level.levelgen.placement.BiomeFilter;
import net.minecraft.world.level.levelgen.placement.CountPlacement;
import net.minecraft.world.level.levelgen.placement.EnvironmentScanPlacement;
import net.minecraft.world.level.levelgen.placement.InSquarePlacement;
import net.minecraft.world.level.levelgen.placement.PlacementModifier;
import net.minecraft.world.level.levelgen.placement.RandomOffsetPlacement;
import org.violetmoon.quark.content.world.block.HugeGlowShroomBlock;
import org.violetmoon.quark.content.world.module.GlimmeringWealdModule;

public class GlowShroomsFeature
extends Feature<NoneFeatureConfiguration> {
    public GlowShroomsFeature() {
        super(NoneFeatureConfiguration.CODEC);
    }

    public static List<PlacementModifier> placed() {
        return Arrays.asList(CountPlacement.of((int)125), InSquarePlacement.spread(), PlacementUtils.RANGE_BOTTOM_TO_MAX_TERRAIN_HEIGHT, EnvironmentScanPlacement.scanningFor((Direction)Direction.DOWN, (BlockPredicate)BlockPredicate.solid(), (BlockPredicate)BlockPredicate.ONLY_IN_AIR_PREDICATE, (int)12), RandomOffsetPlacement.vertical((IntProvider)ConstantInt.of((int)1)), BiomeFilter.biome());
    }

    public boolean place(FeaturePlaceContext<NoneFeatureConfiguration> config) {
        WorldGenLevel worldgenlevel = config.level();
        BlockPos blockpos = config.origin();
        RandomSource rng = config.random();
        BlockPos.MutableBlockPos setPos = new BlockPos.MutableBlockPos(blockpos.getX(), blockpos.getY(), blockpos.getZ());
        for (int i = -6; i < 7; ++i) {
            for (int j = -6; j < 7; ++j) {
                for (int k = -2; k < 3; ++k) {
                    boolean placeSmall;
                    double chance;
                    setPos.set(blockpos.getX() + i, blockpos.getY() + k, blockpos.getZ() + j);
                    double dist = blockpos.distSqr((Vec3i)setPos);
                    if (dist > 10.0 && ((chance = 1.0 - (dist - 10.0) / 10.0) < 0.0 || rng.nextDouble() < chance) || !worldgenlevel.isStateAtPosition((BlockPos)setPos, s -> s.getBlock() == Blocks.DEEPSLATE) || !worldgenlevel.isStateAtPosition(setPos.above(), BlockBehaviour.BlockStateBase::isAir) || !(rng.nextDouble() < 0.08)) continue;
                    boolean bl = placeSmall = !HugeGlowShroomBlock.place((LevelAccessor)worldgenlevel, rng, setPos.above());
                    if (!placeSmall) continue;
                    worldgenlevel.setBlock(setPos.above(), GlimmeringWealdModule.glow_shroom.defaultBlockState(), 2);
                }
            }
        }
        return true;
    }
}

