/*
 * Decompiled with CFR 0.152.
 */
package org.violetmoon.quark.content.experimental.module;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.BaseSpawner;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.SpawnerBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import org.violetmoon.zeta.config.Config;
import org.violetmoon.zeta.event.bus.LoadEvent;
import org.violetmoon.zeta.event.load.ZConfigChanged;
import org.violetmoon.zeta.module.ZetaLoadModule;
import org.violetmoon.zeta.module.ZetaModule;

@ZetaLoadModule(category="experimental", enabledByDefault=false)
public class SpawnerReplacerModule
extends ZetaModule {
    @Config(description="Mobs to be replaced with other mobs.\nFormat is: \"mob1,mob2\", i.e. \"minecraft:spider,minecraft:skeleton\"")
    public static List<String> replaceMobs = Lists.newArrayList();
    private static boolean staticEnabled;
    private static final Map<EntityType<?>, EntityType<?>> spawnerReplacements;

    @LoadEvent
    public final void configChanged(ZConfigChanged event) {
        staticEnabled = this.isEnabled();
        spawnerReplacements.clear();
        for (String replaceKey : replaceMobs) {
            String[] split = replaceKey.split(",");
            if (split.length != 2) continue;
            Optional before = EntityType.byString((String)split[0]);
            Optional after = EntityType.byString((String)split[1]);
            if (!before.isPresent() || !after.isPresent()) continue;
            spawnerReplacements.put((EntityType)before.get(), (EntityType)after.get());
        }
    }

    public static void spawnerUpdate(Level level, BlockPos pos, BlockState state, SpawnerBlockEntity be) {
        EntityType present;
        if (!staticEnabled || level.isClientSide()) {
            return;
        }
        BaseSpawner spawner = be.getSpawner();
        Entity example = spawner.getOrCreateDisplayEntity(level, pos);
        if (example != null && spawnerReplacements.containsKey(present = example.getType())) {
            spawner.setEntityId(spawnerReplacements.get(present), level, level.getRandom(), pos);
            be.setChanged();
            level.sendBlockUpdated(pos, state, state, 3);
        }
    }

    static {
        spawnerReplacements = Maps.newHashMap();
    }
}

