/*
 * Decompiled with CFR 0.152.
 */
package org.violetmoon.quark.base.client.render;

import com.google.common.base.Functions;
import com.google.common.collect.ImmutableMap;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.client.model.BoatModel;
import net.minecraft.client.model.ChestBoatModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.vehicle.Boat;
import org.jetbrains.annotations.NotNull;
import org.joml.Quaternionf;
import org.violetmoon.quark.base.Quark;
import org.violetmoon.quark.base.client.handler.ModelHandler;
import org.violetmoon.quark.base.handler.WoodSetHandler;
import org.violetmoon.quark.base.item.boat.IQuarkBoat;

public class QuarkBoatRenderer
extends EntityRenderer<Boat> {
    private final Map<String, BoatModelTuple> boatResources;

    public QuarkBoatRenderer(EntityRendererProvider.Context context, boolean chest) {
        super(context);
        this.shadowRadius = 0.8f;
        this.boatResources = QuarkBoatRenderer.computeBoatResources(chest, context);
    }

    private static Map<String, BoatModelTuple> computeBoatResources(boolean chest, EntityRendererProvider.Context context) {
        return (Map)WoodSetHandler.boatTypes().collect(ImmutableMap.toImmutableMap((Function)Functions.identity(), name -> {
            String folder = chest ? "chest_boat" : "boat";
            ResourceLocation texture = Quark.asResource("textures/model/entity/" + folder + "/" + name + ".png");
            ChestBoatModel model = chest ? new ChestBoatModel(context.bakeLayer(ModelHandler.quark_boat_chest)) : new BoatModel(context.bakeLayer(ModelHandler.quark_boat));
            return new BoatModelTuple(texture, (BoatModel)model);
        }));
    }

    public void render(Boat boat, float yaw, float partialTicks, PoseStack matrix, @NotNull MultiBufferSource buffer, int light) {
        float f2;
        matrix.pushPose();
        matrix.translate(0.0, 0.375, 0.0);
        matrix.mulPose(Axis.YP.rotationDegrees(180.0f - yaw));
        float wiggleAngle = (float)boat.getHurtTime() - partialTicks;
        float wiggleMagnitude = boat.getDamage() - partialTicks;
        if (wiggleMagnitude < 0.0f) {
            wiggleMagnitude = 0.0f;
        }
        if (wiggleAngle > 0.0f) {
            matrix.mulPose(Axis.XP.rotationDegrees(Mth.sin((float)wiggleAngle) * wiggleAngle * wiggleMagnitude / 10.0f * (float)boat.getHurtDir()));
        }
        if (!Mth.equal((float)(f2 = boat.getBubbleAngle(partialTicks)), (float)0.0f)) {
            matrix.mulPose(new Quaternionf().setAngleAxis(boat.getBubbleAngle(partialTicks) * ((float)Math.PI / 180), 1.0f, 0.0f, 1.0f));
        }
        BoatModelTuple tuple = this.getModelWithLocation(boat);
        ResourceLocation loc = tuple.resloc();
        BoatModel model = tuple.model();
        matrix.scale(-1.0f, -1.0f, 1.0f);
        matrix.mulPose(Axis.YP.rotationDegrees(90.0f));
        model.setupAnim(boat, partialTicks, 0.0f, -0.1f, 0.0f, 0.0f);
        VertexConsumer vertexconsumer = buffer.getBuffer(model.renderType(loc));
        model.renderToBuffer(matrix, vertexconsumer, light, OverlayTexture.NO_OVERLAY);
        if (!boat.isUnderWater()) {
            VertexConsumer waterMask = buffer.getBuffer(RenderType.waterMask());
            model.waterPatch().render(matrix, waterMask, light, OverlayTexture.NO_OVERLAY);
        }
        matrix.popPose();
        super.render((Entity)boat, yaw, partialTicks, matrix, buffer, light);
    }

    @Deprecated
    @NotNull
    public ResourceLocation getTextureLocation(@NotNull Boat boat) {
        return this.getModelWithLocation(boat).resloc();
    }

    public BoatModelTuple getModelWithLocation(Boat boat) {
        return this.boatResources.get(((IQuarkBoat)boat).getQuarkBoatTypeObj().name());
    }

    private record BoatModelTuple(ResourceLocation resloc, BoatModel model) {
    }
}

