/*
 * Decompiled with CFR 0.152.
 */
package org.violetmoon.quark.content.automation.module;

import com.google.common.collect.Lists;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.dispenser.BlockSource;
import net.minecraft.core.dispenser.DefaultDispenseItemBehavior;
import net.minecraft.core.dispenser.DispenseItemBehavior;
import net.minecraft.core.dispenser.OptionalDispenseItemBehavior;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.DirectionalPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.DispenserBlock;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.NotNull;
import org.violetmoon.zeta.config.Config;
import org.violetmoon.zeta.event.bus.LoadEvent;
import org.violetmoon.zeta.event.load.ZCommonSetup;
import org.violetmoon.zeta.module.ZetaLoadModule;
import org.violetmoon.zeta.module.ZetaModule;

@ZetaLoadModule(category="automation")
public class DispensersPlaceBlocksModule
extends ZetaModule {
    @Config
    public static List<String> blacklist = Lists.newArrayList((Object[])new String[]{"minecraft:water", "minecraft:lava", "minecraft:fire"});
    @Config(description="Set to false to refrain from registering any behaviors for blocks that have optional dispense behaviors already set.\nAn optional behavior is one that will defer to the generic dispense item behavior if its condition fails.\ne.g. the Shulker Box behavior is optional, because it'll throw out the item if it fails, whereas TNT is not optional.\nIf true, it'll attempt to use the previous behavior before trying to place the block in the world.\nRequires a game restart to re-apply.")
    public static boolean wrapExistingBehaviors = true;

    @LoadEvent
    public void setup(ZCommonSetup e) {
        if (!this.isEnabled()) {
            return;
        }
        BlockBehavior baseBehavior = new BlockBehavior();
        e.enqueueWork(() -> {
            Map registry = DispenserBlock.DISPENSER_REGISTRY;
            for (Block b : BuiltInRegistries.BLOCK) {
                boolean exists;
                Item item;
                ResourceLocation res = BuiltInRegistries.BLOCK.getKey((Object)b);
                if (blacklist.contains(Objects.toString(res)) || !((item = b.asItem()) instanceof BlockItem)) continue;
                DispenseItemBehavior original = (DispenseItemBehavior)registry.get(item);
                boolean bl = exists = original != null && original.getClass() != DefaultDispenseItemBehavior.class;
                if (original instanceof BlockBehavior) continue;
                if (exists) {
                    if (!wrapExistingBehaviors || !(original instanceof OptionalDispenseItemBehavior)) continue;
                    OptionalDispenseItemBehavior opt = (OptionalDispenseItemBehavior)original;
                    registry.put(item, new BlockBehavior(opt));
                    continue;
                }
                registry.put(item, baseBehavior);
            }
        });
    }

    public static class BlockBehavior
    extends OptionalDispenseItemBehavior {
        private final OptionalDispenseItemBehavior wrapped;

        public BlockBehavior() {
            this(null);
        }

        public BlockBehavior(OptionalDispenseItemBehavior wrapped) {
            this.wrapped = wrapped;
        }

        @NotNull
        public ItemStack execute(BlockSource source, ItemStack stack) {
            Direction direction;
            if (this.wrapped != null) {
                ItemStack wrappedResult = this.wrapped.dispense(source, stack);
                if (this.wrapped.isSuccess()) {
                    this.setSuccess(true);
                    return wrappedResult;
                }
            }
            this.setSuccess(false);
            Direction against = direction = (Direction)source.state().getValue((Property)DispenserBlock.FACING);
            BlockPos pos = source.pos().relative(direction);
            Item item = stack.getItem();
            if (item instanceof BlockItem) {
                BlockItem item2 = (BlockItem)item;
                Block block = item2.getBlock();
                if (block instanceof StairBlock && direction.getAxis() != Direction.Axis.Y) {
                    direction = direction.getOpposite();
                } else if (block instanceof SlabBlock) {
                    against = Direction.UP;
                }
                this.setSuccess(item2.place((BlockPlaceContext)new NotStupidDirectionalPlaceContext((Level)source.level(), pos, direction, stack, against)).consumesAction());
            }
            return stack;
        }
    }

    private static class NotStupidDirectionalPlaceContext
    extends DirectionalPlaceContext {
        protected boolean replaceClicked;
        protected Direction direction;

        public NotStupidDirectionalPlaceContext(Level worldIn, BlockPos pos, Direction facing, ItemStack stack, Direction against) {
            super(worldIn, pos, facing, stack, against);
            this.replaceClicked = worldIn.getBlockState(this.getHitResult().getBlockPos()).canBeReplaced((BlockPlaceContext)this);
            this.direction = facing;
        }

        public boolean canPlace() {
            return this.replaceClicked;
        }

        @NotNull
        public Direction getNearestLookingDirection() {
            return this.direction.getOpposite();
        }
    }
}

