/*
 * Decompiled with CFR 0.152.
 */
package org.violetmoon.quark.content.automation.client.render;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.piston.PistonMovingBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import org.violetmoon.quark.base.Quark;
import org.violetmoon.quark.content.automation.module.PistonsMoveTileEntitiesModule;

public class QuarkPistonBlockEntityRenderer {
    public static boolean renderPistonBlock(PistonMovingBlockEntity piston, float partialTicks, PoseStack matrix, MultiBufferSource bufferIn, int combinedLightIn, int combinedOverlayIn) {
        if (!PistonsMoveTileEntitiesModule.staticEnabled || piston.getProgress(partialTicks) > 1.0f) {
            return false;
        }
        BlockState state = piston.getMovedState();
        BlockPos truePos = piston.getBlockPos();
        Block block = state.getBlock();
        if (!(block instanceof EntityBlock)) {
            return false;
        }
        EntityBlock eb = (EntityBlock)block;
        BlockEntity tile = eb.newBlockEntity(truePos, state);
        if (tile == null) {
            return false;
        }
        CompoundTag tileTag = PistonsMoveTileEntitiesModule.getMovingBlockEntityData(piston.getLevel(), truePos);
        if (tileTag != null && tile.getType() == BuiltInRegistries.BLOCK_ENTITY_TYPE.get(ResourceLocation.parse((String)tileTag.getString("id")))) {
            tile.loadWithComponents(tileTag, (HolderLookup.Provider)piston.getLevel().registryAccess());
        }
        Vec3 offset = new Vec3((double)piston.getXOff(partialTicks), (double)piston.getYOff(partialTicks), (double)piston.getZOff(partialTicks));
        return QuarkPistonBlockEntityRenderer.renderTESafely(piston.getLevel(), truePos, state, tile, (BlockEntity)piston, partialTicks, offset, matrix, bufferIn, combinedLightIn, combinedOverlayIn);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean renderTESafely(Level world, BlockPos truePos, BlockState state, BlockEntity tile, BlockEntity sourceTE, float partialTicks, Vec3 offset, PoseStack matrix, MultiBufferSource bufferIn, int combinedLightIn, int combinedOverlayIn) {
        Block block = state.getBlock();
        String id = Objects.toString(BuiltInRegistries.BLOCK.getKey((Object)block));
        PoseStack.Pose currEntry = matrix.last();
        try {
            if (tile != null && block != Blocks.PISTON_HEAD && !PistonsMoveTileEntitiesModule.renderBlacklist.contains(id)) {
                matrix.pushPose();
                Minecraft mc = Minecraft.getInstance();
                BlockEntityRenderer tileentityrenderer = mc.getBlockEntityRenderDispatcher().getRenderer(tile);
                if (tileentityrenderer != null) {
                    tile.setLevel(sourceTE.getLevel());
                    tile.clearRemoved();
                    matrix.translate(offset.x, offset.y, offset.z);
                    tile.setBlockState(state);
                    tileentityrenderer.render(tile, partialTicks, matrix, bufferIn, combinedLightIn, combinedOverlayIn);
                }
            }
        }
        catch (Exception e) {
            Quark.LOG.warn("{} can't be rendered for piston TE moving", (Object)id, (Object)e);
            PistonsMoveTileEntitiesModule.renderBlacklist.add(id);
            boolean bl = false;
            return bl;
        }
        finally {
            while (matrix.last() != currEntry) {
                matrix.popPose();
            }
        }
        return state.getRenderShape() != RenderShape.MODEL;
    }
}

