/*
 * Decompiled with CFR 0.152.
 */
package org.violetmoon.quark.catnip.net.base;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.ModList;
import net.neoforged.neoforge.network.registration.PayloadRegistrar;
import org.violetmoon.quark.catnip.net.base.BasePacketPayload;
import org.violetmoon.quark.catnip.net.base.ClientboundPacketPayload;
import org.violetmoon.quark.catnip.net.base.ServerboundPacketPayload;

public class CatnipPacketRegistry {
    public final String modId;
    public final String networkVersion;
    private final Set<PacketType<?>> packets = new HashSet();
    public final Set<PacketType<?>> packetsView = Collections.unmodifiableSet(this.packets);
    private boolean packetsRegistered = false;

    public CatnipPacketRegistry(String modId, int networkVersion) {
        this(modId, String.valueOf(networkVersion));
    }

    public CatnipPacketRegistry(String modId, String networkVersion) {
        this.modId = modId;
        this.networkVersion = networkVersion;
    }

    public void registerPacket(PacketType<?> packetType) {
        if (this.packetsRegistered) {
            throw new IllegalStateException("Cannot register more packets after registerAllPackets() has been called!");
        }
        this.packets.add(packetType);
    }

    public void registerAllPackets() {
        if (this.packetsRegistered) {
            throw new IllegalStateException("Cannot call registerAllPackets() more than once!");
        }
        ModContainer container = (ModContainer)ModList.get().getModContainerById(this.modId).orElseThrow();
        container.getEventBus().addListener(e -> {
            PayloadRegistrar registrar = e.registrar(this.networkVersion);
            for (PacketType<?> type : this.packetsView) {
                PacketType<?> casted;
                boolean clientbound = ClientboundPacketPayload.class.isAssignableFrom(type.clazz());
                boolean serverbound = ServerboundPacketPayload.class.isAssignableFrom(type.clazz());
                if (clientbound && serverbound) {
                    throw new IllegalStateException("Packet class is both clientbound and serverbound: " + String.valueOf(type.clazz()));
                }
                if (clientbound) {
                    casted = type;
                    registrar.playToClient(casted.type(), casted.codec(), (payload, ctx) -> ctx.enqueueWork(() -> payload.handleInternal(ctx.player())));
                    continue;
                }
                if (!serverbound) continue;
                casted = type;
                registrar.playToServer(casted.type(), casted.codec(), (payload, ctx) -> ctx.enqueueWork(() -> payload.handle((ServerPlayer)ctx.player())));
            }
        });
        this.packetsRegistered = true;
    }

    public record PacketType<T extends BasePacketPayload>(CustomPacketPayload.Type<T> type, Class<T> clazz, StreamCodec<? super RegistryFriendlyByteBuf, T> codec) {
    }
}

