/*
 * Decompiled with CFR 0.152.
 */
package org.violetmoon.quark.addons.oddities.inventory;

import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.violetmoon.quark.addons.oddities.inventory.BackpackContainer;
import org.violetmoon.quark.addons.oddities.inventory.slot.BackpackSlot;
import org.violetmoon.quark.addons.oddities.inventory.slot.CachedItemHandlerSlot;
import org.violetmoon.quark.addons.oddities.module.BackpackModule;

public class BackpackMenu
extends InventoryMenu {
    public BackpackMenu(int windowId, Player player) {
        super(player.getInventory(), !player.level().isClientSide, player);
        this.containerId = windowId;
        Inventory inventory = player.getInventory();
        for (Slot slot : this.slots) {
            if (slot.container != inventory || slot.getSlotIndex() >= inventory.getContainerSize() - 5) continue;
            slot.y += 58;
        }
        Slot anchor = (Slot)this.slots.get(9);
        int left = anchor.x;
        int top = anchor.y - 58;
        ItemStack backpack = (ItemStack)inventory.armor.get(2);
        if (backpack.getItem() == BackpackModule.backpack) {
            BackpackContainer backpackInv = new BackpackContainer(backpack);
            for (int i = 0; i < 3; ++i) {
                for (int j = 0; j < 9; ++j) {
                    int k = j + i * 9;
                    this.addSlot(new BackpackSlot(backpackInv, k, left + j * 18, top + i * 18));
                }
            }
        }
    }

    public static BackpackMenu fromNetwork(int windowId, Inventory playerInventory, FriendlyByteBuf buf) {
        return new BackpackMenu(windowId, playerInventory.player);
    }

    @NotNull
    public ItemStack quickMoveStack(@NotNull Player playerIn, int index) {
        int topSlots = 8;
        int invStart = 9;
        int invEnd = 36;
        int hotbarEnd = 45;
        int backpackStart = 46;
        int backpackEnd = 73;
        ItemStack baseStack = ItemStack.EMPTY;
        Slot slot = (Slot)this.slots.get(index);
        if (slot.hasItem()) {
            ItemStack stack = slot.getItem();
            baseStack = stack.copy();
            EquipmentSlot slotType = playerIn.getEquipmentSlotForItem(stack);
            int equipIndex = 8 - slotType.getIndex();
            if (index < 9 || index == 45) {
                ItemStack target = null;
                if (!this.moveItemStackTo(stack, 9, 45, false) && !this.moveItemStackTo(stack, 46, 73, false)) {
                    target = ItemStack.EMPTY;
                }
                if (target != null) {
                    return target;
                }
                if (index == 0) {
                    slot.onQuickCraft(stack, baseStack);
                }
            } else if (slotType.getType() == EquipmentSlot.Type.HUMANOID_ARMOR && !((Slot)this.slots.get(equipIndex)).hasItem() ? !this.moveItemStackTo(stack, equipIndex, equipIndex + 1, false) : (slotType == EquipmentSlot.OFFHAND && !((Slot)this.slots.get(45)).hasItem() ? !this.moveItemStackTo(stack, 45, 46, false) : (index < 36 ? !this.moveItemStackTo(stack, 46, 73, false) && !this.moveItemStackTo(stack, 36, 45, false) : (index < 45 ? !this.moveItemStackTo(stack, 9, 36, false) && !this.moveItemStackTo(stack, 46, 73, false) : !this.moveItemStackTo(stack, 36, 45, false) && !this.moveItemStackTo(stack, 9, 36, false))))) {
                return ItemStack.EMPTY;
            }
            if (stack.isEmpty()) {
                slot.set(ItemStack.EMPTY);
            } else {
                slot.setChanged();
            }
            if (stack.getCount() == baseStack.getCount()) {
                return ItemStack.EMPTY;
            }
            slot.onTake(playerIn, stack);
            if (index == 0) {
                playerIn.drop(stack, false);
            }
        }
        return baseStack;
    }

    public boolean moveItemStackTo(ItemStack stack, int start, int length, boolean reversed) {
        int maxStack;
        int rmv;
        ItemStack existingStack;
        Slot slot;
        int i;
        int iterOrder;
        boolean successful = false;
        int n = iterOrder = !reversed ? 1 : -1;
        if (stack.isStackable()) {
            for (i = !reversed ? start : length - 1; stack.getCount() > 0 && (!reversed && i < length || reversed && i >= start); i += iterOrder) {
                slot = (Slot)this.slots.get(i);
                existingStack = slot.getItem();
                if (existingStack.isEmpty() || !slot.mayPlace(BackpackMenu.cloneStack(stack, rmv = Math.min(maxStack = Math.min(stack.getMaxStackSize(), slot.getMaxStackSize()), stack.getCount()))) || !existingStack.getItem().equals(stack.getItem()) || !ItemStack.isSameItemSameComponents((ItemStack)stack, (ItemStack)existingStack)) continue;
                int existingSize = existingStack.getCount() + stack.getCount();
                if (existingSize <= maxStack) {
                    stack.setCount(0);
                    existingStack.setCount(existingSize);
                    slot.set(existingStack);
                    successful = true;
                    continue;
                }
                if (existingStack.getCount() >= maxStack) continue;
                stack.shrink(maxStack - existingStack.getCount());
                existingStack.setCount(maxStack);
                slot.set(existingStack);
                successful = true;
            }
        }
        if (stack.getCount() > 0) {
            int n2 = i = !reversed ? start : length - 1;
            while (stack.getCount() > 0 && (!reversed && i < length || reversed && i >= start)) {
                slot = (Slot)this.slots.get(i);
                existingStack = slot.getItem();
                if (existingStack.isEmpty() && slot.mayPlace(BackpackMenu.cloneStack(stack, rmv = Math.min(maxStack = Math.min(stack.getMaxStackSize(), slot.getMaxStackSize()), stack.getCount())))) {
                    existingStack = stack.split(rmv);
                    slot.set(existingStack);
                    successful = true;
                }
                i += iterOrder;
            }
        }
        return successful;
    }

    public void clicked(int slotId, int dragType, @NotNull ClickType clickTypeIn, @NotNull Player player) {
        CachedItemHandlerSlot.cache((AbstractContainerMenu)this);
        super.clicked(slotId, dragType, clickTypeIn, player);
        CachedItemHandlerSlot.applyCache((AbstractContainerMenu)this);
    }

    private static ItemStack cloneStack(ItemStack stack, int size) {
        if (stack.isEmpty()) {
            return ItemStack.EMPTY;
        }
        ItemStack copy = stack.copy();
        copy.setCount(size);
        return copy;
    }

    public static void saveCraftingInventory(Player player) {
        CraftingContainer crafting = ((InventoryMenu)player.containerMenu).getCraftSlots();
        for (int i = 0; i < crafting.getContainerSize(); ++i) {
            ItemStack stack = crafting.getItem(i);
            if (stack.isEmpty() || player.addItem(stack)) continue;
            player.drop(stack, false);
        }
    }

    @NotNull
    public MenuType<?> getType() {
        return BackpackModule.menyType;
    }
}

