/*
 * Decompiled with CFR 0.152.
 */
package org.violetmoon.quark.addons.oddities.block.be;

import java.util.ArrayList;
import java.util.Collection;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.Containers;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BaseContainerBlockEntity;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.AABB;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.violetmoon.quark.addons.oddities.block.CrateBlock;
import org.violetmoon.quark.addons.oddities.inventory.CrateMenu;
import org.violetmoon.quark.addons.oddities.module.CrateModule;
import org.violetmoon.quark.base.handler.SortingHandler;

@MethodsReturnNonnullByDefault
public class CrateBlockEntity
extends BaseContainerBlockEntity
implements WorldlyContainer {
    boolean needsUpdate = true;
    private int numPlayersUsing;
    private int[] visibleSlots = new int[0];
    public int displayTotal = 0;
    public int displaySlots = 0;
    private int cachedTotal = -1;
    private NonNullList<ItemStack> items = NonNullList.withSize((int)640, (Object)ItemStack.EMPTY);
    ContainerData crateData = new ContainerData(){

        public int get(int index) {
            return index == 0 ? CrateBlockEntity.this.displayTotal : CrateBlockEntity.this.displaySlots;
        }

        public void set(int index, int value) {
        }

        public int getCount() {
            return 2;
        }
    };

    public CrateBlockEntity(BlockPos pos, BlockState state) {
        super(CrateModule.blockEntityType, pos, state);
    }

    public void spillTheTea() {
        ArrayList<ItemStack> stacks = new ArrayList<ItemStack>((Collection<ItemStack>)this.items);
        SortingHandler.mergeStacks(stacks);
        for (ItemStack stack : stacks) {
            if (stack.isEmpty()) continue;
            Containers.dropItemStack((Level)this.level, (double)this.worldPosition.getX(), (double)this.worldPosition.getY(), (double)this.worldPosition.getZ(), (ItemStack)stack);
        }
    }

    public static void tick(Level level, BlockPos pos, BlockState state, CrateBlockEntity be) {
        be.tick();
    }

    public void tick() {
        this.recalculate();
    }

    protected void saveAdditional(CompoundTag tag, HolderLookup.Provider provider) {
        super.saveAdditional(tag, provider);
        tag.merge(ContainerHelper.saveAllItems((CompoundTag)tag, this.items, (HolderLookup.Provider)provider));
    }

    protected void loadAdditional(CompoundTag tag, HolderLookup.Provider provider) {
        super.loadAdditional(tag, provider);
        this.items = NonNullList.withSize((int)this.getContainerSize(), (Object)ItemStack.EMPTY);
        ContainerHelper.loadAllItems((CompoundTag)tag, this.items, (HolderLookup.Provider)provider);
    }

    public boolean canTakeItemThroughFace(int index, @NotNull ItemStack stack, @NotNull Direction dir) {
        return true;
    }

    public boolean canPlaceItemThroughFace(int index, @NotNull ItemStack stack, @Nullable Direction dir) {
        return this.getSlotLimit(index) > 0;
    }

    public boolean canPlaceItem(int slot, ItemStack stack) {
        return super.canPlaceItem(slot, stack);
    }

    public int[] getSlotsForFace(@NotNull Direction direction) {
        int slotCount = this.items.size();
        if (this.visibleSlots.length != slotCount) {
            this.visibleSlots = new int[slotCount];
            for (int i = 0; i < slotCount; ++i) {
                this.visibleSlots[i] = i;
            }
        }
        return this.visibleSlots;
    }

    public ItemStack getItem(int slot) {
        return (ItemStack)this.items.get(slot);
    }

    public void setItem(int slot, ItemStack stack) {
        ItemStack oldItem = this.getItem(slot);
        super.setItem(slot, stack);
        this.changeTotal(oldItem, stack);
    }

    @NotNull
    public ItemStack removeItem(int slot, int count) {
        ItemStack oldStack = ContainerHelper.removeItem(this.items, (int)slot, (int)count);
        ItemStack newStack = this.getItem(slot);
        this.changeTotal(oldStack, newStack);
        return oldStack;
    }

    public ItemStack removeItemNoUpdate(int slot) {
        ItemStack stack = super.removeItemNoUpdate(slot);
        this.changeTotal(stack, this.getItem(slot));
        return stack;
    }

    public ItemStack removeItem(int slot) {
        return this.removeItem(slot, 64);
    }

    public int getContainerSize() {
        return this.items.size();
    }

    private void changeTotal(ItemStack oldStack, ItemStack newStack) {
        int diff = newStack.getCount() - oldStack.getCount();
        if (diff != 0) {
            this.changeTotal(diff);
        }
    }

    private void changeTotal(int change) {
        this.cachedTotal = this.getTotal() + change;
        this.needsUpdate = true;
    }

    public int getTotal() {
        if (this.cachedTotal != -1) {
            return this.cachedTotal;
        }
        int count = 0;
        for (ItemStack stack : this.items) {
            count += stack.getCount();
        }
        this.cachedTotal = count;
        return count;
    }

    public void refreshCachedTotal() {
        this.cachedTotal = -1;
        this.getTotal();
    }

    public int getSlotLimit(int slot) {
        ItemStack stackInSlot = this.getItem(slot);
        int total = this.getTotal();
        return Mth.clamp((int)(stackInSlot.getCount() + CrateModule.maxItems - total), (int)0, (int)64);
    }

    protected Component getDefaultName() {
        return Component.translatable((String)CrateModule.crate.getDescriptionId());
    }

    protected NonNullList<ItemStack> getItems() {
        return this.items;
    }

    protected void setItems(@NotNull NonNullList<ItemStack> list) {
        this.items = list;
        this.cachedTotal = -1;
    }

    protected AbstractContainerMenu createMenu(int id, Inventory inv) {
        return new CrateMenu(id, inv, this, this.crateData);
    }

    public void recalculate() {
        this.needsUpdate = false;
        this.displayTotal = 0;
        this.displaySlots = 0;
        NonNullList newStacks = NonNullList.withSize((int)CrateModule.maxItems, (Object)ItemStack.EMPTY);
        int idx = 0;
        for (ItemStack stack : this.items) {
            if (stack.isEmpty()) continue;
            newStacks.set(idx, (Object)stack);
            this.displayTotal += stack.getCount();
            ++this.displaySlots;
            ++idx;
        }
        this.items = newStacks;
        this.cachedTotal = -1;
    }

    public void clearContent() {
        this.needsUpdate = false;
        this.items = NonNullList.withSize((int)CrateModule.maxItems, (Object)ItemStack.EMPTY);
        this.displayTotal = 0;
        this.displaySlots = 0;
    }

    public boolean stillValid(@NotNull Player player) {
        return Container.stillValidBlockEntity((BlockEntity)this, (Player)player);
    }

    public void startOpen(Player player) {
        if (!player.isSpectator()) {
            if (this.numPlayersUsing < 0) {
                this.numPlayersUsing = 0;
            }
            ++this.numPlayersUsing;
            BlockState blockstate = this.getBlockState();
            boolean isOpen = (Boolean)blockstate.getValue((Property)CrateBlock.PROPERTY_OPEN);
            if (!isOpen) {
                this.playSound(blockstate, SoundEvents.BARREL_OPEN);
                this.level.gameEvent((Entity)player, (Holder)GameEvent.CONTAINER_OPEN, this.worldPosition);
                this.setOpenProperty(blockstate, true);
            }
            this.scheduleTick();
        }
    }

    private void scheduleTick() {
        this.level.scheduleTick(this.getBlockPos(), this.getBlockState().getBlock(), 5);
    }

    public void crateTick() {
        int x = this.worldPosition.getX();
        int y = this.worldPosition.getY();
        int z = this.worldPosition.getZ();
        this.numPlayersUsing = CrateBlockEntity.calculatePlayersUsing(this.getLevel(), this, x, y, z);
        if (this.numPlayersUsing > 0) {
            this.scheduleTick();
        }
    }

    public static int calculatePlayersUsing(Level world, BaseContainerBlockEntity container, int x, int y, int z) {
        int playersUsing = 0;
        for (Player playerentity : world.getEntitiesOfClass(Player.class, new AABB((double)((float)x - 5.0f), (double)((float)y - 5.0f), (double)((float)z - 5.0f), (double)((float)(x + 1) + 5.0f), (double)((float)(y + 1) + 5.0f), (double)((float)(z + 1) + 5.0f)))) {
            CrateBlockEntity iinventory;
            if (!(playerentity.containerMenu instanceof CrateMenu) || (iinventory = ((CrateMenu)playerentity.containerMenu).crate) != container) continue;
            ++playersUsing;
        }
        return playersUsing;
    }

    public void stopOpen(Player player) {
        if (!player.isSpectator()) {
            --this.numPlayersUsing;
        }
        if (this.numPlayersUsing <= 0) {
            BlockState blockState = this.getBlockState();
            if (!blockState.is(CrateModule.crate)) {
                this.setRemoved();
                return;
            }
            boolean isOpen = (Boolean)blockState.getValue((Property)CrateBlock.PROPERTY_OPEN);
            if (isOpen) {
                this.playSound(blockState, SoundEvents.BARREL_CLOSE);
                this.level.gameEvent((Entity)player, (Holder)GameEvent.CONTAINER_OPEN, this.worldPosition);
                this.setOpenProperty(blockState, false);
            }
        }
    }

    private void setOpenProperty(BlockState state, boolean open) {
        BlockPos pos = this.getBlockPos();
        BlockState prev = this.level.getBlockState(pos);
        if (prev.is(state.getBlock())) {
            this.level.setBlock(pos, (BlockState)state.setValue((Property)CrateBlock.PROPERTY_OPEN, (Comparable)Boolean.valueOf(open)), 3);
        }
    }

    private void playSound(BlockState state, SoundEvent sound) {
        double x = (double)this.worldPosition.getX() + 0.5;
        double y = (double)this.worldPosition.getY() + 0.5;
        double z = (double)this.worldPosition.getZ() + 0.5;
        this.level.playSound(null, x, y, z, sound, SoundSource.BLOCKS, 0.5f, this.level.random.nextFloat() * 0.1f + 0.9f);
    }
}

