/*
 * Decompiled with CFR 0.152.
 */
package org.violetmoon.quark.content.tools.item;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.NotNull;
import org.violetmoon.quark.base.QuarkClient;
import org.violetmoon.quark.content.tools.module.AncientTomesModule;
import org.violetmoon.zeta.item.ZetaItem;
import org.violetmoon.zeta.module.ZetaModule;
import org.violetmoon.zeta.registry.CreativeTabManager;
import org.violetmoon.zeta.util.ZetaSide;

public class AncientTomeItem
extends ZetaItem
implements CreativeTabManager.AppendsUniquely {
    public AncientTomeItem(ZetaModule module) {
        super("ancient_tome", module, new Item.Properties().stacksTo(1).rarity(Rarity.UNCOMMON));
        CreativeTabManager.addToCreativeTab((ResourceKey)CreativeModeTabs.INGREDIENTS, (ItemLike)this);
    }

    public boolean isEnchantable(@NotNull ItemStack stack) {
        return false;
    }

    public boolean isFoil(@NotNull ItemStack stack) {
        return true;
    }

    public static ItemStack getEnchantedItemStack(Holder<Enchantment> ench) {
        ItemStack stack = new ItemStack((ItemLike)AncientTomesModule.ancient_tome);
        stack.enchant(ench, ((Enchantment)ench.value()).getMaxLevel());
        return stack;
    }

    public static Component getFullTooltipText(Holder<Enchantment> ench) {
        return Component.translatable((String)"quark.misc.ancient_tome_tooltip", (Object[])new Object[]{Component.translatable((String)((Enchantment)ench.value()).description().getString()), Component.translatable((String)("enchantment.level." + (((Enchantment)ench.value()).getMaxLevel() + 1)))}).withStyle(ChatFormatting.GRAY);
    }

    public void appendHoverText(@NotNull ItemStack stack, Item.TooltipContext tooltipContext, @NotNull List<Component> tooltip, @NotNull TooltipFlag flagIn) {
        super.appendHoverText(stack, tooltipContext, tooltip, flagIn);
        Holder<Enchantment> ench = AncientTomesModule.getTomeEnchantment(stack);
        if (ench != null) {
            tooltip.add(AncientTomeItem.getFullTooltipText(ench));
        } else {
            tooltip.add((Component)Component.translatable((String)"quark.misc.ancient_tome_tooltip_any").withStyle(ChatFormatting.GRAY));
        }
        if (AncientTomesModule.curseGear) {
            tooltip.add((Component)Component.translatable((String)"quark.misc.ancient_tome_tooltip_curse").withStyle(ChatFormatting.RED));
        }
    }

    public List<ItemStack> appendItemsToCreativeTab() {
        ArrayList<ItemStack> items = new ArrayList<ItemStack>();
        if (this.getModule().zeta().side == ZetaSide.CLIENT) {
            ((Registry)QuarkClient.ZETA_CLIENT.hackilyGetCurrentClientLevelRegistryAccess().registry(Registries.ENCHANTMENT).get()).asHolderIdMap().forEach(ench -> {
                if (!(AncientTomesModule.sanityCheck && ((Enchantment)ench.value()).getMaxLevel() == 1 || AncientTomesModule.isInitialized() && !AncientTomesModule.validEnchants.contains(ench))) {
                    items.add(AncientTomeItem.getEnchantedItemStack((Holder<Enchantment>)ench));
                }
            });
        }
        return items;
    }
}

