/*
 * Decompiled with CFR 0.152.
 */
package org.violetmoon.quark.content.client.module;

import java.util.UUID;
import java.util.function.BooleanSupplier;
import java.util.function.IntUnaryOperator;
import net.minecraft.client.color.item.ItemColor;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.item.ItemProperties;
import net.minecraft.client.renderer.item.ItemPropertyFunction;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.animal.TropicalFish;
import net.minecraft.world.entity.animal.axolotl.Axolotl;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.violetmoon.quark.base.Quark;
import org.violetmoon.quark.base.QuarkClient;
import org.violetmoon.quark.content.client.module.VariantAnimalTexturesModule;
import org.violetmoon.quark.content.mobs.module.CrabsModule;
import org.violetmoon.quark.content.tools.module.SlimeInABucketModule;
import org.violetmoon.zeta.client.event.load.ZAddItemColorHandlers;
import org.violetmoon.zeta.client.event.load.ZClientSetup;
import org.violetmoon.zeta.config.Config;
import org.violetmoon.zeta.event.bus.LoadEvent;
import org.violetmoon.zeta.module.ZetaLoadModule;
import org.violetmoon.zeta.module.ZetaModule;

@ZetaLoadModule(category="client")
public class BucketsShowInhabitantsModule
extends ZetaModule {
    @Config
    public boolean showAxolotls = true;
    @Config
    public boolean showCrabs = true;
    @Config
    public boolean showTropicalFish = true;
    @Config
    public boolean showShinySlime = true;

    @ZetaLoadModule(clientReplacement=true)
    public static class Client
    extends BucketsShowInhabitantsModule {
        @LoadEvent
        public void clientSetup(ZClientSetup e) {
            e.enqueueWork(() -> {
                ItemProperties.register((Item)Items.AXOLOTL_BUCKET, (ResourceLocation)Quark.asResource("variant"), (ItemPropertyFunction)new MobBucketVariantProperty(Axolotl.Variant.values().length, () -> this.showAxolotls));
                ItemProperties.register((Item)CrabsModule.crab_bucket, (ResourceLocation)Quark.asResource("variant"), (ItemPropertyFunction)new MobBucketVariantProperty(3, () -> this.showCrabs));
                ItemProperties.register((Item)SlimeInABucketModule.slime_in_a_bucket, (ResourceLocation)Quark.asResource("shiny"), (ItemPropertyFunction)new ShinyMobBucketProperty(() -> this.showShinySlime && VariantAnimalTexturesModule.staticEnabled && VariantAnimalTexturesModule.enableShinySlime));
                ItemProperties.register((Item)Items.TROPICAL_FISH_BUCKET, (ResourceLocation)Quark.asResource("base"), (ItemPropertyFunction)new TropicalFishBucketVariantProperty(b -> TropicalFish.getBaseColor((int)b).getId(), () -> this.showTropicalFish));
                ItemProperties.register((Item)Items.TROPICAL_FISH_BUCKET, (ResourceLocation)Quark.asResource("pattern"), (ItemPropertyFunction)new TropicalFishBucketVariantProperty(p -> TropicalFish.getPattern((int)p).getPackedId(), () -> this.showTropicalFish));
            });
        }

        @LoadEvent
        public void registerItemColors(ZAddItemColorHandlers evt) {
            ItemColor parent = QuarkClient.ZETA_CLIENT.getItemColor(evt.getItemColors(), (ItemLike)Items.TROPICAL_FISH_BUCKET);
            evt.register((ItemColor)new TropicalFishBucketColor(parent, () -> this.showTropicalFish), new ItemLike[]{Items.TROPICAL_FISH_BUCKET});
        }

        private class TropicalFishBucketColor
        implements ItemColor {
            @Nullable
            private final ItemColor parent;
            private final BooleanSupplier featureEnabled;

            public TropicalFishBucketColor(ItemColor parent, BooleanSupplier featureEnabled) {
                this.parent = parent;
                this.featureEnabled = featureEnabled;
            }

            public int getColor(@NotNull ItemStack stack, int layer) {
                CompoundTag tag;
                if (Client.this.isEnabled() && this.featureEnabled.getAsBoolean() && (layer == 1 || layer == 2) && stack.has(DataComponents.BUCKET_ENTITY_DATA) && (tag = ((CustomData)stack.get(DataComponents.BUCKET_ENTITY_DATA)).copyTag()) != null && tag.contains("BucketVariantTag", 3)) {
                    int variant = tag.getInt("BucketVariantTag");
                    DyeColor dyeColor = layer == 1 ? TropicalFish.getBaseColor((int)variant) : TropicalFish.getPatternColor((int)variant);
                    int colorComponents = dyeColor.getTextureDiffuseColor();
                    return colorComponents * 255 << 16 | colorComponents * 255 << 8 | colorComponents * 255;
                }
                return this.parent != null ? this.parent.getColor(stack, layer) : -1;
            }
        }

        private class MobBucketVariantProperty
        implements ItemPropertyFunction {
            private final int maxVariants;
            private final BooleanSupplier featureEnabled;

            public MobBucketVariantProperty(int maxVariants, BooleanSupplier featureEnabled) {
                this.maxVariants = maxVariants;
                this.featureEnabled = featureEnabled;
            }

            public float call(@NotNull ItemStack stack, @Nullable ClientLevel level, @Nullable LivingEntity entity, int id) {
                if (!(Client.this.isEnabled() && this.featureEnabled.getAsBoolean() && stack.has(DataComponents.BUCKET_ENTITY_DATA))) {
                    return 0.0f;
                }
                return ((CustomData)stack.get(DataComponents.BUCKET_ENTITY_DATA)).copyTag().getInt("Variant") % this.maxVariants;
            }
        }

        private class ShinyMobBucketProperty
        implements ItemPropertyFunction {
            private final BooleanSupplier featureEnabled;

            public ShinyMobBucketProperty(BooleanSupplier featureEnabled) {
                this.featureEnabled = featureEnabled;
            }

            public float call(@NotNull ItemStack stack, @Nullable ClientLevel level, @Nullable LivingEntity entity, int id) {
                UUID uuid;
                if (!(Client.this.isEnabled() && this.featureEnabled.getAsBoolean() && stack.has(DataComponents.BUCKET_ENTITY_DATA))) {
                    return 0.0f;
                }
                CompoundTag data = ((CustomData)stack.get(DataComponents.BUCKET_ENTITY_DATA)).copyTag();
                if (data != null && data.hasUUID("UUID") && VariantAnimalTexturesModule.Client.isShiny(uuid = data.getUUID("UUID"))) {
                    return 1.0f;
                }
                return 0.0f;
            }
        }

        private class TropicalFishBucketVariantProperty
        implements ItemPropertyFunction {
            private final IntUnaryOperator extractor;
            private final BooleanSupplier featureEnabled;

            public TropicalFishBucketVariantProperty(IntUnaryOperator extractor, BooleanSupplier featureEnabled) {
                this.extractor = extractor;
                this.featureEnabled = featureEnabled;
            }

            public float call(@NotNull ItemStack stack, @Nullable ClientLevel level, @Nullable LivingEntity entity, int id) {
                if (!Client.this.isEnabled() || !this.featureEnabled.getAsBoolean()) {
                    return 0.0f;
                }
                CompoundTag tag = ((CustomData)stack.get(DataComponents.BUCKET_ENTITY_DATA)).copyTag();
                if (tag != null && tag.contains("BucketVariantTag", 3)) {
                    int variant = tag.getInt("BucketVariantTag");
                    return this.extractor.applyAsInt(variant) + 1;
                }
                return 0.0f;
            }
        }
    }
}

