/*
 * Decompiled with CFR 0.152.
 */
package org.violetmoon.quark.addons.oddities.inventory;

import java.awt.Color;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.stream.Collectors;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.EnchantmentTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.util.random.Weight;
import net.minecraft.util.random.WeightedRandom;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentInstance;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import org.violetmoon.quark.addons.oddities.module.MatrixEnchantingModule;

public class EnchantmentMatrix {
    public static final int MATRIX_WIDTH = 5;
    public static final int MATRIX_HEIGHT = 5;
    private static final int PIECE_VARIANTS = 8;
    private static final String TAG_PIECES = "pieces";
    private static final String TAG_PIECE_ID = "id";
    private static final String TAG_BENCHED_PIECES = "benchedPieces";
    private static final String TAG_PLACED_PIECES = "placedPieces";
    private static final String TAG_COUNT = "count";
    private static final String TAG_TYPE_COUNT = "typeCount";
    private static final String TAG_INFLUENCED = "influenced";
    public final Map<Holder<Enchantment>, Integer> totalValue = new HashMap<Holder<Enchantment>, Integer>();
    public final Map<Integer, Piece> pieces = new HashMap<Integer, Piece>();
    public List<Integer> benchedPieces = new ArrayList<Integer>();
    public List<Integer> placedPieces = new ArrayList<Integer>();
    public int[][] matrix;
    public int count;
    public int typeCount;
    private boolean influenced;
    public final boolean book;
    public final ItemStack target;
    public final RandomSource rng;
    public final Level levelAsInWorld;

    public EnchantmentMatrix(ItemStack target, Level level) {
        this.target = target;
        this.levelAsInWorld = level;
        this.rng = level.random;
        this.book = target.getItem() == Items.BOOK;
        this.computeMatrix();
    }

    public boolean isInfluenced() {
        return this.influenced;
    }

    public boolean canGeneratePiece(Map<Enchantment, Integer> influences, int bookshelfPower, int enchantability) {
        int enchantabilityCount;
        if (enchantability == 0) {
            return false;
        }
        if (!this.generatePiece(influences, bookshelfPower, this.book, true)) {
            return false;
        }
        if (this.book) {
            if (!MatrixEnchantingModule.allowBooks) {
                return false;
            }
            int bookshelfCount = Math.max(0, Math.min(bookshelfPower - 1, MatrixEnchantingModule.maxBookshelves)) / 7;
            int maxCount = MatrixEnchantingModule.baseMaxPieceCountBook + bookshelfCount;
            return this.count < maxCount;
        }
        int bookshelfCount = Math.min(bookshelfPower, MatrixEnchantingModule.maxBookshelves);
        int maxCount = MatrixEnchantingModule.baseMaxPieceCount + (bookshelfCount + 1) / 2 + (enchantabilityCount = Math.round((float)enchantability * ((float)bookshelfCount / (float)MatrixEnchantingModule.maxBookshelves))) / 2;
        return this.count < maxCount;
    }

    public boolean validateXp(Player player, int bookshelfPower) {
        return player.getAbilities().instabuild || player.experienceLevel >= this.getMinXpLevel(bookshelfPower) && player.experienceLevel >= this.getNewPiecePrice();
    }

    public int getMinXpLevel(int bookshelfPower) {
        float scale = (float)MatrixEnchantingModule.minLevelScaleFactor;
        int cutoff = MatrixEnchantingModule.minLevelCutoff;
        if (this.book) {
            return (int)((double)Math.min(bookshelfPower, MatrixEnchantingModule.maxBookshelves) * MatrixEnchantingModule.minLevelScaleFactorBook);
        }
        return this.count > cutoff ? (int)((float)cutoff * scale) - cutoff + this.count : (int)((float)this.count * scale);
    }

    public int getNewPiecePrice() {
        return 1 + (MatrixEnchantingModule.piecePriceScale == 0 ? 0 : this.count / MatrixEnchantingModule.piecePriceScale);
    }

    public boolean generatePiece(Map<Enchantment, Integer> influences, int bookshelfPower, boolean isBook, boolean simulate) {
        EnchantmentDataWrapper data = this.generateRandomEnchantment(influences, bookshelfPower, isBook, simulate);
        if (data == null) {
            return false;
        }
        int type = -1;
        for (Piece p : this.pieces.values()) {
            if (p.enchant != data.enchantment) continue;
            type = p.type;
        }
        if (type == -1) {
            type = this.typeCount % 8;
            if (!simulate) {
                ++this.typeCount;
            }
        }
        Piece piece = new Piece(data, type);
        piece.generateBlocks();
        if (!simulate) {
            this.pieces.put(this.count, piece);
            this.totalValue.put(piece.enchant, this.totalValue.getOrDefault(piece.enchant, 0) + piece.getValue());
            this.benchedPieces.add(0, this.count);
            ++this.count;
            if (this.book && this.count == 1) {
                for (int i = 0; i < 2; ++i) {
                    if (!this.rng.nextBoolean()) continue;
                    ++this.count;
                }
            }
        }
        return true;
    }

    private EnchantmentDataWrapper generateRandomEnchantment(Map<Enchantment, Integer> influences, int bookshelfPower, boolean isBook, boolean simulate) {
        int level = this.book ? MatrixEnchantingModule.bookEnchantability + this.rng.nextInt(Math.max(1, bookshelfPower) * 2) : 0;
        List marked = this.pieces.values().stream().filter(p -> p.marked).collect(Collectors.toList());
        ArrayList validEnchants = new ArrayList();
        HolderLookup.RegistryLookup enchantmentRegistryLookup = this.levelAsInWorld.registryAccess().lookupOrThrow(Registries.ENCHANTMENT);
        enchantmentRegistryLookup.listElements().forEach(enchantment -> {
            String id = enchantment.getKey().location().toString();
            boolean isValid = true;
            if (!enchantment.is(EnchantmentTags.IN_ENCHANTING_TABLE)) {
                boolean bl = isValid = MatrixEnchantingModule.allowUndiscoverableEnchantments || MatrixEnchantingModule.undiscoverableWhitelist.contains(id);
            }
            if (isValid && enchantment.is(EnchantmentTags.TREASURE)) {
                boolean bl = isValid = MatrixEnchantingModule.allowTreasures || isBook && MatrixEnchantingModule.treasureWhitelist.contains(id);
            }
            if (isValid && !MatrixEnchantingModule.disallowedEnchantments.contains(id) && ((Enchantment)enchantment.value()).canEnchant(this.target) && ((Enchantment)enchantment.value()).isPrimaryItem(this.target)) {
                int currentValue;
                int valueAdded;
                int enchantLevel = 1;
                if (this.book) {
                    for (int i = ((Enchantment)enchantment.value()).getMaxLevel(); i > ((Enchantment)enchantment.value()).getMinLevel() - 1; --i) {
                        if (level < ((Enchantment)enchantment.value()).getMinCost(i) || level > ((Enchantment)enchantment.value()).getMaxCost(i)) continue;
                        enchantLevel = i;
                        break;
                    }
                }
                if ((valueAdded = EnchantmentMatrix.getValue((Enchantment)enchantment.value(), enchantLevel)) + (currentValue = this.totalValue.getOrDefault(enchantment, 0).intValue()) > EnchantmentMatrix.getValue((Enchantment)enchantment.value(), ((Enchantment)enchantment.value()).getMaxLevel()) + EnchantmentMatrix.getMaxXP((Enchantment)enchantment.value(), ((Enchantment)enchantment.value()).getMaxLevel())) {
                    return;
                }
                EnchantmentDataWrapper wrapper = new EnchantmentDataWrapper((Holder<Enchantment>)enchantment, enchantLevel);
                wrapper.normalizeRarity(influences, marked);
                validEnchants.add(wrapper);
            }
        });
        if (validEnchants.isEmpty()) {
            return null;
        }
        int total = 0;
        for (EnchantmentDataWrapper wrapper : validEnchants) {
            total = (int)((double)total + wrapper.mutableWeight.val);
        }
        if (total == 0) {
            for (EnchantmentDataWrapper wrapper : validEnchants) {
                wrapper.mutableWeight.val += 1.0;
            }
        }
        EnchantmentDataWrapper ret = WeightedRandom.getRandomItem((RandomSource)this.rng, validEnchants).orElse(null);
        if (!simulate && ret != null && influences.containsKey(ret.enchantment.value()) && influences.get(ret.enchantment.value()) > 0) {
            this.influenced = true;
        }
        return ret;
    }

    public boolean place(int id, int x, int y) {
        Piece p = this.pieces.get(id);
        if (p != null && this.benchedPieces.contains(id) && this.canPlace(p, x, y)) {
            p.x = x;
            p.y = y;
            this.benchedPieces.remove((Object)id);
            this.placedPieces.add(id);
            this.computeMatrix();
            return true;
        }
        return false;
    }

    public boolean remove(int id) {
        Piece p = this.pieces.get(id);
        if (p != null && this.placedPieces.contains(id)) {
            this.placedPieces.remove((Object)id);
            this.benchedPieces.add(id);
            this.computeMatrix();
            return true;
        }
        return false;
    }

    public boolean rotate(int id) {
        Piece p = this.pieces.get(id);
        if (p != null && this.benchedPieces.contains(id)) {
            p.rotate();
            return true;
        }
        return false;
    }

    public boolean merge(int placed, int hover) {
        Holder<Enchantment> enchant;
        Piece placedPiece = this.pieces.get(placed);
        Piece hoveredPiece = this.pieces.get(hover);
        if (placedPiece != null && hoveredPiece != null && this.placedPieces.contains(placed) && this.benchedPieces.contains(hover) && hoveredPiece.enchant == (enchant = placedPiece.enchant) && placedPiece.level < ((Enchantment)enchant.value()).getMaxLevel()) {
            placedPiece.xp += hoveredPiece.getValue();
            int max = placedPiece.getMaxXP();
            while (placedPiece.xp >= max && placedPiece.level < ((Enchantment)enchant.value()).getMaxLevel()) {
                ++placedPiece.level;
                placedPiece.xp -= max;
                max = placedPiece.getMaxXP();
            }
            if (hoveredPiece.marked) {
                placedPiece.marked = true;
            }
            this.benchedPieces.remove((Object)hover);
            this.pieces.remove(hover);
            return true;
        }
        return false;
    }

    public void writeToNBT(CompoundTag cmp) {
        ListTag list = new ListTag();
        for (Integer i : this.pieces.keySet()) {
            CompoundTag pieceTag = new CompoundTag();
            pieceTag.putInt(TAG_PIECE_ID, i.intValue());
            if (this.pieces.get((Object)i).enchant == null) continue;
            this.pieces.get(i).writeToNBT(pieceTag);
            list.add((Object)pieceTag);
        }
        cmp.put(TAG_PIECES, (Tag)list);
        cmp.putIntArray(TAG_BENCHED_PIECES, this.packList(this.benchedPieces));
        cmp.putIntArray(TAG_PLACED_PIECES, this.packList(this.placedPieces));
        cmp.putInt(TAG_COUNT, this.count);
        cmp.putInt(TAG_TYPE_COUNT, this.typeCount);
        cmp.putBoolean(TAG_INFLUENCED, this.influenced);
    }

    public void readFromNBT(CompoundTag cmp) {
        this.pieces.clear();
        this.totalValue.clear();
        ListTag plist = cmp.getList(TAG_PIECES, (int)cmp.getId());
        for (int i = 0; i < plist.size(); ++i) {
            CompoundTag pieceTag = plist.getCompound(i);
            int id = pieceTag.getInt(TAG_PIECE_ID);
            Piece piece = new Piece();
            piece.readFromNBT(pieceTag, this.levelAsInWorld);
            this.pieces.put(id, piece);
            this.totalValue.put(piece.enchant, this.totalValue.getOrDefault(piece.enchant, 0) + piece.getValue());
        }
        this.benchedPieces = this.unpackList(cmp.getIntArray(TAG_BENCHED_PIECES));
        this.placedPieces = this.unpackList(cmp.getIntArray(TAG_PLACED_PIECES));
        this.count = cmp.getInt(TAG_COUNT);
        this.typeCount = cmp.getInt(TAG_TYPE_COUNT);
        this.influenced = cmp.getBoolean(TAG_INFLUENCED);
        this.computeMatrix();
    }

    private void computeMatrix() {
        this.matrix = new int[5][5];
        for (int i = 0; i < 5; ++i) {
            for (int j = 0; j < 5; ++j) {
                this.matrix[i][j] = -1;
            }
        }
        for (Integer i : this.placedPieces) {
            Piece p = this.pieces.get(i);
            for (int[] b : p.blocks) {
                this.matrix[p.x + b[0]][p.y + b[1]] = i;
            }
        }
    }

    public boolean canPlace(Piece p, int x, int y) {
        for (int[] b : p.blocks) {
            int bx = b[0] + x;
            int by = b[1] + y;
            if (bx < 0 || by < 0 || bx >= 5 || by >= 5) {
                return false;
            }
            if (this.matrix[bx][by] == -1) continue;
            return false;
        }
        return true;
    }

    private int[] packList(List<Integer> list) {
        int[] arr = new int[list.size()];
        for (int i = 0; i < arr.length; ++i) {
            arr[i] = list.get(i);
        }
        return arr;
    }

    private List<Integer> unpackList(int[] arr) {
        ArrayList<Integer> list = new ArrayList<Integer>(arr.length);
        for (int anArr : arr) {
            list.add(anArr);
        }
        return list;
    }

    public static int getMaxXP(Enchantment enchantment, int level) {
        if (level >= enchantment.getMaxLevel()) {
            return 0;
        }
        return level;
    }

    public static int getValue(Enchantment enchantment, int level) {
        int total = 1;
        for (int i = 1; i < level; ++i) {
            total += EnchantmentMatrix.getMaxXP(enchantment, i);
        }
        return total;
    }

    private static class EnchantmentDataWrapper
    extends EnchantmentInstance {
        private boolean marked;
        private int influence;
        private final MutableWeight mutableWeight;

        public EnchantmentDataWrapper(Holder<Enchantment> enchantmentObj, int enchLevel) {
            super(enchantmentObj, enchLevel);
            this.mutableWeight = new MutableWeight(((Enchantment)this.enchantment.value()).getWeight());
        }

        public void normalizeRarity(Map<Enchantment, Integer> influences, List<Piece> markedEnchants) {
            if (MatrixEnchantingModule.normalizeRarity) {
                this.mutableWeight.val = ((Enchantment)this.enchantment.value()).getWeight() * 8;
                if (this.mutableWeight.val == 8.0) {
                    this.mutableWeight.val = 5.0;
                } else if (this.mutableWeight.val == 16.0) {
                    this.mutableWeight.val = 25.0;
                }
                this.influence = Mth.clamp((int)influences.getOrDefault(this.enchantment.value(), 0), (int)(-MatrixEnchantingModule.influenceMax), (int)MatrixEnchantingModule.influenceMax);
                float multiplier = 1.0f + (float)this.influence * (float)MatrixEnchantingModule.influencePower;
                this.mutableWeight.val *= (double)multiplier;
                boolean mark = true;
                for (Piece other : markedEnchants) {
                    if (other.enchant == null) continue;
                    if (other.enchant == this.enchantment) {
                        this.mutableWeight.val *= MatrixEnchantingModule.dupeMultiplier;
                        mark = false;
                        break;
                    }
                    if (!((Enchantment)other.enchant.value()).exclusiveSet().contains(this.enchantment) && !((Enchantment)this.enchantment.value()).exclusiveSet().contains(other.enchant)) continue;
                    this.mutableWeight.val *= MatrixEnchantingModule.incompatibleMultiplier;
                    mark = false;
                    break;
                }
                if (mark) {
                    this.marked = true;
                }
            }
        }

        @NotNull
        public Weight getWeight() {
            return this.mutableWeight;
        }
    }

    public static class Piece {
        private static final int[][][] PIECE_TYPES = new int[][][]{new int[][]{{0, 0}, {-1, 0}, {1, 0}, {0, -1}, {0, 1}}, new int[][]{{0, 0}, {-1, 0}, {1, 0}, {-1, -1}, {0, -1}}, new int[][]{{0, 0}, {-1, 0}, {1, 0}, {-1, 1}, {1, 1}}, new int[][]{{0, 0}, {-1, 0}, {1, 0}, {-1, -1}, {1, 1}}, new int[][]{{0, 0}, {-1, 0}, {1, 0}, {1, -1}, {1, 1}}, new int[][]{{0, 0}, {-1, 0}, {1, 0}, {0, -1}, {1, 1}}, new int[][]{{0, 0}, {-1, 0}, {0, -1}, {-1, -1}, {1, 1}}, new int[][]{{0, 0}, {-1, 0}, {1, 0}, {0, -1}, {0, 1}, {1, 1}}, new int[][]{{0, 0}, {-1, 0}, {0, -1}, {-1, -1}, {-1, 1}, {1, -1}}, new int[][]{{0, 0}, {-1, 0}, {0, -1}, {-1, -1}, {-1, 1}, {1, 1}}, new int[][]{{0, 0}, {-1, 0}, {1, 0}, {-1, -1}, {1, -1}, {1, 1}}, new int[][]{{0, 0}, {-1, 0}, {1, 0}, {0, -1}, {-1, -1}, {1, 1}}};
        private static final String TAG_COLOR = "color";
        private static final String TAG_TYPE = "type";
        private static final String TAG_ENCHANTMENT = "enchant";
        private static final String TAG_LEVEL = "level";
        private static final String TAG_BLOCK_COUNT = "blockCount";
        private static final String TAG_BLOCK = "block";
        private static final String TAG_X = "x";
        private static final String TAG_Y = "y";
        private static final String TAG_XP = "xp";
        private static final String TAG_MARKED = "marked";
        private static final String TAG_INFLUENCE = "influence";
        public Holder<Enchantment> enchant;
        public int level;
        public int color;
        public int type;
        public int x;
        public int y;
        public int xp;
        public int[][] blocks;
        public boolean marked;
        public int influence;

        public Piece() {
        }

        public Piece(EnchantmentDataWrapper wrapper, int type) {
            this.enchant = wrapper.enchantment;
            this.level = wrapper.level;
            this.marked = wrapper.marked;
            this.influence = wrapper.influence;
            this.type = type;
            Random rng = new Random(this.enchant.hashCode());
            float h = rng.nextFloat();
            float s = rng.nextFloat() * 0.2f + 0.8f;
            float b = rng.nextFloat() * 0.25f + 0.75f;
            this.color = Color.HSBtoRGB(h, s, b);
        }

        public void generateBlocks() {
            int type = (int)(Math.random() * (double)PIECE_TYPES.length);
            int[][] copyPieces = PIECE_TYPES[type];
            this.blocks = new int[copyPieces.length][2];
            for (int i = 0; i < this.blocks.length; ++i) {
                this.blocks[i][0] = copyPieces[i][0];
                this.blocks[i][1] = copyPieces[i][1];
            }
            int rotations = (int)(Math.random() * 4.0);
            for (int i = 0; i < rotations; ++i) {
                this.rotate();
            }
        }

        public void rotate() {
            for (int[] b : this.blocks) {
                int y;
                int x = b[0];
                b[0] = y = b[1];
                b[1] = -x;
            }
        }

        public int getMaxXP() {
            return EnchantmentMatrix.getMaxXP((Enchantment)this.enchant.value(), this.level);
        }

        public int getValue() {
            return EnchantmentMatrix.getValue((Enchantment)this.enchant.value(), this.level) + this.xp;
        }

        public void writeToNBT(CompoundTag cmp) {
            cmp.putInt(TAG_COLOR, this.color);
            cmp.putInt(TAG_TYPE, this.type);
            if (this.enchant != null) {
                cmp.putString(TAG_ENCHANTMENT, this.enchant.getRegisteredName());
            }
            cmp.putInt(TAG_LEVEL, this.level);
            cmp.putInt(TAG_X, this.x);
            cmp.putInt(TAG_Y, this.y);
            cmp.putInt(TAG_XP, this.xp);
            cmp.putBoolean(TAG_MARKED, this.marked);
            cmp.putInt(TAG_INFLUENCE, this.influence);
            cmp.putInt(TAG_BLOCK_COUNT, this.blocks.length);
            for (int i = 0; i < this.blocks.length; ++i) {
                cmp.putIntArray(TAG_BLOCK + i, this.blocks[i]);
            }
        }

        public void readFromNBT(CompoundTag cmp, Level levelAsInWorld) {
            this.color = cmp.getInt(TAG_COLOR);
            this.type = cmp.getInt(TAG_TYPE);
            this.enchant = (Holder)levelAsInWorld.registryAccess().lookupOrThrow(Registries.ENCHANTMENT).get(ResourceKey.create((ResourceKey)Registries.ENCHANTMENT, (ResourceLocation)ResourceLocation.parse((String)cmp.getString(TAG_ENCHANTMENT)))).get();
            this.level = cmp.getInt(TAG_LEVEL);
            this.x = cmp.getInt(TAG_X);
            this.y = cmp.getInt(TAG_Y);
            this.xp = cmp.getInt(TAG_XP);
            this.marked = cmp.getBoolean(TAG_MARKED);
            this.influence = cmp.getInt(TAG_INFLUENCE);
            this.blocks = new int[cmp.getInt(TAG_BLOCK_COUNT)][2];
            for (int i = 0; i < this.blocks.length; ++i) {
                this.blocks[i] = cmp.getIntArray(TAG_BLOCK + i);
            }
        }
    }

    private static class MutableWeight
    extends Weight {
        protected double val;

        public MutableWeight(int val) {
            super(val);
        }

        public int asInt() {
            return (int)this.val;
        }
    }
}

