/*
 * Decompiled with CFR 0.152.
 */
package org.violetmoon.quark.content.client.tooltip;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.datafixers.util.Either;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.MapItem;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.saveddata.maps.MapId;
import net.minecraft.world.level.saveddata.maps.MapItemSavedData;
import org.jetbrains.annotations.NotNull;
import org.violetmoon.quark.content.client.module.ImprovedTooltipsModule;
import org.violetmoon.zeta.client.event.play.ZGatherTooltipComponents;

public class MapTooltips {
    private static final ResourceLocation RES_MAP_BACKGROUND = ResourceLocation.withDefaultNamespace((String)"textures/map/map_background.png");

    public static void makeTooltip(ZGatherTooltipComponents event) {
        ItemStack stack = event.getItemStack();
        if (!stack.isEmpty() && stack.getItem() instanceof MapItem) {
            List tooltip = event.getTooltipElements();
            if (!ImprovedTooltipsModule.mapRequireShift || Screen.hasShiftDown()) {
                tooltip.add(1, Either.right((Object)new MapComponent(stack)));
            } else if (ImprovedTooltipsModule.mapRequireShift && !Screen.hasShiftDown()) {
                tooltip.add(1, Either.left((Object)Component.translatable((String)"quark.misc.map_shift")));
            }
        }
    }

    public record MapComponent(ItemStack stack) implements ClientTooltipComponent,
    TooltipComponent
    {
        public void renderImage(@NotNull Font font, int tooltipX, int tooltipY, @NotNull GuiGraphics guiGraphics) {
            Minecraft mc = Minecraft.getInstance();
            PoseStack pose = guiGraphics.pose();
            MapItemSavedData mapdata = MapItem.getSavedData((ItemStack)this.stack, (Level)mc.level);
            MapId mapID = (MapId)this.stack.get(DataComponents.MAP_ID);
            if (mapdata == null) {
                return;
            }
            RenderSystem.setShader(GameRenderer::getPositionTexShader);
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            int pad = 7;
            int size = 135 + pad;
            float scale = 0.5f;
            pose.pushPose();
            pose.translate((float)(tooltipX + 3), (float)(tooltipY + 3), 500.0f);
            pose.scale(scale, scale, 1.0f);
            RenderSystem.enableBlend();
            guiGraphics.blit(RES_MAP_BACKGROUND, -pad, -pad, 0.0f, 0.0f, size, size, size, size);
            pose.translate(0.0f, 0.0f, 1.0f);
            mc.gameRenderer.getMapRenderer().render(pose, (MultiBufferSource)guiGraphics.bufferSource(), mapID, mapdata, true, 240);
        }

        public int getHeight() {
            Minecraft mc = Minecraft.getInstance();
            MapItemSavedData mapdata = MapItem.getSavedData((ItemStack)this.stack, (Level)mc.level);
            return mapdata != null ? 75 : 0;
        }

        public int getWidth(@NotNull Font font) {
            return 72;
        }
    }
}

