/*
 * Decompiled with CFR 0.152.
 */
package org.violetmoon.quark.addons.oddities.client.screen;

import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractSelectionList;
import net.minecraft.client.gui.components.ObjectSelectionList;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;
import org.violetmoon.quark.addons.oddities.client.screen.MatrixEnchantingScreen;
import org.violetmoon.quark.addons.oddities.inventory.EnchantmentMatrix;

public class MatrixEnchantingPieceList
extends ObjectSelectionList<PieceEntry> {
    private final MatrixEnchantingScreen parent;
    private final int listWidth;

    public MatrixEnchantingPieceList(MatrixEnchantingScreen parent, int listWidth, int listHeight, int top, int bottom, int entryHeight) {
        super(parent.getMinecraft(), listWidth, listHeight, top, entryHeight);
        this.listWidth = listWidth;
        this.parent = parent;
    }

    protected int getScrollbarPosition() {
        return this.getX() + this.listWidth - 5;
    }

    public int getRowWidth() {
        return this.listWidth;
    }

    public void refresh() {
        this.clearEntries();
        if (this.parent.listPieces != null) {
            for (int i : this.parent.listPieces) {
                EnchantmentMatrix.Piece piece = this.parent.getPiece(i);
                if (piece == null) continue;
                this.addEntry((AbstractSelectionList.Entry)new PieceEntry(piece, i));
            }
        }
    }

    public void renderWidget(@NotNull GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        int scrollbarStartX = this.getScrollbarPosition();
        int scrollbarEndX = scrollbarStartX + 6;
        guiGraphics.fill(this.getX(), this.getY(), this.getX() + this.getWidth() + 1, this.getY() + this.getHeight(), -13948117);
        Window main = this.parent.getMinecraft().getWindow();
        int res = (int)main.getGuiScale();
        RenderSystem.enableScissor((int)(this.getX() * res), (int)((main.getGuiScaledHeight() - this.getBottom()) * res), (int)(this.getWidth() * res), (int)(this.getHeight() * res));
        this.setScrollAmount(Math.min(this.getScrollAmount(), (double)this.getMaxScroll()));
        this.renderListItems(guiGraphics, mouseX, mouseY, partialTicks);
        RenderSystem.disableScissor();
        this.renderScroll(guiGraphics, scrollbarStartX, scrollbarEndX);
    }

    protected int getMaxScroll2() {
        return Math.max(0, this.getMaxPosition() - (this.getHeight() - this.getY() - 4));
    }

    private void renderScroll(GuiGraphics guiGraphics, int scrollbarStartX, int scrollbarEndX) {
        int maxScrollHeight = this.getMaxScroll();
        if (maxScrollHeight > 0) {
            int diff = this.getY() - this.getHeight();
            int scrollbarSize = this.getHeight() * this.getHeight() / this.getMaxPosition();
            scrollbarSize = Math.clamp((long)scrollbarSize, 0, this.getHeight());
            int scrollbarYPos = (int)((double)(this.getY() + scrollbarSize) + (double)(this.getHeight() - scrollbarSize) * (this.getScrollAmount() / (double)this.getMaxScroll()));
            guiGraphics.drawString(this.parent.getMinecraft().font, "getY: " + this.getY(), 4, 4, 0xFFFFFF);
            guiGraphics.drawString(this.parent.getMinecraft().font, "getHeight: " + this.getHeight(), 4, 16, 0xFFFFFF);
            guiGraphics.drawString(this.parent.getMinecraft().font, "maxScrollHeight: " + maxScrollHeight, 4, 28, 0xFFFFFF);
            guiGraphics.drawString(this.parent.getMinecraft().font, "scrollbarStartX: " + scrollbarStartX, 4, 40, 0xFFFFFF);
            guiGraphics.drawString(this.parent.getMinecraft().font, "scrollbarEndX: " + scrollbarEndX, 4, 52, 0xFFFFFF);
            guiGraphics.drawString(this.parent.getMinecraft().font, "scrollbarSize: " + scrollbarSize, 4, 64, 0xFFFFFF);
            guiGraphics.drawString(this.parent.getMinecraft().font, "scrollbarYPos: " + scrollbarYPos, 4, 76, 0xFFFFFF);
            guiGraphics.drawString(this.parent.getMinecraft().font, "maxPos: " + this.getMaxPosition(), 4, 88, 0xFFFFFF);
            guiGraphics.drawString(this.parent.getMinecraft().font, "scrollAmount: " + this.getScrollAmount(), 4, 100, 0xFFFFFF);
            guiGraphics.fill(scrollbarStartX, this.getY() + this.getHeight(), scrollbarEndX, this.getY(), -16777216);
            guiGraphics.fill(scrollbarStartX, scrollbarYPos - scrollbarSize, scrollbarEndX, scrollbarYPos, -8289919);
            guiGraphics.fill(scrollbarStartX, scrollbarYPos - scrollbarSize, scrollbarEndX - 1, scrollbarYPos, -4144960);
        }
    }

    protected class PieceEntry
    extends ObjectSelectionList.Entry<PieceEntry> {
        private final EnchantmentMatrix.Piece piece;
        private final int index;

        PieceEntry(EnchantmentMatrix.Piece piece, int index) {
            this.piece = piece;
            this.index = index;
        }

        public void render(@NotNull GuiGraphics guiGraphics, int entryIdx, int top, int left, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean hover, float partialTicks) {
            PoseStack stack = guiGraphics.pose();
            if (mouseX > left && mouseY > top && mouseX <= left + entryWidth && mouseY <= top + entryHeight) {
                MatrixEnchantingPieceList.this.parent.hoveredPiece = this.piece;
            }
            RenderSystem.setShader(GameRenderer::getPositionTexShader);
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            RenderSystem.setShaderTexture((int)0, (ResourceLocation)MatrixEnchantingScreen.BACKGROUND);
            stack.pushPose();
            stack.translate((float)left + (float)(MatrixEnchantingPieceList.this.listWidth - 7) / 2.0f, (float)top + (float)entryHeight / 2.0f, 0.0f);
            stack.scale(0.5f, 0.5f, 0.5f);
            stack.translate(-8.0f, -8.0f, 0.0f);
            MatrixEnchantingPieceList.this.parent.renderPiece(guiGraphics, this.piece, 1.0f);
            stack.popPose();
        }

        public boolean mouseClicked(double x, double y, int button) {
            MatrixEnchantingPieceList.this.parent.selectedPiece = this.index;
            MatrixEnchantingPieceList.this.setSelected((AbstractSelectionList.Entry)this);
            return false;
        }

        @NotNull
        public Component getNarration() {
            return Component.literal((String)"");
        }
    }
}

