/*
 * Decompiled with CFR 0.152.
 */
package org.violetmoon.quark.addons.oddities.block.be;

import com.google.common.collect.Lists;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.EnchantedBookItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.EnchantmentInstance;
import net.minecraft.world.item.enchantment.ItemEnchantments;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CandleBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.violetmoon.quark.addons.oddities.block.be.AbstractEnchantingTableBlockEntity;
import org.violetmoon.quark.addons.oddities.inventory.EnchantmentMatrix;
import org.violetmoon.quark.addons.oddities.inventory.MatrixEnchantingMenu;
import org.violetmoon.quark.addons.oddities.module.MatrixEnchantingModule;
import org.violetmoon.quark.addons.oddities.util.InfluenceLocations;
import org.violetmoon.quark.api.IEnchantmentInfluencer;
import org.violetmoon.quark.base.Quark;
import org.violetmoon.quark.base.components.QuarkDataComponents;

public class MatrixEnchantingTableBlockEntity
extends AbstractEnchantingTableBlockEntity
implements MenuProvider {
    public static final List<Block> CANDLES = Lists.newArrayList((Object[])new Block[]{Blocks.WHITE_CANDLE, Blocks.ORANGE_CANDLE, Blocks.MAGENTA_CANDLE, Blocks.LIGHT_BLUE_CANDLE, Blocks.YELLOW_CANDLE, Blocks.LIME_CANDLE, Blocks.PINK_CANDLE, Blocks.GRAY_CANDLE, Blocks.LIGHT_GRAY_CANDLE, Blocks.CYAN_CANDLE, Blocks.PURPLE_CANDLE, Blocks.BLUE_CANDLE, Blocks.BROWN_CANDLE, Blocks.GREEN_CANDLE, Blocks.RED_CANDLE, Blocks.BLACK_CANDLE});
    public static final int OPER_ADD = 0;
    public static final int OPER_PLACE = 1;
    public static final int OPER_REMOVE = 2;
    public static final int OPER_ROTATE = 3;
    public static final int OPER_MERGE = 4;
    public static final String TAG_STACK_MATRIX = "quark:enchantingMatrix";
    private static final String TAG_MATRIX = "matrix";
    private static final String TAG_MATRIX_UUID_LESS = "uuidLess";
    private static final String TAG_MATRIX_UUID_MOST = "uuidMost";
    private static final String TAG_CHARGE = "charge";
    public EnchantmentMatrix matrix;
    private boolean matrixDirty = false;
    public boolean clientMatrixDirty = false;
    private UUID matrixId;
    public final Map<Enchantment, Integer> influences = new HashMap<Enchantment, Integer>();
    public int bookshelfPower;
    public int enchantability;
    public int charge;

    public MatrixEnchantingTableBlockEntity(BlockPos pos, BlockState state) {
        super(MatrixEnchantingModule.blockEntityType, pos, state);
    }

    public static void tick(Level level, BlockPos pos, BlockState state, MatrixEnchantingTableBlockEntity be) {
        be.tick();
    }

    @Override
    public void tick() {
        ItemStack lapis;
        super.tick();
        ItemStack item = this.getItem(0);
        if (item.isEmpty()) {
            if (this.matrix != null) {
                this.matrixDirty = true;
                this.matrix = null;
            }
        } else {
            this.loadMatrix(item);
            if (this.level.getGameTime() % 20L == 0L || this.matrixDirty) {
                this.updateEnchantPower();
            }
        }
        if (this.charge <= 0 && !this.level.isClientSide && !(lapis = this.getItem(1)).isEmpty()) {
            lapis.shrink(1);
            this.charge += MatrixEnchantingModule.chargePerLapis;
            this.sync();
        }
        if (this.matrixDirty) {
            this.makeOutput();
            this.matrixDirty = false;
        }
    }

    public void onOperation(Player player, int operation, int arg0, int arg1, int arg2) {
        if (this.matrix == null) {
            return;
        }
        switch (operation) {
            case 0: {
                this.apply(m -> this.generateAndPay((EnchantmentMatrix)m, player));
                break;
            }
            case 1: {
                this.apply(m -> m.place(arg0, arg1, arg2));
                break;
            }
            case 2: {
                this.apply(m -> m.remove(arg0));
                break;
            }
            case 3: {
                this.apply(m -> m.rotate(arg0));
                break;
            }
            case 4: {
                this.apply(m -> m.merge(arg0, arg1));
            }
        }
    }

    public boolean isMatrixInfluenced() {
        return this.matrix.isInfluenced();
    }

    private void apply(Predicate<EnchantmentMatrix> oper) {
        if (oper.test(this.matrix)) {
            ItemStack item = this.getItem(0);
            this.commitMatrix(item);
        }
    }

    private boolean generateAndPay(EnchantmentMatrix matrix, Player player) {
        if (matrix.canGeneratePiece(this.influences, this.bookshelfPower, this.enchantability) && matrix.validateXp(player, this.bookshelfPower)) {
            boolean creative = player.getAbilities().instabuild;
            int cost = matrix.getNewPiecePrice();
            if ((this.charge > 0 || creative) && matrix.generatePiece(this.influences, this.bookshelfPower, this.getItem(0).is(Items.BOOK), false) && !creative) {
                player.giveExperienceLevels(-cost);
                this.charge = Math.max(this.charge - 1, 0);
            }
        }
        return true;
    }

    private void makeOutput() {
        if (this.level.isClientSide) {
            return;
        }
        this.setItem(2, ItemStack.EMPTY);
        ItemStack in = this.getItem(0);
        if (!in.isEmpty() && this.matrix != null && !this.matrix.placedPieces.isEmpty()) {
            ItemStack out = in.copy();
            boolean book = false;
            if (out.getItem() == Items.BOOK) {
                out = new ItemStack((ItemLike)Items.ENCHANTED_BOOK);
                book = true;
            }
            HashMap<Holder<Enchantment>, Integer> enchantments = new HashMap<Holder<Enchantment>, Integer>();
            Iterator<Object> iterator = this.matrix.placedPieces.iterator();
            while (iterator.hasNext()) {
                int n = iterator.next();
                EnchantmentMatrix.Piece p = this.matrix.pieces.get(n);
                if (p == null || p.enchant == null) continue;
                for (Holder o : enchantments.keySet()) {
                    if (o != p.enchant && !((Enchantment)p.enchant.value()).exclusiveSet().contains(o) && !((Enchantment)o.value()).exclusiveSet().contains(p.enchant)) continue;
                    return;
                }
                enchantments.put(p.enchant, p.level);
            }
            if (book) {
                for (Map.Entry entry : enchantments.entrySet()) {
                    EnchantedBookItem.createForEnchantment((EnchantmentInstance)new EnchantmentInstance((Holder)entry.getKey(), ((Integer)entry.getValue()).intValue()));
                }
            } else {
                ItemEnchantments.Mutable mutableEnchList = new ItemEnchantments.Mutable(ItemEnchantments.EMPTY);
                for (Map.Entry e : enchantments.entrySet()) {
                    mutableEnchList.set((Holder)e.getKey(), ((Integer)e.getValue()).intValue());
                }
                EnchantmentHelper.setEnchantments((ItemStack)out, (ItemEnchantments)mutableEnchList.toImmutable());
                out.remove(QuarkDataComponents.STACK_MATRIX);
            }
            this.setItem(2, out);
        }
    }

    private void loadMatrix(ItemStack stack) {
        if (this.matrix == null || this.matrix.target != stack) {
            if (this.matrix != null) {
                this.matrixDirty = true;
            }
            this.matrix = null;
            if (stack.isEnchantable()) {
                this.matrix = new EnchantmentMatrix(stack, this.level);
                this.matrixDirty = true;
                this.makeUUID();
                if (stack.has(QuarkDataComponents.STACK_MATRIX)) {
                    CompoundTag cmp = ((CustomData)stack.get(QuarkDataComponents.STACK_MATRIX)).copyTag();
                    this.matrix.readFromNBT(cmp);
                }
            }
        }
    }

    private void commitMatrix(ItemStack stack) {
        if (this.level.isClientSide) {
            return;
        }
        CompoundTag cmp = new CompoundTag();
        this.matrix.writeToNBT(cmp);
        stack.set(QuarkDataComponents.STACK_MATRIX, (Object)CustomData.of((CompoundTag)cmp));
        this.matrixDirty = true;
        this.makeUUID();
        this.sync();
        this.setChanged();
    }

    private void makeUUID() {
        if (!this.level.isClientSide) {
            this.matrixId = UUID.randomUUID();
        }
    }

    public void updateEnchantPower() {
        ItemStack item = this.getItem(0);
        this.influences.clear();
        if (!item.isEmpty()) {
            this.enchantability = Quark.ZETA.itemExtensions.get(item).getEnchantmentValueZeta(item);
        }
        boolean allowWater = MatrixEnchantingModule.allowUnderwaterEnchanting;
        boolean allowShort = MatrixEnchantingModule.allowShortBlockEnchanting;
        float power = 0.0f;
        for (int j = -1; j <= 1; ++j) {
            for (int k = -1; k <= 1; ++k) {
                if (!this.isAirGap(j, k, allowWater, allowShort)) continue;
                power += this.getEnchantPowerAt(this.level, this.worldPosition.offset(k * 2, 0, j * 2));
                power += this.getEnchantPowerAt(this.level, this.worldPosition.offset(k * 2, 1, j * 2));
                if (k == 0 || j == 0) continue;
                power += this.getEnchantPowerAt(this.level, this.worldPosition.offset(k * 2, 0, j));
                power += this.getEnchantPowerAt(this.level, this.worldPosition.offset(k * 2, 1, j));
                power += this.getEnchantPowerAt(this.level, this.worldPosition.offset(k, 0, j * 2));
                power += this.getEnchantPowerAt(this.level, this.worldPosition.offset(k, 1, j * 2));
            }
        }
        this.bookshelfPower = Math.min((int)power, MatrixEnchantingModule.maxBookshelves);
    }

    private boolean isAirGap(int j, int k, boolean allowWater, boolean allowShortBlock) {
        if (j != 0 || k != 0) {
            BlockPos test = this.worldPosition.offset(k, 0, j);
            BlockPos testUp = test.above();
            return (this.level.isEmptyBlock(test) || allowWater && this.level.getBlockState(test).getBlock() == Blocks.WATER || allowShortBlock && MatrixEnchantingTableBlockEntity.isShortBlock(this.level, test)) && (this.level.isEmptyBlock(testUp) || allowWater && this.level.getBlockState(testUp).getBlock() == Blocks.WATER || allowShortBlock && MatrixEnchantingTableBlockEntity.isShortBlock(this.level, testUp));
        }
        return false;
    }

    public static boolean isShortBlock(Level level, BlockPos pos) {
        BlockState state = level.getBlockState(pos);
        VoxelShape shape = state.getShape((BlockGetter)level, pos, CollisionContext.empty());
        if (shape.isEmpty()) {
            return true;
        }
        AABB bounds = shape.bounds();
        float f = 0.1875f;
        return bounds.minY == 0.0 && bounds.maxY <= (double)f || bounds.maxY == 1.0 && bounds.minY >= (double)(1.0f - f);
    }

    private float getEnchantPowerAt(Level world, BlockPos pos) {
        IEnchantmentInfluencer influencer;
        BlockState state = world.getBlockState(pos);
        if (MatrixEnchantingModule.allowInfluencing && (influencer = MatrixEnchantingTableBlockEntity.getInfluencerFromBlock(state, world, pos)) != null) {
            int count = influencer.getInfluenceStack((BlockGetter)world, pos, state);
            List<Holder.Reference> influencedEnchants = world.registryAccess().lookupOrThrow(Registries.ENCHANTMENT).listElements().filter(it -> influencer.influencesEnchantment((BlockGetter)world, pos, state, (Holder<Enchantment>)it)).toList();
            List<Holder.Reference> dampenedEnchants = world.registryAccess().lookupOrThrow(Registries.ENCHANTMENT).listElements().filter(it -> influencer.dampensEnchantment((BlockGetter)world, pos, state, (Holder<Enchantment>)it)).toList();
            if (!influencedEnchants.isEmpty() || !dampenedEnchants.isEmpty()) {
                int curr;
                for (Holder.Reference e : influencedEnchants) {
                    curr = this.influences.getOrDefault(e.value(), 0);
                    this.influences.put((Enchantment)e.value(), curr + count);
                }
                for (Holder.Reference e : dampenedEnchants) {
                    curr = this.influences.getOrDefault(e.value(), 0);
                    this.influences.put((Enchantment)e.value(), curr - count);
                }
                return 1.0f;
            }
        }
        return state.getEnchantPowerBonus((LevelReader)world, pos);
    }

    public void writeSharedNBT(CompoundTag cmp, HolderLookup.Provider provider) {
        super.writeSharedNBT(cmp, provider);
        CompoundTag matrixCmp = new CompoundTag();
        if (this.matrix != null) {
            this.matrix.writeToNBT(matrixCmp);
            cmp.put(TAG_MATRIX, (Tag)matrixCmp);
            if (this.matrixId != null) {
                cmp.putLong(TAG_MATRIX_UUID_LESS, this.matrixId.getLeastSignificantBits());
                cmp.putLong(TAG_MATRIX_UUID_MOST, this.matrixId.getMostSignificantBits());
            }
        }
        cmp.putInt(TAG_CHARGE, this.charge);
    }

    public void readSharedNBT(CompoundTag cmp, HolderLookup.Provider provider) {
        super.readSharedNBT(cmp, provider);
        if (cmp.contains(TAG_MATRIX)) {
            long least = cmp.getLong(TAG_MATRIX_UUID_LESS);
            long most = cmp.getLong(TAG_MATRIX_UUID_MOST);
            UUID newId = new UUID(most, least);
            if (!newId.equals(this.matrixId)) {
                CompoundTag matrixCmp = cmp.getCompound(TAG_MATRIX);
                this.matrixId = newId;
                this.matrix = new EnchantmentMatrix(this.getItem(0), this.level);
                this.matrix.readFromNBT(matrixCmp);
            }
            this.clientMatrixDirty = true;
        } else {
            this.matrix = null;
        }
        this.charge = cmp.getInt(TAG_CHARGE);
    }

    public AbstractContainerMenu createMenu(int id, @NotNull Inventory inv, @NotNull Player player) {
        return new MatrixEnchantingMenu(id, inv, this);
    }

    @NotNull
    public Component getDisplayName() {
        return this.getName();
    }

    @Nullable
    public static IEnchantmentInfluencer getInfluencerFromBlock(BlockState state, Level world, BlockPos pos) {
        Block block = state.getBlock();
        if (block instanceof IEnchantmentInfluencer) {
            IEnchantmentInfluencer influencer = (IEnchantmentInfluencer)block;
            return influencer;
        }
        if (MatrixEnchantingModule.customInfluences.containsKey(state)) {
            return MatrixEnchantingModule.customInfluences.get(state);
        }
        return CandleInfluencer.forBlock(state, world, pos);
    }

    public void startOpen(@NotNull Player player) {
    }

    public void stopOpen(@NotNull Player player) {
    }

    private record CandleInfluencer(boolean inverted) implements IEnchantmentInfluencer
    {
        private static final CandleInfluencer INSTANCE = new CandleInfluencer(false);
        private static final CandleInfluencer INVERTED_INSTANCE = new CandleInfluencer(true);

        @Nullable
        public static CandleInfluencer forBlock(BlockState blockState, Level world, BlockPos pos) {
            if (MatrixEnchantingModule.candleInfluencingFailed) {
                return null;
            }
            if (CANDLES.contains(blockState.getBlock()) && ((Boolean)blockState.getValue((Property)CandleBlock.LIT)).booleanValue()) {
                if (MatrixEnchantingModule.soulCandlesInvert) {
                    BlockPos posBelow = pos.below();
                    BlockState below = world.getBlockState(posBelow);
                    if (below.is(BlockTags.SOUL_FIRE_BASE_BLOCKS)) {
                        return INVERTED_INSTANCE;
                    }
                    if (below.getEnchantPowerBonus((LevelReader)world, posBelow) > 0.0f && (below = world.getBlockState(posBelow = posBelow.below())).is(BlockTags.SOUL_FIRE_BASE_BLOCKS)) {
                        return INVERTED_INSTANCE;
                    }
                }
                return INSTANCE;
            }
            return null;
        }

        private DyeColor getColor(BlockState state) {
            if (!((Boolean)state.getValue((Property)CandleBlock.LIT)).booleanValue()) {
                return null;
            }
            int index = CANDLES.indexOf(state.getBlock());
            return index >= 0 ? DyeColor.values()[index] : null;
        }

        @Override
        public int getEnchantmentInfluenceColor(BlockGetter world, BlockPos pos, BlockState state) {
            DyeColor color = this.getColor(state);
            return color == null ? null : Integer.valueOf(color.getTextureDiffuseColor());
        }

        @Override
        @Nullable
        public ParticleOptions getExtraParticleOptions(BlockGetter world, BlockPos pos, BlockState state) {
            if (this.inverted && ((Boolean)state.getValue((Property)CandleBlock.LIT)).booleanValue()) {
                return ParticleTypes.SOUL;
            }
            return null;
        }

        @Override
        public double getExtraParticleChance(BlockGetter world, BlockPos pos, BlockState state) {
            return 0.25;
        }

        @Override
        public int getInfluenceStack(BlockGetter world, BlockPos pos, BlockState state) {
            return (Boolean)state.getValue((Property)CandleBlock.LIT) != false ? (Integer)state.getValue((Property)CandleBlock.CANDLES) : 0;
        }

        @Override
        public boolean influencesEnchantment(BlockGetter world, BlockPos pos, BlockState state, Holder<Enchantment> enchantment) {
            DyeColor color = this.getColor(state);
            if (color == null) {
                return false;
            }
            InfluenceLocations influence = MatrixEnchantingModule.candleInfluences.get(color);
            List<ResourceLocation> boosts = this.inverted ? influence.dampen() : influence.boost();
            return boosts.contains(ResourceLocation.parse((String)enchantment.getRegisteredName()));
        }

        @Override
        public boolean dampensEnchantment(BlockGetter world, BlockPos pos, BlockState state, Holder<Enchantment> enchantment) {
            DyeColor color = this.getColor(state);
            if (color == null) {
                return false;
            }
            InfluenceLocations influence = MatrixEnchantingModule.candleInfluences.get(color);
            List<ResourceLocation> dampens = this.inverted ? influence.boost() : influence.dampen();
            return dampens.contains(ResourceLocation.parse((String)enchantment.getRegisteredName()));
        }
    }
}

