/*
 * Decompiled with CFR 0.152.
 */
package org.violetmoon.quark.content.mobs.client.model;

import com.google.common.collect.ImmutableSet;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import java.util.Set;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;
import org.jetbrains.annotations.NotNull;
import org.violetmoon.quark.content.mobs.entity.Crab;

public class CrabModel
extends EntityModel<Crab> {
    private float wiggleX = 0.0f;
    private float wiggleY = 0.0f;
    private float crabSize = 0.0f;
    public ModelPart group;
    public ModelPart body;
    public ModelPart rightClaw;
    public ModelPart leftClaw;
    public ModelPart rightLeg1;
    public ModelPart rightLeg2;
    public ModelPart rightLeg3;
    public ModelPart rightLeg4;
    public ModelPart leftLeg1;
    public ModelPart leftLeg2;
    public ModelPart leftLeg3;
    public ModelPart leftLeg4;
    public ModelPart rightEye;
    public ModelPart leftEye;
    private final Set<ModelPart> leftLegs;
    private final Set<ModelPart> rightLegs;

    public CrabModel(ModelPart root) {
        this.group = root.getChild("group");
        this.body = this.group.getChild("body");
        this.rightClaw = this.group.getChild("rightClaw");
        this.leftClaw = this.group.getChild("leftClaw");
        this.rightLeg1 = this.group.getChild("rightLeg1");
        this.rightLeg2 = this.group.getChild("rightLeg2");
        this.rightLeg3 = this.group.getChild("rightLeg3");
        this.rightLeg4 = this.group.getChild("rightLeg4");
        this.leftLeg1 = this.group.getChild("leftLeg1");
        this.leftLeg2 = this.group.getChild("leftLeg2");
        this.leftLeg3 = this.group.getChild("leftLeg3");
        this.leftLeg4 = this.group.getChild("leftLeg4");
        this.rightEye = this.body.getChild("rightEye");
        this.leftEye = this.body.getChild("leftEye");
        this.leftLegs = ImmutableSet.of((Object)this.leftLeg1, (Object)this.leftLeg2, (Object)this.leftLeg3, (Object)this.leftLeg4);
        this.rightLegs = ImmutableSet.of((Object)this.rightLeg1, (Object)this.rightLeg2, (Object)this.rightLeg3, (Object)this.rightLeg4);
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition mesh = new MeshDefinition();
        PartDefinition root = mesh.getRoot();
        PartDefinition group = root.addOrReplaceChild("group", CubeListBuilder.create(), PartPose.ZERO);
        PartDefinition body = group.addOrReplaceChild("body", CubeListBuilder.create().texOffs(0, 0).addBox(-4.0f, -2.5f, -3.0f, 8.0f, 5.0f, 6.0f), PartPose.offsetAndRotation((float)0.0f, (float)20.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f));
        group.addOrReplaceChild("leftLeg4", CubeListBuilder.create().mirror().texOffs(0, 19).addBox(0.0f, -0.5f, -0.5f, 6.0f, 1.0f, 1.0f), PartPose.offsetAndRotation((float)3.0f, (float)20.0f, (float)-1.0f, (float)0.0f, (float)0.43633232f, (float)0.7853982f));
        group.addOrReplaceChild("leftLeg3", CubeListBuilder.create().mirror().texOffs(0, 19).addBox(0.0f, -0.5f, -0.5f, 6.0f, 1.0f, 1.0f), PartPose.offsetAndRotation((float)3.0f, (float)20.0f, (float)0.0f, (float)0.0f, (float)0.21816616f, (float)0.7853982f));
        body.addOrReplaceChild("rightEye", CubeListBuilder.create().texOffs(0, 11).addBox(-3.0f, -3.5f, -2.85f, 1.0f, 3.0f, 1.0f), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)-0.3926991f, (float)0.0f, (float)0.0f));
        group.addOrReplaceChild("rightLeg4", CubeListBuilder.create().texOffs(0, 19).addBox(-6.0f, -0.5f, -0.5f, 6.0f, 1.0f, 1.0f), PartPose.offsetAndRotation((float)-3.0f, (float)20.0f, (float)-1.0f, (float)0.0f, (float)-0.43633232f, (float)-0.7853982f));
        group.addOrReplaceChild("rightClaw", CubeListBuilder.create().texOffs(14, 11).addBox(-3.0f, -2.5f, -6.0f, 3.0f, 5.0f, 6.0f), PartPose.offsetAndRotation((float)-3.0f, (float)20.0f, (float)-4.0f, (float)0.0f, (float)0.3926991f, (float)-0.3926991f));
        group.addOrReplaceChild("leftLeg1", CubeListBuilder.create().mirror().texOffs(0, 19).addBox(0.0f, -0.5f, -0.5f, 6.0f, 1.0f, 1.0f), PartPose.offsetAndRotation((float)3.0f, (float)20.0f, (float)2.0f, (float)0.0f, (float)-0.43633232f, (float)0.7853982f));
        group.addOrReplaceChild("rightLeg2", CubeListBuilder.create().mirror().texOffs(0, 19).addBox(-6.0f, -0.5f, -0.5f, 6.0f, 1.0f, 1.0f), PartPose.offsetAndRotation((float)-3.0f, (float)20.0f, (float)0.9f, (float)0.0f, (float)0.21816616f, (float)-0.7853982f));
        group.addOrReplaceChild("leftClaw", CubeListBuilder.create().mirror().texOffs(14, 11).addBox(0.0f, -2.5f, -6.0f, 3.0f, 5.0f, 6.0f), PartPose.offsetAndRotation((float)3.0f, (float)20.0f, (float)-4.0f, (float)0.0f, (float)-0.3926991f, (float)0.3926991f));
        group.addOrReplaceChild("rightLeg1", CubeListBuilder.create().texOffs(0, 19).addBox(-6.0f, -0.5f, -0.5f, 6.0f, 1.0f, 1.0f), PartPose.offsetAndRotation((float)-3.0f, (float)20.0f, (float)2.0f, (float)0.0f, (float)0.43633232f, (float)-0.7853982f));
        body.addOrReplaceChild("leftEye", CubeListBuilder.create().texOffs(0, 11).addBox(2.0f, -3.5f, -2.85f, 1.0f, 3.0f, 1.0f), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)-0.3926991f, (float)0.0f, (float)0.0f));
        group.addOrReplaceChild("leftLeg2", CubeListBuilder.create().mirror().texOffs(0, 19).addBox(0.0f, -0.5f, -0.5f, 6.0f, 1.0f, 1.0f), PartPose.offsetAndRotation((float)3.0f, (float)20.0f, (float)0.9f, (float)0.0f, (float)-0.21816616f, (float)0.7853982f));
        group.addOrReplaceChild("rightLeg3", CubeListBuilder.create().texOffs(0, 19).addBox(-6.0f, -0.5f, -0.5f, 6.0f, 1.0f, 1.0f), PartPose.offsetAndRotation((float)-3.0f, (float)20.0f, (float)0.0f, (float)0.0f, (float)-0.21816616f, (float)-0.7853982f));
        return LayerDefinition.create((MeshDefinition)mesh, (int)32, (int)32);
    }

    public void setRotateAngle(ModelPart modelRenderer, float x, float y, float z) {
        modelRenderer.xRot = x;
        modelRenderer.yRot = y;
        modelRenderer.zRot = z;
    }

    public void setupAnim(Crab crab, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.rightLeg1.zRot = -0.2618f + (-1.0f + Mth.cos((float)(limbSwing * 0.6662f))) * 0.7f * limbSwingAmount;
        this.rightLeg2.zRot = -0.5236f + (-1.0f + Mth.cos((float)(limbSwing * 0.6662f + (float)Math.PI))) * 0.7f * limbSwingAmount;
        this.rightLeg3.zRot = -0.5236f + (-1.0f + Mth.cos((float)(limbSwing * 0.6662f))) * 0.7f * limbSwingAmount;
        this.rightLeg4.zRot = -0.2618f + (-1.0f + Mth.cos((float)(limbSwing * 0.6662f + (float)Math.PI))) * 0.7f * limbSwingAmount;
        this.leftLeg1.zRot = 0.2618f + (1.0f + Mth.cos((float)(limbSwing * 0.6662f + (float)Math.PI))) * 0.7f * limbSwingAmount;
        this.leftLeg2.zRot = 0.5236f + (1.0f + Mth.cos((float)(limbSwing * 0.6662f))) * 0.7f * limbSwingAmount;
        this.leftLeg3.zRot = 0.5236f + (1.0f + Mth.cos((float)(limbSwing * 0.6662f + (float)Math.PI))) * 0.7f * limbSwingAmount;
        this.leftLeg4.zRot = 0.2618f + (1.0f + Mth.cos((float)(limbSwing * 0.6662f))) * 0.7f * limbSwingAmount;
        this.leftClaw.xRot = 0.0f;
        this.rightClaw.xRot = 0.0f;
        this.wiggleX = 0.0f;
        this.wiggleY = 0.0f;
        this.crabSize = crab.getSizeModifier();
        if (this.young) {
            this.crabSize /= 2.0f;
        }
        if (crab.isRaving()) {
            float armRot;
            float crabRaveBPM = 31.25f;
            float freq = 20.0f / crabRaveBPM;
            float tick = ageInTicks * freq;
            float sin = (float)(Math.sin(tick) * 0.5 + 0.5);
            float legRot = sin * 0.8f + 0.6f;
            this.leftLegs.forEach(l -> {
                l.zRot = legRot;
            });
            this.rightLegs.forEach(l -> {
                l.zRot = -legRot;
            });
            float maxHeight = -0.05f;
            float horizontalOff = 0.2f;
            this.wiggleX = (sin - 0.5f) * 2.0f * maxHeight + maxHeight / 2.0f;
            float slowSin = (float)Math.sin(tick / 2.0f);
            this.wiggleY = slowSin * horizontalOff;
            this.leftClaw.xRot = armRot = sin * 0.5f - 1.2f;
            this.rightClaw.xRot = armRot;
        }
    }

    public void renderToBuffer(PoseStack matrix, @NotNull VertexConsumer vb, int packedLightIn, int packedOverlayIn, int color) {
        matrix.pushPose();
        matrix.translate(0.0, 1.5 - (double)this.crabSize * 1.5, 0.0);
        matrix.scale(this.crabSize, this.crabSize, this.crabSize);
        matrix.mulPose(Axis.YP.rotationDegrees(90.0f));
        matrix.translate(this.wiggleX, this.wiggleY, 0.0f);
        this.group.render(matrix, vb, packedLightIn, packedOverlayIn, color);
        matrix.popPose();
    }
}

