/*
 * Decompiled with CFR 0.152.
 */
package org.violetmoon.quark.content.experimental.module;

import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.List;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import org.violetmoon.zeta.client.event.load.ZClientSetup;
import org.violetmoon.zeta.config.Config;
import org.violetmoon.zeta.event.bus.LoadEvent;
import org.violetmoon.zeta.module.ZetaLoadModule;
import org.violetmoon.zeta.module.ZetaModule;
import org.violetmoon.zeta.util.RegistryUtil;

@ZetaLoadModule(category="experimental", enabledByDefault=false, description="This feature generates Resource Pack Item Model predicates on the items defined in 'Items to Change'\nfor the Enchantments defined in 'Enchantments to Register'.\n\nExample: if 'minecraft:silk_touch' is added to 'Enchantments to Register', and 'minecraft:netherite_pickaxe'\nis added to 'Items to Change', then a predicate named 'quark_has_enchant_minecraft_silk_touch' will be available\nto the netherite_pickaxe.json item model, whose value will be the enchantment level.")
public class EnchantmentPredicatesModule
extends ZetaModule {
    @Config
    public static List<String> itemsToChange = Lists.newArrayList();
    @Config
    public static List<String> enchantmentsToRegister = Lists.newArrayList();

    @ZetaLoadModule(clientReplacement=true)
    public static class Client
    extends EnchantmentPredicatesModule {
        @LoadEvent
        public void clientSetup(ZClientSetup e) {
            if (this.isEnabled()) {
                e.enqueueWork(() -> {
                    List items = RegistryUtil.massRegistryGet((Collection)itemsToChange, (Registry)BuiltInRegistries.ITEM);
                });
            }
        }
    }
}

