/*
 * Decompiled with CFR 0.152.
 */
package org.violetmoon.quark.content.client.tooltip;

import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.datafixers.util.Either;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.client.multiplayer.ClientPacketListener;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentContents;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.contents.TranslatableContents;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.ItemContainerContents;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.ShulkerBoxBlock;
import org.jetbrains.annotations.NotNull;
import org.violetmoon.quark.base.Quark;
import org.violetmoon.quark.base.handler.SimilarBlockTypeHandler;
import org.violetmoon.quark.content.client.module.ChestSearchingModule;
import org.violetmoon.quark.content.client.module.ImprovedTooltipsModule;
import org.violetmoon.zeta.client.event.play.ZGatherTooltipComponents;

public class ShulkerBoxTooltips {
    public static final ResourceLocation WIDGET_RESOURCE = Quark.asResource("textures/misc/shulker_widget.png");

    public static void makeTooltip(ZGatherTooltipComponents event) {
        ItemStack stack = event.getItemStack();
        if (SimilarBlockTypeHandler.isShulkerBox(stack) && stack.has(DataComponents.CONTAINER)) {
            ItemContainerContents contents = (ItemContainerContents)stack.get(DataComponents.CONTAINER);
            if (contents.nonEmptyStream().toList().isEmpty()) {
                return;
            }
            ClientPacketListener listener = Minecraft.getInstance().getConnection();
            List tooltip = event.getTooltipElements();
            ArrayList tooltipCopy = new ArrayList(tooltip);
            for (int i = 1; i < tooltipCopy.size(); ++i) {
                TranslatableContents translatableContents;
                Object t;
                Either either = (Either)tooltipCopy.get(i);
                if (!either.left().isPresent() || !((t = either.left().get()) instanceof MutableComponent)) continue;
                MutableComponent component = (MutableComponent)t;
                String s = ((FormattedText)either.left().get()).getString();
                ComponentContents componentContents = component.getContents();
                if (!(componentContents instanceof TranslatableContents) || !(translatableContents = (TranslatableContents)componentContents).getKey().contains("container.shulkerBox")) continue;
                tooltip.remove(either);
            }
            if (!ImprovedTooltipsModule.shulkerBoxRequireShift || Screen.hasShiftDown()) {
                tooltip.add(1, Either.right((Object)new ShulkerComponent(stack)));
            }
            if (ImprovedTooltipsModule.shulkerBoxRequireShift && !Screen.hasShiftDown()) {
                tooltip.add(1, Either.left((Object)Component.translatable((String)"quark.misc.shulker_box_shift")));
            }
        }
    }

    public record ShulkerComponent(ItemStack stack) implements ClientTooltipComponent,
    TooltipComponent
    {
        private static final int[][] TARGET_RATIOS = new int[][]{{1, 1}, {9, 3}, {9, 5}, {9, 6}, {9, 8}, {9, 9}, {12, 9}};
        private static final int CORNER = 5;
        private static final int BUFFER = 1;
        private static final int EDGE = 18;

        public void renderImage(@NotNull Font font, int tooltipX, int tooltipY, @NotNull GuiGraphics guiGraphics) {
            Minecraft mc = Minecraft.getInstance();
            PoseStack pose = guiGraphics.pose();
            if (this.stack.has(DataComponents.CONTAINER)) {
                ShulkerBoxBlock boxBlock;
                DyeColor dye;
                Block block;
                Window window;
                int texWidth;
                int right;
                ItemContainerContents contents = (ItemContainerContents)this.stack.get(DataComponents.CONTAINER);
                ItemStack currentBox = this.stack;
                int currentX = tooltipX;
                int currentY = tooltipY - 1;
                int size = contents.getSlots();
                int[] dims = new int[]{Math.min(size, 9), 1 + (size - 1) / 9};
                for (int[] testAgainst : TARGET_RATIOS) {
                    if (testAgainst[0] * testAgainst[1] != size) continue;
                    dims = testAgainst;
                    break;
                }
                if ((right = currentX + (texWidth = 10 + 18 * dims[0])) > (window = mc.getWindow()).getGuiScaledWidth()) {
                    currentX -= right - window.getGuiScaledWidth();
                }
                pose.pushPose();
                pose.translate(0.0f, 0.0f, 700.0f);
                int color = -1;
                if (ImprovedTooltipsModule.shulkerBoxUseColors && (block = ((BlockItem)currentBox.getItem()).getBlock()) instanceof ShulkerBoxBlock && (dye = (boxBlock = (ShulkerBoxBlock)block).getColor()) != null) {
                    color = dye.getTextureDiffuseColor();
                }
                ShulkerComponent.renderTooltipBackground(guiGraphics, mc, pose, currentX, currentY, dims[0], dims[1], color);
                int skipped = 0;
                for (int i = 0; i < size; ++i) {
                    ItemStack itemstack = contents.getStackInSlot(i);
                    if (itemstack.isEmpty()) {
                        ++skipped;
                        continue;
                    }
                    int xp = currentX + 6 + (i - skipped) % 9 * 18;
                    int yp = currentY + 6 + (i - skipped) / 9 * 18;
                    guiGraphics.renderItem(itemstack, xp, yp);
                    guiGraphics.renderItemDecorations(mc.font, itemstack, xp, yp);
                    if (((ChestSearchingModule)Quark.ZETA.modules.get(ChestSearchingModule.class)).namesMatch(itemstack)) continue;
                    RenderSystem.disableDepthTest();
                    guiGraphics.fill(xp, yp, xp + 16, yp + 16, -1442840576);
                }
                pose.popPose();
            }
        }

        public static void renderTooltipBackground(GuiGraphics guiGraphics, Minecraft mc, PoseStack matrix, int x, int y, int width, int height, int color) {
            RenderSystem.setShader(GameRenderer::getPositionTexShader);
            RenderSystem.setShaderTexture((int)0, (ResourceLocation)WIDGET_RESOURCE);
            RenderSystem.setShaderColor((float)((float)((color & 0xFF0000) >> 16) / 255.0f), (float)((float)((color & 0xFF00) >> 8) / 255.0f), (float)((float)(color & 0xFF) / 255.0f), (float)1.0f);
            guiGraphics.blit(WIDGET_RESOURCE, x, y, 0.0f, 0.0f, 5, 5, 256, 256);
            guiGraphics.blit(WIDGET_RESOURCE, x + 5 + 18 * width, y + 5 + 18 * height, 25.0f, 25.0f, 5, 5, 256, 256);
            guiGraphics.blit(WIDGET_RESOURCE, x + 5 + 18 * width, y, 25.0f, 0.0f, 5, 5, 256, 256);
            guiGraphics.blit(WIDGET_RESOURCE, x, y + 5 + 18 * height, 0.0f, 25.0f, 5, 5, 256, 256);
            for (int row = 0; row < height; ++row) {
                guiGraphics.blit(WIDGET_RESOURCE, x, y + 5 + 18 * row, 0.0f, 6.0f, 5, 18, 256, 256);
                guiGraphics.blit(WIDGET_RESOURCE, x + 5 + 18 * width, y + 5 + 18 * row, 25.0f, 6.0f, 5, 18, 256, 256);
                for (int col = 0; col < width; ++col) {
                    if (row == 0) {
                        guiGraphics.blit(WIDGET_RESOURCE, x + 5 + 18 * col, y, 6.0f, 0.0f, 18, 5, 256, 256);
                        guiGraphics.blit(WIDGET_RESOURCE, x + 5 + 18 * col, y + 5 + 18 * height, 6.0f, 25.0f, 18, 5, 256, 256);
                    }
                    guiGraphics.blit(WIDGET_RESOURCE, x + 5 + 18 * col, y + 5 + 18 * row, 6.0f, 6.0f, 18, 18, 256, 256);
                }
            }
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }

        public int getHeight() {
            if (this.stack.isEmpty() || !this.stack.has(DataComponents.CONTAINER)) {
                return 0;
            }
            ItemContainerContents contents = (ItemContainerContents)this.stack.get(DataComponents.CONTAINER);
            return 11 + (1 + (Math.toIntExact(contents.nonEmptyStream().count()) - 1) / 9) * 18;
        }

        public int getWidth(@NotNull Font font) {
            if (this.stack.isEmpty() || !this.stack.has(DataComponents.CONTAINER)) {
                return 0;
            }
            ItemContainerContents contents = (ItemContainerContents)this.stack.get(DataComponents.CONTAINER);
            return 9 + Math.min(Math.toIntExact(contents.nonEmptyStream().count()), 9) * 18;
        }
    }
}

