/*
 * Decompiled with CFR 0.152.
 */
package org.violetmoon.quark.content.building.block;

import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.NoteBlockInstrument;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.MapColor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.violetmoon.quark.content.building.module.RainbowLampsModule;
import org.violetmoon.zeta.block.ZetaGlassBlock;
import org.violetmoon.zeta.module.ZetaModule;

public class RainbowLampBlock
extends ZetaGlassBlock {
    public final int color;
    public static final BooleanProperty LIT = BlockStateProperties.LIT;
    private String corundumDescriptionId;

    public RainbowLampBlock(String regname, int color, @Nullable ZetaModule module, MapColor mapColor) {
        super(regname, module, true, BlockBehaviour.Properties.of().strength(0.3f, 0.0f).mapColor(mapColor).instrument(NoteBlockInstrument.HAT).sound(SoundType.AMETHYST).lightLevel(b -> (Boolean)b.getValue((Property)LIT) != false ? RainbowLampsModule.lightLevel : 0).noOcclusion());
        this.color = color;
        if (module == null) {
            return;
        }
        this.setCreativeTab(CreativeModeTabs.REDSTONE_BLOCKS);
        this.setCreativeTab(CreativeModeTabs.COLORED_BLOCKS);
    }

    @NotNull
    public String getDescriptionId() {
        if (RainbowLampsModule.isCorundum()) {
            if (this.corundumDescriptionId == null) {
                this.corundumDescriptionId = super.getDescriptionId().replaceAll("crystal", "corundum");
            }
            return this.corundumDescriptionId;
        }
        return super.getDescriptionId();
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext ctx) {
        return (BlockState)this.defaultBlockState().setValue((Property)LIT, (Comparable)Boolean.valueOf(ctx.getLevel().hasNeighborSignal(ctx.getClickedPos())));
    }

    public void neighborChanged(@NotNull BlockState state, @NotNull Level world, @NotNull BlockPos pos, @NotNull Block blockIn, @NotNull BlockPos fromPos, boolean isMoving) {
        boolean flag;
        if (!world.isClientSide && (flag = ((Boolean)state.getValue((Property)LIT)).booleanValue()) != world.hasNeighborSignal(pos)) {
            if (flag) {
                world.scheduleTick(pos, (Block)this, 4);
            } else {
                world.setBlock(pos, (BlockState)state.cycle((Property)LIT), 2);
            }
        }
    }

    public void tick(@NotNull BlockState state, @NotNull ServerLevel world, @NotNull BlockPos pos, @NotNull RandomSource rand) {
        if (((Boolean)state.getValue((Property)LIT)).booleanValue() && !world.hasNeighborSignal(pos)) {
            world.setBlock(pos, (BlockState)state.cycle((Property)LIT), 2);
        }
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{LIT});
    }

    public Integer getBeaconColorMultiplierZeta(BlockState state, LevelReader world, BlockPos pos, BlockPos beaconPos) {
        return (Boolean)state.getValue((Property)LIT) != false ? Integer.valueOf(this.color) : null;
    }
}

