/*
 * Decompiled with CFR 0.152.
 */
package org.violetmoon.quark.content.tools.item;

import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.monster.Slime;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.levelgen.WorldgenRandom;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.violetmoon.zeta.item.ZetaItem;
import org.violetmoon.zeta.module.ZetaModule;
import org.violetmoon.zeta.registry.CreativeTabManager;
import org.violetmoon.zeta.util.ItemNBTHelper;

public class SlimeInABucketItem
extends ZetaItem {
    public static final String TAG_ENTITY_DATA = "slime_nbt";
    public static final String TAG_EXCITED = "excited";

    public SlimeInABucketItem(ZetaModule module) {
        super("slime_in_a_bucket", module, new Item.Properties().m_41487_(1).m_41495_(Items.f_42446_));
        CreativeTabManager.addToCreativeTabNextTo((ResourceKey)CreativeModeTabs.f_256869_, (ItemLike)this, (ItemLike)Items.f_220210_, (boolean)false);
    }

    public void m_6883_(@NotNull ItemStack stack, @NotNull Level world, @NotNull Entity entity, int itemSlot, boolean isSelected) {
        if (world instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)world;
            Vec3 pos = entity.m_20182_();
            int x = Mth.m_14107_((double)pos.f_82479_);
            int z = Mth.m_14107_((double)pos.f_82481_);
            boolean slime = SlimeInABucketItem.isSlimeChunk(serverLevel, x, z);
            boolean excited = ItemNBTHelper.getBoolean((ItemStack)stack, (String)TAG_EXCITED, (boolean)false);
            if (excited != slime) {
                ItemNBTHelper.setBoolean((ItemStack)stack, (String)TAG_EXCITED, (boolean)slime);
            }
        }
    }

    @NotNull
    public InteractionResult m_6225_(UseOnContext context) {
        BlockPos pos = context.m_8083_();
        Direction facing = context.m_43719_();
        Level level = context.m_43725_();
        Player player = context.m_43723_();
        InteractionHand hand = context.m_43724_();
        double x = (double)pos.m_123341_() + 0.5 + (double)facing.m_122429_();
        double y = (double)pos.m_123342_() + 0.5 + (double)facing.m_122430_();
        double z = (double)pos.m_123343_() + 0.5 + (double)facing.m_122431_();
        if (!level.f_46443_) {
            Slime slime = new Slime(EntityType.f_20526_, level);
            CompoundTag data = ItemNBTHelper.getCompound((ItemStack)player.m_21120_(hand), (String)TAG_ENTITY_DATA, (boolean)true);
            if (data != null) {
                slime.m_20258_(data);
            } else {
                slime.m_21051_(Attributes.f_22276_).m_22100_(1.0);
                slime.m_21051_(Attributes.f_22279_).m_22100_(0.3);
                slime.m_21153_(slime.m_21233_());
            }
            slime.m_6034_(x, y, z);
            if (player.m_150110_().f_35937_) {
                slime.m_20084_(UUID.randomUUID());
            }
            level.m_220400_((Entity)player, GameEvent.f_157810_, slime.m_20182_());
            level.m_7967_((Entity)slime);
            player.m_6674_(hand);
        }
        level.m_5594_(player, pos, SoundEvents.f_11778_, SoundSource.NEUTRAL, 1.0f, 1.0f);
        if (!player.m_150110_().f_35937_) {
            player.m_21008_(hand, new ItemStack((ItemLike)Items.f_42446_));
        }
        return InteractionResult.m_19078_((boolean)level.f_46443_);
    }

    @NotNull
    public Component m_7626_(@NotNull ItemStack stack) {
        CompoundTag cmp;
        if (stack.m_41782_() && (cmp = ItemNBTHelper.getCompound((ItemStack)stack, (String)TAG_ENTITY_DATA, (boolean)false)) != null && cmp.m_128441_("CustomName")) {
            MutableComponent custom = Component.Serializer.m_130701_((String)cmp.m_128461_("CustomName"));
            return Component.m_237110_((String)"item.quark.slime_in_a_bucket.named", (Object[])new Object[]{custom});
        }
        return super.m_7626_(stack);
    }

    public static boolean isSlimeChunk(ServerLevel world, int x, int z) {
        ChunkPos chunkpos = new ChunkPos(new BlockPos(x, 0, z));
        return WorldgenRandom.m_224681_((int)chunkpos.f_45578_, (int)chunkpos.f_45579_, (long)world.m_7328_(), (long)987234911L).m_188503_(10) == 0;
    }
}

