/*
 * Decompiled with CFR 0.152.
 */
package org.violetmoon.quark.base.client.render;

import com.google.common.base.Functions;
import com.google.common.collect.ImmutableMap;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.client.model.BoatModel;
import net.minecraft.client.model.ChestBoatModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.vehicle.Boat;
import org.jetbrains.annotations.NotNull;
import org.joml.Quaternionf;
import org.violetmoon.quark.base.client.handler.ModelHandler;
import org.violetmoon.quark.base.handler.WoodSetHandler;
import org.violetmoon.quark.base.item.boat.IQuarkBoat;

public class QuarkBoatRenderer
extends EntityRenderer<Boat> {
    private final Map<String, BoatModelTuple> boatResources;

    public QuarkBoatRenderer(EntityRendererProvider.Context context, boolean chest) {
        super(context);
        this.f_114477_ = 0.8f;
        this.boatResources = QuarkBoatRenderer.computeBoatResources(chest, context);
    }

    private static Map<String, BoatModelTuple> computeBoatResources(boolean chest, EntityRendererProvider.Context context) {
        return (Map)WoodSetHandler.boatTypes().collect(ImmutableMap.toImmutableMap((Function)Functions.identity(), name -> {
            String folder = chest ? "chest_boat" : "boat";
            ResourceLocation texture = new ResourceLocation("quark", "textures/model/entity/" + folder + "/" + name + ".png");
            ChestBoatModel model = chest ? new ChestBoatModel(context.m_174023_(ModelHandler.quark_boat_chest)) : new BoatModel(context.m_174023_(ModelHandler.quark_boat));
            return new BoatModelTuple(texture, (BoatModel)model);
        }));
    }

    public void render(Boat boat, float yaw, float partialTicks, PoseStack matrix, @NotNull MultiBufferSource buffer, int light) {
        float f2;
        matrix.m_85836_();
        matrix.m_85837_(0.0, 0.375, 0.0);
        matrix.m_252781_(Axis.f_252436_.m_252977_(180.0f - yaw));
        float wiggleAngle = (float)boat.m_38385_() - partialTicks;
        float wiggleMagnitude = boat.m_38384_() - partialTicks;
        if (wiggleMagnitude < 0.0f) {
            wiggleMagnitude = 0.0f;
        }
        if (wiggleAngle > 0.0f) {
            matrix.m_252781_(Axis.f_252529_.m_252977_(Mth.m_14031_((float)wiggleAngle) * wiggleAngle * wiggleMagnitude / 10.0f * (float)boat.m_38386_()));
        }
        if (!Mth.m_14033_((float)(f2 = boat.m_38352_(partialTicks)), (float)0.0f)) {
            matrix.m_252781_(new Quaternionf().setAngleAxis(boat.m_38352_(partialTicks) * ((float)Math.PI / 180), 1.0f, 0.0f, 1.0f));
        }
        BoatModelTuple tuple = this.getModelWithLocation(boat);
        ResourceLocation loc = tuple.resloc();
        BoatModel model = tuple.model();
        matrix.m_85841_(-1.0f, -1.0f, 1.0f);
        matrix.m_252781_(Axis.f_252436_.m_252977_(90.0f));
        model.m_6973_(boat, partialTicks, 0.0f, -0.1f, 0.0f, 0.0f);
        VertexConsumer vertexconsumer = buffer.m_6299_(model.m_103119_(loc));
        model.m_7695_(matrix, vertexconsumer, light, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
        if (!boat.m_5842_()) {
            VertexConsumer waterMask = buffer.m_6299_(RenderType.m_110478_());
            model.m_102282_().m_104301_(matrix, waterMask, light, OverlayTexture.f_118083_);
        }
        matrix.m_85849_();
        super.m_7392_((Entity)boat, yaw, partialTicks, matrix, buffer, light);
    }

    @Deprecated
    @NotNull
    public ResourceLocation getTextureLocation(@NotNull Boat boat) {
        return this.getModelWithLocation(boat).resloc();
    }

    public BoatModelTuple getModelWithLocation(Boat boat) {
        return this.boatResources.get(((IQuarkBoat)boat).getQuarkBoatTypeObj().name());
    }

    private record BoatModelTuple(ResourceLocation resloc, BoatModel model) {
    }
}

