/*
 * Decompiled with CFR 0.152.
 */
package org.gtreimagined.tesseract.graph.standard;

import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.gtreimagined.tesseract.graph.IElement;
import org.gtreimagined.tesseract.graph.IGrid;
import org.gtreimagined.tesseract.graph.INetwork;
import org.gtreimagined.tesseract.graph.INotableElement;
import org.gtreimagined.tesseract.graph.IRouteTracker;
import org.gtreimagined.tesseract.graph.IRoutingInfo;
import org.gtreimagined.tesseract.graph.RoutedNode;

public abstract class StandardRouteTracker<TRoutingInfo extends IRoutingInfo<TRoutingInfo>, TNotableElement extends INotableElement<TNotableElement, TRoutingInfo, TElement, TNetwork, TGrid>, TElement extends IElement<TElement, TNotableElement, TRoutingInfo, TNetwork, TGrid>, TNetwork extends INetwork<TNetwork, TElement, TNotableElement, TRoutingInfo, TGrid>, TGrid extends IGrid<TGrid, TElement, TNotableElement, TRoutingInfo, TNetwork>>
implements IRouteTracker<TRoutingInfo, TNotableElement, TElement, TNetwork, TGrid> {
    Map<TNotableElement, List<RoutedNode<TNotableElement, TRoutingInfo>>> edges = new Object2ObjectOpenHashMap();
    public final HashSet<TNotableElement> notableElements = new HashSet();

    @Override
    public List<RoutedNode<TNotableElement, TRoutingInfo>> getPaths(TNotableElement source) {
        if (this.edges.containsKey(source)) {
            return this.edges.get(source);
        }
        return List.of();
    }

    @Override
    public void onElementAdded(TElement source) {
        INotableElement notableElement;
        if (this.getNotableElementClass().isInstance(source) && (notableElement = (INotableElement)this.getNotableElementClass().cast(source)).isActuallyNode()) {
            this.notableElements.add(notableElement);
        }
    }

    @Override
    public void onElementRemoved(TElement element) {
        INotableElement notableElement;
        if (this.getNotableElementClass().isInstance(element) && (notableElement = (INotableElement)this.getNotableElementClass().cast(element)).isActuallyNode()) {
            this.notableElements.remove(notableElement);
        }
    }

    @Override
    public void updateEdges() {
        this.edges.clear();
        for (INotableElement notableElement : this.notableElements) {
            List<RoutedNode<INotableElement, TRoutingInfo>> paths = this.makePaths(notableElement);
            if (paths.isEmpty()) continue;
            this.edges.put(notableElement, paths);
        }
        ObjectOpenHashSet uniqueNodes = new ObjectOpenHashSet();
        for (INotableElement notableElement : this.notableElements) {
            if (!this.edges.containsKey(notableElement)) continue;
            List<RoutedNode<TNotableElement, TRoutingInfo>> list = this.edges.get(notableElement);
            for (int j = 0; j < list.size(); ++j) {
                RoutedNode<TNotableElement, TRoutingInfo> node = list.get(j);
                if (uniqueNodes.add(list.get(j))) continue;
                list.set(j, (RoutedNode)uniqueNodes.get(node));
            }
        }
    }

    public abstract int sort(RoutedNode<TNotableElement, TRoutingInfo> var1, RoutedNode<TNotableElement, TRoutingInfo> var2);

    public abstract Class<TNotableElement> getNotableElementClass();

    private List<RoutedNode<TNotableElement, TRoutingInfo>> makePaths(TNotableElement source) {
        ArrayList<RoutedNode<TNotableElement, TRoutingInfo>> sourcePaths = new ArrayList<RoutedNode<TNotableElement, TRoutingInfo>>(source.getRoutedNeighbours());
        sourcePaths.sort(this::sort);
        return sourcePaths;
    }
}

