/*
 * Decompiled with CFR 0.152.
 */
package org.gtreimagined.tesseract.api.eu;

import net.minecraft.class_2350;
import org.gtreimagined.tesseract.api.Serializable;
import org.gtreimagined.tesseract.api.eu.EUState;

public interface IEnergyHandler
extends Serializable {
    public long extractEu(long var1, boolean var3);

    public long insertEu(long var1, boolean var3);

    public long getEnergy();

    public long getCapacity();

    public long getOutputAmperage();

    public long getOutputVoltage();

    public long getInputAmperage();

    public long getInputVoltage();

    public boolean canOutput();

    public boolean canInput();

    public boolean canInput(class_2350 var1);

    public boolean canOutput(class_2350 var1);

    default public long availableAmpsOutput() {
        if (!this.canOutput()) {
            return 0L;
        }
        if (this.getOutputVoltage() == 0L) {
            return 0L;
        }
        long out = Math.min(this.getOutputAmperage(), this.getEnergy() / this.getOutputVoltage());
        if (out == -1L) {
            out = this.getOutputAmperage();
        }
        out = Math.min(out, this.getState().extract(true, out));
        return out;
    }

    default public long availableAmpsInput(long voltage) {
        if (!this.canInput()) {
            return 0L;
        }
        if (this.getInputVoltage() == 0L) {
            return 0L;
        }
        if (this.getState().getAmpsReceived() >= this.getInputAmperage()) {
            return 0L;
        }
        long availableEnergy = this.getCapacity() - this.getEnergy();
        long availableInputAmps = availableEnergy / this.getInputVoltage();
        long out = Math.min(this.getInputAmperage(), availableInputAmps);
        if (out == -1L) {
            out = this.getInputAmperage();
        }
        out = Math.min(out, this.getState().receive(true, out));
        return out;
    }

    public EUState getState();

    default public void tesseractTick() {
    }
}

