/*
 * Decompiled with CFR 0.152.
 */
package org.gtreimagined.tesseract.api.eu;

import it.unimi.dsi.fastutil.longs.LongSet;
import it.unimi.dsi.fastutil.objects.Object2ObjectLinkedOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectMap;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import net.minecraft.class_2960;
import org.gtreimagined.tesseract.TesseractCapUtils;
import org.gtreimagined.tesseract.api.eu.EUGrid;
import org.gtreimagined.tesseract.api.eu.EUHolder;
import org.gtreimagined.tesseract.api.eu.EURouteTracker;
import org.gtreimagined.tesseract.api.eu.EURoutingInfo;
import org.gtreimagined.tesseract.api.eu.EUStatus;
import org.gtreimagined.tesseract.api.eu.EUTransaction;
import org.gtreimagined.tesseract.api.eu.IEUCable;
import org.gtreimagined.tesseract.api.eu.IEUNode;
import org.gtreimagined.tesseract.api.eu.IEnergyHandler;
import org.gtreimagined.tesseract.graph.IRouteTracker;
import org.gtreimagined.tesseract.graph.RoutedNode;
import org.gtreimagined.tesseract.graph.standard.StandardNetwork;

public class EUNetwork
extends StandardNetwork<EUNetwork, IEUCable, IEUNode, EURoutingInfo, EUGrid> {
    public final Object2ObjectMap<class_2960, LongSet> cableIsActive = new Object2ObjectLinkedOpenHashMap();

    protected EUNetwork() {
        super(IEUCable.class, IEUNode.class);
    }

    @Override
    protected IRouteTracker<EURoutingInfo, IEUNode, IEUCable, EUNetwork, EUGrid> createRouteTracker() {
        return new EURouteTracker();
    }

    public void insert(EUTransaction stack, IEUNode node) {
        double previousLoss = 0.0;
        ArrayList<Consumer<Set>> transferList = new ArrayList<Consumer<Set>>();
        for (RoutedNode path : this.getTracker().getPaths(node)) {
            if (path.element().getBlockEntity() == null) continue;
            long remainingEu = stack.eu;
            if (remainingEu <= 0L) break;
            double loss = ((EURoutingInfo)path.routeInfo()).actualLoss();
            double appliedLoss = loss == 0.0 ? 0.0 : (loss > previousLoss ? loss - previousLoss : previousLoss - loss);
            previousLoss = loss;
            long roundedAppliedLoss = Math.round(appliedLoss);
            if (roundedAppliedLoss < 0L || roundedAppliedLoss > remainingEu) continue;
            long lossyEu = remainingEu - roundedAppliedLoss;
            Optional<IEnergyHandler> handler = TesseractCapUtils.INSTANCE.getEnergyHandler(path.element().getBlockEntity(), ((EURoutingInfo)path.routeInfo()).side());
            long euInserted = handler.map(h -> h.insertEu(lossyEu, true)).orElse(0L);
            if (euInserted <= 0L) continue;
            EUTransaction.TransferData data1 = stack.addData(euInserted, euInserted + roundedAppliedLoss, appliedLoss, a -> {});
            transferList.add(l -> this.dataCommit((Set<IEUCable>)l, (EURoutingInfo)path.routeInfo(), (IEnergyHandler)handler.get(), data1));
        }
        if (!transferList.isEmpty()) {
            stack.addData(0L, 0L, 0.0, d -> this.dataCommit(transferList));
        }
    }

    public void dataCommit(Set<IEUCable> cableList, EURoutingInfo routingInfo, IEnergyHandler handler, EUTransaction.TransferData data) {
        if (routingInfo.maxVoltage() < data.getVoltage()) {
            for (IEUCable c : routingInfo.path()) {
                if (Objects.requireNonNull(c.getHandler(data.getVoltage(), 0L)) != EUStatus.FAIL_VOLTAGE) continue;
                c.onCableOverVoltage(c.getBlockEntity().method_10997(), c.getBlockEntity().method_11016().method_10063(), data.getVoltage());
                return;
            }
        } else {
            cableList.addAll(routingInfo.path());
        }
        handler.insertEu(data.getEu(), false);
    }

    public void dataCommit(List<Consumer<Set<IEUCable>>> list) {
        HashSet cableList = new HashSet();
        for (Consumer<Set<IEUCable>> pair : list) {
            pair.accept(cableList);
        }
        for (IEUCable c : cableList) {
            c.setHolder(EUHolder.add(c.getHolder(), 1L));
            if (!EUHolder.isOverAmperage(c.getHolder())) continue;
            c.onCableOverAmperage(c.getBlockEntity().method_10997(), c.getBlockEntity().method_11016().method_10063(), EUHolder.getAmperage(c.getHolder()));
            return;
        }
    }
}

