package org.gtreimagined.tesseract.api.fabric.wrapper;

import net.fabricmc.fabric.api.transfer.v1.context.ContainerItemContext;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.fabricmc.fabric.api.transfer.v1.transaction.Transaction;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2487;
import org.jetbrains.annotations.NotNull;
import org.gtreimagined.tesseract.api.context.TesseractItemContext;

public class ContainerItemContextWrapper implements TesseractItemContext {
    private final ContainerItemContext context;
    public ContainerItemContextWrapper(ContainerItemContext context){
        this.context = context;

    }

    @Override
    public @NotNull class_2487 getTag() {
        if (context.getItemVariant().isBlank()) return new class_2487();
        class_2487 tag = context.getItemVariant().getNbt();
        if (tag == null){
            class_1799 stack = context.getItemVariant().toStack((int) context.getAmount());
            stack.method_7980(new class_2487());
            setItemStack(stack);
        }
        return context.getItemVariant().getNbt();
    }

    @Override
    public class_1792 getItem() {
        return context.getItemVariant().getItem();
    }

    @Override
    public int getCount() {
        return (int) context.getAmount();
    }

    @Override
    public void setItemStack(class_1799 stack) {
        try(Transaction transaction = Transaction.openOuter()) {
            context.exchange(ItemVariant.of(stack), stack.method_7947(), transaction);
            transaction.commit();
        }
    }
}
