package org.gtreimagined.tesseract.api;

import com.google.common.collect.ImmutableList;
import org.gtreimagined.tesseract.graph.IElement;
import org.gtreimagined.tesseract.graph.IGrid;
import org.gtreimagined.tesseract.graph.INetwork;
import org.gtreimagined.tesseract.graph.INotableElement;
import org.gtreimagined.tesseract.graph.IRoutingInfo;
import org.gtreimagined.tesseract.graph.RoutedNode;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_2350;
import net.minecraft.class_2586;

public interface INode<TSelf extends INode<TSelf, TRoutingInfo, TElement, TNetwork, TGrid>, TRoutingInfo extends IRoutingInfo<TRoutingInfo>, TElement extends IElement<TElement, TSelf, TRoutingInfo, TNetwork, TGrid> & IConnectable, TNetwork extends INetwork<TNetwork, TElement, TSelf, TRoutingInfo, TGrid>, TGrid extends IGrid<TGrid, TElement, TSelf, TRoutingInfo, TNetwork>> extends IElement<TElement, TSelf, TRoutingInfo, TNetwork, TGrid>, INotableElement<TSelf, TRoutingInfo, TElement, TNetwork, TGrid>, IConnectable {
    @Override
    default List<RoutedNode<TSelf, TRoutingInfo>> getRoutedNeighbours(){
        List<RoutedNode<TSelf, TRoutingInfo>> list = new ArrayList<>();
        if (!isActuallyNode() || getNetwork() == null) return list;
        for (class_2350 direction : class_2350.values()) {
            if (isOutput(direction)){
                class_2586 source = getBlockEntity();
                if (source != null) {
                    addNeighbor(direction, (TElement) this, list, List.of());
                }
            }
        }
        return list;
    }

    boolean isOutput(class_2350 direction);

    default void addNeighbor(class_2350 side, TElement from, List<RoutedNode<TSelf, TRoutingInfo>> list, List<TElement> pathSoFar){
        class_2586 fromBE = from.getBlockEntity();
        if (fromBE == null) return;
        class_2586 neighbor = fromBE.method_10997().method_8321(fromBE.method_11016().method_10093(side));
        if (neighbor != null) {
            TSelf self;
            if(getNetwork().getNotableElementClass().isInstance(neighbor) && (self = getNetwork().getNotableElementClass().cast(neighbor)).isActuallyNode()){
                if (pathSoFar.isEmpty()) {
                    return;
                }
                if (self.isOutput(side.method_10153())) return;
                if (!from.connects(side) || !self.connects(side.method_10153())) return;
                TRoutingInfo routingInfo = createRoutingInfo(pathSoFar, side.method_10153());
                list.add(new RoutedNode<>(self, routingInfo));
            } else if (getNetwork().getElementClass().isInstance(neighbor)) {
                TElement to = getNetwork().getElementClass().cast(neighbor);
                boolean fromConnects = from.connects(side);
                boolean toConnects = to.connects(side.method_10153());
                if (fromConnects && toConnects && !pathSoFar.contains(to)){
                    for (class_2350 direction : class_2350.values()) {
                        if (direction != side.method_10153()){
                            addNeighbor(direction, to, list, ImmutableList.<TElement>builder().addAll(pathSoFar).add(to).build());
                        }
                    }
                }
            }
        }
    }

    TRoutingInfo createRoutingInfo(List<TElement> pathSoFar, class_2350 side);
}
