/*
 * Decompiled with CFR 0.152.
 */
package org.gtreimagined.tesseract.api.eu;

import net.minecraft.core.BlockPos;
import net.minecraft.world.level.Level;
import org.gtreimagined.tesseract.api.IConnectable;
import org.gtreimagined.tesseract.api.eu.EUGrid;
import org.gtreimagined.tesseract.api.eu.EUNetwork;
import org.gtreimagined.tesseract.api.eu.EURoutingInfo;
import org.gtreimagined.tesseract.api.eu.EUStatus;
import org.gtreimagined.tesseract.api.eu.IEUEvent;
import org.gtreimagined.tesseract.api.eu.IEUNode;
import org.gtreimagined.tesseract.graph.IElement;
import org.gtreimagined.tesseract.util.Utils;

public interface IEUCable
extends IElement<IEUCable, IEUNode, EURoutingInfo, EUNetwork, EUGrid>,
IConnectable,
IEUEvent {
    public double getLoss();

    public int getAmps();

    public long getVoltage();

    public boolean insulated();

    default public EUStatus getHandler(long voltage, long amperage) {
        if (this.getVoltage() < voltage) {
            return EUStatus.FAIL_VOLTAGE;
        }
        if ((long)this.getAmps() < amperage) {
            return EUStatus.FAIL_AMPERAGE;
        }
        return EUStatus.SUCCESS;
    }

    public long getHolder();

    public void setHolder(long var1);

    @Override
    default public void onNodeOverVoltage(Level w, long pos, long voltage) {
        Utils.createExplosion(w, BlockPos.m_122022_((long)pos), 4.0f, Level.ExplosionInteraction.BLOCK);
    }

    @Override
    default public void onCableOverAmperage(Level w, long pos, long amperage) {
        Utils.createFireAround(w, BlockPos.m_122022_((long)pos));
    }

    @Override
    default public void onCableOverVoltage(Level w, long pos, long voltage) {
        Utils.createFireAround(w, BlockPos.m_122022_((long)pos));
    }
}

