/*
 * Decompiled with CFR 0.152.
 */
package org.gtreimagined.tesseract.api;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.gtreimagined.tesseract.api.IConnectable;
import org.gtreimagined.tesseract.graph.IElement;
import org.gtreimagined.tesseract.graph.IGrid;
import org.gtreimagined.tesseract.graph.INetwork;
import org.gtreimagined.tesseract.graph.INotableElement;
import org.gtreimagined.tesseract.graph.IRoutingInfo;
import org.gtreimagined.tesseract.graph.RoutedNode;

public interface INode<TSelf extends INode<TSelf, TRoutingInfo, TElement, TNetwork, TGrid>, TRoutingInfo extends IRoutingInfo<TRoutingInfo>, TElement extends IElement<TElement, TSelf, TRoutingInfo, TNetwork, TGrid> & IConnectable, TNetwork extends INetwork<TNetwork, TElement, TSelf, TRoutingInfo, TGrid>, TGrid extends IGrid<TGrid, TElement, TSelf, TRoutingInfo, TNetwork>>
extends IElement<TElement, TSelf, TRoutingInfo, TNetwork, TGrid>,
INotableElement<TSelf, TRoutingInfo, TElement, TNetwork, TGrid>,
IConnectable {
    default public List<RoutedNode<TSelf, TRoutingInfo>> getRoutedNeighbours() {
        ArrayList<RoutedNode<TSelf, TRoutingInfo>> list = new ArrayList<RoutedNode<TSelf, TRoutingInfo>>();
        if (!this.isActuallyNode() || this.getNetwork() == null) {
            return list;
        }
        for (Direction direction : Direction.values()) {
            BlockEntity source;
            if (!this.isOutput(direction) || (source = this.getBlockEntity()) == null) continue;
            this.addNeighbor(direction, this, list, List.of());
        }
        return list;
    }

    public boolean isOutput(Direction var1);

    default public void addNeighbor(Direction side, TElement from, List<RoutedNode<TSelf, TRoutingInfo>> list, List<TElement> pathSoFar) {
        BlockEntity fromBE = ((IConnectable)from).getBlockEntity();
        if (fromBE == null) {
            return;
        }
        BlockEntity neighbor = fromBE.m_58904_().m_7702_(fromBE.m_58899_().m_121945_(side));
        if (neighbor != null) {
            INode self;
            if (this.getNetwork().getNotableElementClass().isInstance(neighbor) && (self = (INode)this.getNetwork().getNotableElementClass().cast(neighbor)).isActuallyNode()) {
                if (pathSoFar.isEmpty()) {
                    return;
                }
                if (self.isOutput(side.m_122424_())) {
                    return;
                }
                if (!((IConnectable)from).connects(side) || !self.connects(side.m_122424_())) {
                    return;
                }
                TRoutingInfo routingInfo = this.createRoutingInfo(pathSoFar, side.m_122424_());
                list.add(new RoutedNode((Object)self, routingInfo));
            } else if (this.getNetwork().getElementClass().isInstance(neighbor)) {
                IElement to = (IElement)this.getNetwork().getElementClass().cast(neighbor);
                boolean fromConnects = ((IConnectable)from).connects(side);
                boolean toConnects = ((IConnectable)to).connects(side.m_122424_());
                if (fromConnects && toConnects && !pathSoFar.contains(to)) {
                    for (Direction direction : Direction.values()) {
                        if (direction == side.m_122424_()) continue;
                        this.addNeighbor(direction, (TElement)to, list, (List<TElement>)ImmutableList.builder().addAll(pathSoFar).add((Object)to).build());
                    }
                }
            }
        }
    }

    public TRoutingInfo createRoutingInfo(List<TElement> var1, Direction var2);
}

