/*
 * Decompiled with CFR 0.152.
 */
package org.gtreimagined.gtcore.machine;

import java.util.function.Supplier;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.NoteBlockInstrument;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.MapColor;
import org.gtreimagined.gtcore.blockentity.BlockEntityBookShelf;
import org.gtreimagined.gtcore.data.GTCoreBlocks;
import org.gtreimagined.gtcore.machine.BlockMachineMaterial;
import org.gtreimagined.gtcore.machine.MaterialMachine;
import org.gtreimagined.gtlib.GTAPI;
import org.gtreimagined.gtlib.data.GTTools;
import org.gtreimagined.gtlib.gui.SlotType;
import org.gtreimagined.gtlib.machine.Tier;
import org.gtreimagined.gtlib.machine.types.Machine;
import org.gtreimagined.gtlib.material.Material;
import org.gtreimagined.gtlib.registration.IGTObject;
import org.gtreimagined.gtlib.texture.Texture;
import org.gtreimagined.gtlib.util.Utils;

public class BookShelfMachine
extends MaterialMachine {
    Supplier<Block> woodBlockSupplier;
    String woodType;

    private BookShelfMachine(String domain, String id, Material material) {
        super(domain, id, material);
        this.setTiers(new Tier[]{Tier.NONE});
        this.setTile(BlockEntityBookShelf::new);
        this.addFlags(new String[]{"gui", "item"});
        this.setCustomModel((a, s, d) -> new ResourceLocation("gtcore", "block/machine/overlay/bookshelf/" + d.m_7912_()));
        Texture empty = new Texture("gtcore", "block/machine/empty");
        this.setOverlayTextures((machine, machineState, tier, i) -> new Texture[]{empty, empty, empty, empty, empty, empty});
        for (int y = 0; y < 4; ++y) {
            for (int x = 0; x < 7; ++x) {
                this.add(SlotType.STORAGE, 26 + 18 * x, 8 + 18 * y);
            }
        }
        this.setCustomShape((s, w, p, c) -> ((Direction)s.m_61143_((Property)BlockStateProperties.f_61374_)).m_122434_() == Direction.Axis.Z ? GTCoreBlocks.BOOKSHELF_Z_SHAPE : GTCoreBlocks.BOOKSHELF_X_SHAPE);
        GTAPI.register(BookShelfMachine.class, (IGTObject)this);
    }

    public BookShelfMachine(Material material) {
        this("gtcore", material.getId() + "_bookshelf", material);
        this.setBaseTexture(new Texture("gtcore", "block/machine/base/bookshelf"));
    }

    public BookShelfMachine(String woodType, Texture woodTexture, Supplier<Block> woodBlockSupplier) {
        this("gtcore", woodType + "_bookshelf", Material.NULL);
        this.setToolTag(GTTools.AXE.getToolType());
        this.setBlock((m, t) -> new BlockMachineMaterial((Machine<?>)m, (Tier)t, BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283825_).m_278183_().m_280658_(NoteBlockInstrument.BASS).m_60913_(2.0f, 3.0f).m_60918_(SoundType.f_56736_).m_60999_()));
        this.setBaseTexture(woodTexture);
        this.woodType = woodType;
        this.woodBlockSupplier = woodBlockSupplier;
    }

    public BookShelfMachine(String woodType, String modid, Texture woodTexture, Supplier<Block> woodBlockSupplier) {
        this("gtcore", modid + "/" + woodType + "_bookshelf", Material.NULL);
        this.setToolTag(GTTools.AXE.getToolType());
        this.setBlock((m, t) -> new BlockMachineMaterial((Machine<?>)m, (Tier)t, BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283825_).m_278183_().m_280658_(NoteBlockInstrument.BASS).m_60913_(2.0f, 3.0f).m_60918_(SoundType.f_56736_).m_60999_()));
        this.setBaseTexture(woodTexture);
        this.woodType = woodType;
        this.woodBlockSupplier = woodBlockSupplier;
    }

    @Override
    public String getLang(String lang) {
        return this.woodBlockSupplier != null ? "Wooden Bookshelf (" + Utils.lowerUnderscoreToUpperSpaced((String)this.woodType) + ")" : "Bookshelf (" + this.getMaterial().getDisplayNameString() + ")";
    }

    public Supplier<Block> getWoodBlockSupplier() {
        return this.woodBlockSupplier;
    }
}

