/*
 * Decompiled with CFR 0.152.
 */
package org.gtreimagined.gtcore.loader.crafting;

import com.google.common.collect.ImmutableMap;
import java.util.function.Consumer;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import org.gtreimagined.gtcore.GTCoreConfig;
import org.gtreimagined.gtlib.data.GTMaterialTypes;
import org.gtreimagined.gtlib.data.GTTools;
import org.gtreimagined.gtlib.datagen.builder.GTCookingRecipeBuilder;
import org.gtreimagined.gtlib.datagen.providers.GTRecipeProvider;
import org.gtreimagined.gtlib.material.IMaterialTag;
import org.gtreimagined.gtlib.material.Material;
import org.gtreimagined.gtlib.material.MaterialTags;
import org.gtreimagined.gtlib.material.MaterialType;
import org.gtreimagined.gtlib.material.MaterialTypeBlock;
import org.gtreimagined.gtlib.material.MaterialTypeItem;
import org.gtreimagined.gtlib.recipe.ingredient.RecipeIngredient;

public class MaterialRecipes {
    public static void loadMaterialRecipes(Consumer<FinishedRecipe> consumer, GTRecipeProvider provider) {
        int craftingMultiplier = GTCoreConfig.LOSSY_PART_CRAFTING.get() ? 1 : 2;
        GTMaterialTypes.BLOCK.all().forEach(m -> {
            String[] stringArray;
            int output;
            boolean blockReplacement = GTMaterialTypes.BLOCK.getReplacements().containsKey(m);
            int n = output = m.has(new IMaterialTag[]{MaterialTags.QUARTZ_LIKE_BLOCKS}) ? 4 : 9;
            if (m.has(new IMaterialTag[]{MaterialTags.QUARTZ_LIKE_BLOCKS})) {
                String[] stringArray2 = new String[2];
                stringArray2[0] = "II";
                stringArray = stringArray2;
                stringArray2[1] = "II";
            } else {
                String[] stringArray3 = new String[3];
                stringArray3[0] = "III";
                stringArray3[1] = "III";
                stringArray = stringArray3;
                stringArray3[2] = "III";
            }
            String[] strings = stringArray;
            if (m.has(new IMaterialTag[]{GTMaterialTypes.INGOT})) {
                if (GTCoreConfig.DISABLE_BLOCK_CRAFTING.get()) {
                    return;
                }
                if (GTMaterialTypes.INGOT.getReplacements().containsKey(m) && blockReplacement) {
                    return;
                }
                provider.addStackRecipe(consumer, "gtcore", m.getId() + "_block", "blocks", ((MaterialTypeBlock.IBlockGetter)GTMaterialTypes.BLOCK.get()).get(m).asStack(), ImmutableMap.of((Object)Character.valueOf('I'), (Object)GTMaterialTypes.INGOT.getMaterialTag(m)), strings);
                provider.shapeless(consumer, "gtcore", "ingot_" + m.getId() + "_from_block", "blocks", GTMaterialTypes.INGOT.get(m, output), new Object[]{GTMaterialTypes.BLOCK.getMaterialTag(m)});
            } else if (m.has(new IMaterialTag[]{GTMaterialTypes.GEM})) {
                if (GTMaterialTypes.GEM.getReplacements().containsKey(m) && blockReplacement) {
                    return;
                }
                provider.shapeless(consumer, "gtcore", "gem_" + m.getId() + "_from_block", "blocks", GTMaterialTypes.GEM.get(m, output), new Object[]{GTMaterialTypes.BLOCK.getMaterialTag(m)});
                if (GTCoreConfig.DISABLE_BLOCK_CRAFTING.get()) {
                    return;
                }
                provider.addStackRecipe(consumer, "gtcore", m.getId() + "_block", "blocks", ((MaterialTypeBlock.IBlockGetter)GTMaterialTypes.BLOCK.get()).get(m).asStack(), ImmutableMap.of((Object)Character.valueOf('I'), (Object)GTMaterialTypes.GEM.getMaterialTag(m)), strings);
            }
        });
        if (GTCoreConfig.DISABLE_BLOCK_CRAFTING.get()) {
            provider.removeRecipe(new ResourceLocation("iron_block"));
            provider.removeRecipe(new ResourceLocation("copper_block"));
            provider.removeRecipe(new ResourceLocation("gold_block"));
            provider.removeRecipe(new ResourceLocation("diamond_block"));
            provider.removeRecipe(new ResourceLocation("emerald_block"));
            provider.removeRecipe(new ResourceLocation("netherite_block"));
            provider.removeRecipe(new ResourceLocation("lapis_block"));
            provider.removeRecipe(new ResourceLocation("redstone_block"));
        }
        GTMaterialTypes.ROD.all().forEach(m -> {
            if (m.has(new IMaterialTag[]{GTMaterialTypes.INGOT})) {
                provider.addStackRecipe(consumer, "gtcore", m.getId() + "_rod", "gt_material", GTMaterialTypes.ROD.get(m, craftingMultiplier), ImmutableMap.of((Object)Character.valueOf('F'), (Object)GTTools.FILE.getTag(), (Object)Character.valueOf('I'), (Object)GTMaterialTypes.INGOT.getMaterialTag(m)), new String[]{"F ", " I"});
            }
            if (m.has(new IMaterialTag[]{GTMaterialTypes.BOLT})) {
                provider.addStackRecipe(consumer, "gtcore", m.getId() + "_bolt", "gt_material", GTMaterialTypes.BOLT.get(m, 2 * craftingMultiplier), ImmutableMap.of((Object)Character.valueOf('F'), (Object)GTTools.SAW.getTag(), (Object)Character.valueOf('I'), (Object)GTMaterialTypes.ROD.getMaterialTag(m)), new String[]{"F ", " I"});
                if (m.has(new IMaterialTag[]{GTMaterialTypes.SCREW})) {
                    String[] stringArray;
                    if (GTCoreConfig.LOSSY_PART_CRAFTING.get()) {
                        String[] stringArray2 = new String[2];
                        stringArray2[0] = "FI";
                        stringArray = stringArray2;
                        stringArray2[1] = "I ";
                    } else {
                        String[] stringArray3 = new String[2];
                        stringArray3[0] = "F";
                        stringArray = stringArray3;
                        stringArray3[1] = "I";
                    }
                    String[] pattern = stringArray;
                    provider.addStackRecipe(consumer, "gtcore", m.getId() + "_screw", "gt_material", GTMaterialTypes.SCREW.get(m, 1), ImmutableMap.of((Object)Character.valueOf('F'), (Object)GTTools.FILE.getTag(), (Object)Character.valueOf('I'), (Object)GTMaterialTypes.BOLT.getMaterialTag(m)), pattern);
                }
            }
            if (m.has(new IMaterialTag[]{GTMaterialTypes.RING}) && !m.has(new IMaterialTag[]{MaterialTags.NOSMASH})) {
                provider.addStackRecipe(consumer, "gtcore", m.getId() + "_ring", "gt_material", GTMaterialTypes.RING.get(m, craftingMultiplier), ImmutableMap.of((Object)Character.valueOf('H'), (Object)GTTools.HAMMER.getTag(), (Object)Character.valueOf('W'), (Object)GTMaterialTypes.ROD.getMaterialTag(m)), new String[]{"H ", " W"});
            }
            if (m.has(new IMaterialTag[]{GTMaterialTypes.LONG_ROD})) {
                provider.addStackRecipe(consumer, "gtcore", m.getId() + "_rod_from_long_rod", "rods", GTMaterialTypes.ROD.get(m, 2), ImmutableMap.of((Object)Character.valueOf('S'), (Object)GTTools.SAW.getTag(), (Object)Character.valueOf('R'), (Object)GTMaterialTypes.LONG_ROD.getMaterialTag(m)), new String[]{"SR"});
                if (!m.has(new IMaterialTag[]{MaterialTags.NOSMASH})) {
                    provider.addStackRecipe(consumer, "gtcore", m.getId() + "_long_rod", "rods", GTMaterialTypes.LONG_ROD.get(m, 1), ImmutableMap.of((Object)Character.valueOf('S'), (Object)GTTools.HAMMER.getTag(), (Object)Character.valueOf('R'), (Object)GTMaterialTypes.ROD.getMaterialTag(m)), new String[]{"RSR"});
                }
            }
        });
        GTMaterialTypes.ROTOR.all().forEach(m -> provider.addStackRecipe(consumer, "gtcore", m.getId() + "_rotor", "gt_material", GTMaterialTypes.ROTOR.get(m, 1), ImmutableMap.builder().put((Object)Character.valueOf('S'), (Object)GTTools.SCREWDRIVER.getTag()).put((Object)Character.valueOf('F'), (Object)GTTools.FILE.getTag()).put((Object)Character.valueOf('H'), (Object)GTTools.HAMMER.getTag()).put((Object)Character.valueOf('P'), (Object)GTMaterialTypes.PLATE.getMaterialTag(m)).put((Object)Character.valueOf('W'), (Object)GTMaterialTypes.SCREW.getMaterialTag(m)).put((Object)Character.valueOf('R'), (Object)GTMaterialTypes.RING.getMaterialTag(m)).build(), new String[]{"PHP", "WRF", "PSP"}));
        GTMaterialTypes.PLATE.all().forEach(m -> {
            if (!m.has(new IMaterialTag[]{MaterialTags.NOSMASH})) {
                if (m.has(new IMaterialTag[]{GTMaterialTypes.INGOT})) {
                    String[] stringArray;
                    if (GTCoreConfig.LOSSY_PART_CRAFTING.get()) {
                        String[] stringArray2 = new String[3];
                        stringArray2[0] = "H";
                        stringArray2[1] = "I";
                        stringArray = stringArray2;
                        stringArray2[2] = "I";
                    } else {
                        String[] stringArray3 = new String[2];
                        stringArray3[0] = "H";
                        stringArray = stringArray3;
                        stringArray3[1] = "I";
                    }
                    String[] array = stringArray;
                    provider.addItemRecipe(consumer, "gtcore", m.getId() + "_plate", "gt_material", (ItemLike)GTMaterialTypes.PLATE.get(m), ImmutableMap.of((Object)Character.valueOf('H'), (Object)GTTools.HAMMER.getTag(), (Object)Character.valueOf('I'), (Object)GTMaterialTypes.INGOT.getMaterialTag(m)), array);
                }
                if (m.has(new IMaterialTag[]{GTMaterialTypes.SMALL_GEAR})) {
                    provider.addStackRecipe(consumer, "gtcore", m.getId() + "_small_gear", "gt_material", GTMaterialTypes.SMALL_GEAR.get(m, 1), ImmutableMap.of((Object)Character.valueOf('H'), (Object)GTTools.HAMMER.getTag(), (Object)Character.valueOf('P'), (Object)GTMaterialTypes.PLATE.getMaterialTag(m)), new String[]{"P ", " H"});
                }
                if (m.has(new IMaterialTag[]{GTMaterialTypes.ITEM_CASING})) {
                    provider.addStackRecipe(consumer, "gtcore", m.getId() + "_item_casing", "gt_material", GTMaterialTypes.ITEM_CASING.get(m, 1), ImmutableMap.of((Object)Character.valueOf('H'), (Object)GTTools.HAMMER.getTag(), (Object)Character.valueOf('P'), (Object)GTMaterialTypes.PLATE.getMaterialTag(m)), new String[]{"H P"});
                }
                if (m.has(new IMaterialTag[]{GTMaterialTypes.FOIL})) {
                    provider.addStackRecipe(consumer, "gtcore", m.getId() + "_foil", "gt_materials", GTMaterialTypes.FOIL.get(m, 2), ImmutableMap.of((Object)Character.valueOf('H'), (Object)GTTools.HAMMER.getTag(), (Object)Character.valueOf('P'), (Object)GTMaterialTypes.PLATE.getMaterialTag(m)), new String[]{"HP"});
                    if (m.has(new IMaterialTag[]{GTMaterialTypes.FINE_WIRE})) {
                        provider.addItemRecipe(consumer, "gtcore", m.getId() + "_fine_wire", "gt_materials", (ItemLike)GTMaterialTypes.FINE_WIRE.get(m), ImmutableMap.of((Object)Character.valueOf('F'), (Object)GTMaterialTypes.FOIL.getMaterialTag(m), (Object)Character.valueOf('W'), (Object)GTTools.WIRE_CUTTER.getTag()), new String[]{"FW"});
                    }
                }
            }
            if (m.has(new IMaterialTag[]{GTMaterialTypes.GEAR})) {
                provider.addStackRecipe(consumer, "gtcore", m.getId() + "_gear", "gt_material", GTMaterialTypes.GEAR.get(m, 1), ImmutableMap.builder().put((Object)Character.valueOf('W'), (Object)GTTools.WRENCH.getTag()).put((Object)Character.valueOf('P'), (Object)GTMaterialTypes.PLATE.getMaterialTag(m)).put((Object)Character.valueOf('R'), (Object)GTMaterialTypes.ROD.getMaterialTag(m)).build(), new String[]{"RPR", "PWP", "RPR"});
            }
            if (m.has(new IMaterialTag[]{GTMaterialTypes.RING}) && m.has(new IMaterialTag[]{MaterialTags.RUBBERTOOLS})) {
                provider.addStackRecipe(consumer, "gtcore", m.getId() + "_ring", "gt_material", GTMaterialTypes.RING.get(m, craftingMultiplier), ImmutableMap.of((Object)Character.valueOf('H'), (Object)GTTools.WIRE_CUTTER.getTag(), (Object)Character.valueOf('W'), (Object)GTMaterialTypes.PLATE.getMaterialTag(m)), new String[]{"H ", " W"});
            }
        });
    }

    public static void addSmeltingRecipe(Consumer<FinishedRecipe> consumer, GTRecipeProvider provider, MaterialType<?> input, MaterialTypeItem<?> output, int amount, Material in) {
        MaterialRecipes.addSmeltingRecipe(consumer, provider, input, output, amount, in, in);
    }

    public static void addSmeltingRecipe(Consumer<FinishedRecipe> consumer, GTRecipeProvider provider, MaterialType<?> input, MaterialTypeItem<?> output, int amount, Material in, Material out) {
        GTCookingRecipeBuilder.blastingRecipe((Ingredient)RecipeIngredient.of((TagKey)input.getMaterialTag(in), (int)1), (ItemStack)new ItemStack((ItemLike)output.get(out), MaterialTags.SMELTING_MULTI.getInt(in) * amount), (float)2.0f, (int)100).addCriterion("has_material_" + in.getId(), provider.hasSafeItem(output.getMaterialTag(out))).build(consumer, provider.fixLoc("gtlib", in.getId().concat("_" + input.getId() + "_to_" + output.getId())));
        GTCookingRecipeBuilder.smeltingRecipe((Ingredient)RecipeIngredient.of((TagKey)input.getMaterialTag(in), (int)1), (ItemStack)new ItemStack((ItemLike)output.get(out), MaterialTags.SMELTING_MULTI.getInt(in) * amount), (float)2.0f, (int)200).addCriterion("has_material_" + in.getId(), provider.hasSafeItem(output.getMaterialTag(out))).build(consumer, provider.fixLoc("gtlib", in.getId().concat("_" + input.getId() + "_to_" + output.getId() + "_smelting")));
    }
}

