/*
 * Decompiled with CFR 0.152.
 */
package org.gtreimagined.gtcore.blockentity;

import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.fluids.FluidStack;
import org.gtreimagined.gtcore.data.GTCoreTags;
import org.gtreimagined.gtcore.machine.SteamMachine;
import org.gtreimagined.gtlib.blockentity.BlockEntityMachine;
import org.gtreimagined.gtlib.capability.machine.MachineFluidHandler;
import org.gtreimagined.gtlib.capability.machine.MachineRecipeHandler;
import org.gtreimagined.gtlib.machine.MachineState;
import org.gtreimagined.gtlib.machine.Tier;
import org.gtreimagined.gtlib.machine.types.Machine;
import org.gtreimagined.gtlib.recipe.IRecipe;

public class BlockEntitySteamMachine
extends BlockEntityMachine<BlockEntitySteamMachine> {
    SteamMachine machine;

    public BlockEntitySteamMachine(Machine<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
        this.fluidHandler.set(() -> new MachineFluidHandler((BlockEntityMachine)this, 64000));
        this.recipeHandler.set(() -> new SteamMachineRecipeHandler(this));
        if (type instanceof SteamMachine) {
            SteamMachine machine;
            this.machine = machine = (SteamMachine)type;
        }
    }

    public Tier getPowerLevel() {
        return Tier.LV;
    }

    public static class SteamMachineRecipeHandler
    extends MachineRecipeHandler<BlockEntitySteamMachine> {
        protected boolean isSteamClear = false;
        protected boolean firstBlockedRun = false;

        public SteamMachineRecipeHandler(BlockEntitySteamMachine tile) {
            super((BlockEntityMachine)tile);
        }

        public boolean consumePower(boolean simulate) {
            return ((BlockEntitySteamMachine)this.tile).fluidHandler.map(t -> t.consumeTaggedInput(GTCoreTags.STEAM, (int)this.getPower(), simulate).getAmount() > 0).orElse(false);
        }

        protected boolean validateRecipe(IRecipe r) {
            return r.getPower() * (long)((BlockEntitySteamMachine)this.tile).machine.getEuMultiplier() <= Tier.LV.getVoltage();
        }

        public void setSteamClear(boolean steamClear) {
            this.isSteamClear = steamClear;
            if (steamClear) {
                this.firstBlockedRun = false;
                this.checkRecipe();
            }
        }

        protected boolean canRecipeContinue() {
            this.isSteamClear = ((BlockEntitySteamMachine)this.tile).f_58857_.m_46859_(((BlockEntitySteamMachine)this.tile).f_58858_.m_121945_(((BlockEntitySteamMachine)this.tile).getOutputFacing()));
            return super.canRecipeContinue() && (this.isSteamClear || !this.firstBlockedRun);
        }

        protected MachineState recipeFinish() {
            if (!this.firstBlockedRun) {
                this.firstBlockedRun = true;
            }
            return super.recipeFinish();
        }

        public long getPower() {
            if (this.activeRecipe == null) {
                return 0L;
            }
            return this.activeRecipe.getPower() * (long)(((BlockEntitySteamMachine)this.tile).getMachineTier() == Tier.BRONZE ? 1 : 2) * (long)((BlockEntitySteamMachine)this.tile).machine.getEuMultiplier();
        }

        protected void calculateDurations() {
            super.calculateDurations();
            this.maxProgress = this.activeRecipe.getDuration() * (((BlockEntitySteamMachine)this.tile).getMachineTier() == Tier.BRONZE ? 2 : 1) * ((BlockEntitySteamMachine)this.tile).machine.getDurationMultiplier();
        }

        public float getClientProgress() {
            if (((BlockEntitySteamMachine)this.tile).getMachineType().getId().contains("forge_hammer")) {
                float percent = (float)this.currentProgress / ((float)this.maxProgress / 3.0f);
                if (percent > 2.0f) {
                    percent -= 2.0f;
                } else if (percent > 1.0f) {
                    percent -= 1.0f;
                }
                return percent;
            }
            return super.getClientProgress();
        }

        public boolean accepts(FluidStack stack) {
            return super.accepts(stack) || stack.getFluid().m_205069_().m_203656_(GTCoreTags.STEAM);
        }

        public CompoundTag serialize() {
            CompoundTag tag = super.serialize();
            tag.m_128379_("firstBlockedRun", this.firstBlockedRun);
            return tag;
        }

        public void deserialize(CompoundTag nbt) {
            super.deserialize(nbt);
            this.firstBlockedRun = nbt.m_128471_("firstBlockedRun");
        }
    }
}

