/*
 * Decompiled with CFR 0.152.
 */
package org.gtreimagined.gtcore.block;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.gtreimagined.gtcore.blockentity.BlockEntitySapBag;
import org.gtreimagined.gtcore.client.BakedModels;
import org.gtreimagined.gtcore.data.GTCoreBlocks;
import org.gtreimagined.gtlib.datagen.builder.DynamicConfigBuilder;
import org.gtreimagined.gtlib.datagen.builder.GTBlockModelBuilder;
import org.gtreimagined.gtlib.datagen.builder.GTItemModelBuilder;
import org.gtreimagined.gtlib.datagen.builder.IModelLocation;
import org.gtreimagined.gtlib.datagen.builder.VariantBlockStateBuilder;
import org.gtreimagined.gtlib.datagen.providers.GTBlockStateProvider;
import org.gtreimagined.gtlib.datagen.providers.GTItemModelProvider;
import org.gtreimagined.gtlib.dynamic.BlockDynamic;
import org.gtreimagined.gtlib.dynamic.ModelConfig;
import org.gtreimagined.gtlib.texture.Texture;
import org.jetbrains.annotations.Nullable;

public class BlockSapBag
extends BlockDynamic
implements SimpleWaterloggedBlock,
EntityBlock {
    protected ModelConfig config = new ModelConfig();
    final VoxelShape[] SHAPES = this.setBlockBounds2();
    final Texture[] TEXTURES = new Texture[]{new Texture("gtcore", "block/sapbag/bottom"), new Texture("gtcore", "block/sapbag/top"), new Texture("gtcore", "block/sapbag/side"), new Texture("gtcore", "block/sapbag/top_filled")};

    public BlockSapBag() {
        super("gtcore", "sap_bag", BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283798_).m_60955_().m_60978_(0.5f).m_60918_(SoundType.f_56745_));
    }

    private VoxelShape[] setBlockBounds2() {
        AABB north = new AABB(0.3125, 0.0, 0.0, 0.6875, 0.4375, 0.375);
        AABB south = new AABB(0.3125, 0.0, 0.625, 0.6875, 0.4375, 1.0);
        AABB west = new AABB(0.0, 0.0, 0.3125, 0.375, 0.4375, 0.6875);
        AABB east = new AABB(0.625, 0.0, 0.3125, 1.0, 0.4375, 0.6875);
        return new VoxelShape[]{Shapes.m_83064_((AABB)south), Shapes.m_83064_((AABB)west), Shapes.m_83064_((AABB)north), Shapes.m_83064_((AABB)east)};
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return this.SHAPES[((Direction)state.m_61143_((Property)BlockStateProperties.f_61374_)).m_122416_()];
    }

    public ModelConfig getConfig(BlockState state, BlockGetter world, BlockPos.MutableBlockPos mut, BlockPos pos) {
        BlockEntitySapBag tile = (BlockEntitySapBag)world.m_7702_(pos);
        int filled = tile != null ? (tile.getSap().m_41619_() || tile.getSap().m_41613_() == 0 ? 0 : (tile.getSap().m_41613_() < 11 ? 1 : (tile.getSap().m_41613_() < 21 ? 2 : (tile.getSap().m_41613_() < 31 ? 3 : (tile.getSap().m_41613_() < 41 ? 4 : (tile.getSap().m_41613_() < 51 ? 5 : 6)))))) : 0;
        return this.config.set(pos, new int[]{this.getModelId((Direction)state.m_61143_((Property)BlockStateProperties.f_61374_), filled)});
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{BlockStateProperties.f_61374_, BlockStateProperties.f_61362_});
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        FluidState fluidstate = context.m_43725_().m_6425_(context.m_8083_());
        return (BlockState)((BlockState)this.m_49966_().m_61124_((Property)BlockStateProperties.f_61374_, (Comparable)context.m_8125_())).m_61124_((Property)BlockStateProperties.f_61362_, (Comparable)Boolean.valueOf(fluidstate.m_76152_() == Fluids.f_76193_));
    }

    public void m_6402_(Level world, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        if (placer != null) {
            Direction dir = Direction.m_122372_((float)((float)placer.m_20154_().f_82479_), (float)0.0f, (float)((float)placer.m_20154_().f_82481_));
            world.m_46597_(pos, (BlockState)state.m_61124_((Property)BlockStateProperties.f_61374_, (Comparable)dir));
            BlockEntity tile = world.m_7702_(pos);
            if (tile instanceof BlockEntitySapBag) {
                BlockEntitySapBag sapBag = (BlockEntitySapBag)tile;
                sapBag.setFacing(dir);
                sapBag.checkRubber();
            }
        }
    }

    public void m_6861_(BlockState state, Level worldIn, BlockPos pos, Block blockIn, BlockPos fromPos, boolean isMoving) {
        super.m_6861_(state, worldIn, pos, blockIn, fromPos, isMoving);
        BlockEntity tile = worldIn.m_7702_(pos);
        if (tile instanceof BlockEntitySapBag) {
            ((BlockEntitySapBag)tile).onBlockUpdate();
        }
    }

    public InteractionResult m_6227_(BlockState state, Level worldIn, BlockPos pos, Player player, InteractionHand handIn, BlockHitResult hit) {
        BlockEntitySapBag sapBag;
        BlockEntity tile = worldIn.m_7702_(pos);
        if (tile instanceof BlockEntitySapBag && !(sapBag = (BlockEntitySapBag)tile).getSap().m_41619_()) {
            if (!player.m_36356_(sapBag.getSap().m_41777_())) {
                player.m_36176_(sapBag.getSap().m_41777_(), false);
            }
            sapBag.setSap(ItemStack.f_41583_);
            sapBag.checkRubber();
            return InteractionResult.SUCCESS;
        }
        return super.m_6227_(state, worldIn, pos, player, handIn, hit);
    }

    public List<ItemStack> m_49635_(BlockState state, LootParams.Builder builder) {
        ItemStack stack;
        List list = super.m_49635_(state, builder);
        BlockEntity tileentity = (BlockEntity)builder.m_287159_(LootContextParams.f_81462_);
        if (tileentity instanceof BlockEntitySapBag && !(stack = ((BlockEntitySapBag)tileentity).getSap()).m_41619_()) {
            list.add(stack);
        }
        return list;
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pPos, BlockState pState) {
        return GTCoreBlocks.SAP_BAG_BLOCK_ENTITY.m_155264_(pPos, pState);
    }

    public void onItemModelBuild(ItemLike item, GTItemModelProvider prov) {
        ((GTItemModelBuilder)((GTItemModelBuilder)((GTItemModelBuilder)prov.getBuilder(item).parent(prov.existing("gtcore", "block/sapbag/north"))).texture("side", (ResourceLocation)this.TEXTURES[2])).texture("bottom", (ResourceLocation)this.TEXTURES[0])).texture("top", (ResourceLocation)this.TEXTURES[1]);
    }

    public void onBlockModelBuild(Block block, GTBlockStateProvider prov) {
        prov.getVariantBuilder(block).forAllStates(s -> new VariantBlockStateBuilder.VariantBuilder().modelFile((IModelLocation)this.buildModelsForState(prov.getBuilder(block), (BlockState)s)).uvLock());
    }

    private int getModelId(Direction facing, int filled) {
        return facing.m_122416_() + filled * 10;
    }

    GTBlockModelBuilder buildModelsForState(GTBlockModelBuilder builder, BlockState state) {
        builder.staticConfigId("sap_bag");
        Direction f = (Direction)state.m_61143_((Property)BlockStateProperties.f_61374_);
        boolean waterlogged = (Boolean)state.m_61143_((Property)BlockStateProperties.f_61362_);
        if (!waterlogged) {
            for (int i = 0; i < 7; ++i) {
                Object addition = i == 0 ? "" : "_filled_" + i;
                int finalI = i;
                builder.config(this.getModelId(f, i), (arg_0, arg_1) -> this.lambda$buildModelsForState$1(f, (String)addition, finalI, arg_0, arg_1));
            }
        }
        builder.property("particle", this.TEXTURES[2].toString());
        return (GTBlockModelBuilder)builder.loader(BakedModels.LOADER_SAP_BAG);
    }

    public FluidState m_5888_(BlockState state) {
        return (Boolean)state.m_61143_((Property)BlockStateProperties.f_61362_) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(state);
    }

    private /* synthetic */ ImmutableList.Builder lambda$buildModelsForState$1(Direction f, String addition, int finalI, DynamicConfigBuilder b, ImmutableList.Builder l) {
        DynamicConfigBuilder build = b.of(new ResourceLocation(this.domain, "block/sapbag/" + f.m_7912_() + addition)).tex(ImmutableMap.of((Object)"side", (Object)this.TEXTURES[2], (Object)"bottom", (Object)this.TEXTURES[0], (Object)"top", (Object)this.TEXTURES[1]));
        if (finalI != 0) {
            build.tex(ImmutableMap.of((Object)"side", (Object)this.TEXTURES[2], (Object)"bottom", (Object)this.TEXTURES[0], (Object)"top", (Object)this.TEXTURES[1], (Object)"topfilled", (Object)this.TEXTURES[3]));
        }
        return l.add((Object)build);
    }
}

