/*
 * Decompiled with CFR 0.152.
 */
package org.gtreimagined.gtcore.block;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.fluids.FluidStack;
import org.gtreimagined.gtcore.data.GTCoreRecipeMaps;
import org.gtreimagined.gtlib.block.BlockBasic;
import org.gtreimagined.gtlib.datagen.builder.GTItemModelBuilder;
import org.gtreimagined.gtlib.datagen.providers.GTBlockStateProvider;
import org.gtreimagined.gtlib.datagen.providers.GTItemModelProvider;
import org.gtreimagined.gtlib.integration.xei.GTLibXEIPlugin;
import org.gtreimagined.gtlib.machine.Tier;
import org.gtreimagined.gtlib.material.Material;
import org.gtreimagined.gtlib.recipe.IRecipe;
import org.gtreimagined.gtlib.registration.IColorHandler;
import org.jetbrains.annotations.Nullable;

public class BlockMortar
extends BlockBasic
implements IColorHandler {
    final Material material;
    static final int CERAMIC_COLOR = 14451270;
    static final VoxelShape BOTTOM_SHAPE = Shapes.m_83048_((double)0.125, (double)0.0, (double)0.125, (double)0.875, (double)0.0625, (double)0.875);
    static final VoxelShape NORTH_SHAPE = Shapes.m_83048_((double)0.25, (double)0.0, (double)0.125, (double)0.75, (double)0.375, (double)0.25);
    static final VoxelShape SOUTH_SHAPE = Shapes.m_83048_((double)0.25, (double)0.0, (double)0.75, (double)0.75, (double)0.375, (double)0.875);
    static final VoxelShape EAST_SHAPE = Shapes.m_83048_((double)0.75, (double)0.0, (double)0.125, (double)0.875, (double)0.375, (double)0.875);
    static final VoxelShape WEST_SHAPE = Shapes.m_83048_((double)0.125, (double)0.0, (double)0.125, (double)0.25, (double)0.375, (double)0.875);
    static final VoxelShape BASE_SHAPE = Shapes.m_83124_((VoxelShape)BOTTOM_SHAPE, (VoxelShape[])new VoxelShape[]{NORTH_SHAPE, SOUTH_SHAPE, EAST_SHAPE, WEST_SHAPE});
    static final VoxelShape CENTER_SHAPE = Shapes.m_83048_((double)0.375, (double)0.0625, (double)0.375, (double)0.625, (double)0.5625, (double)0.625);
    static final VoxelShape FULL_SHAPE = Shapes.m_83110_((VoxelShape)BASE_SHAPE, (VoxelShape)CENTER_SHAPE);

    public BlockMortar(Material material) {
        super("gtcore", material.getId() + "_mortar", BlockBehaviour.Properties.m_284310_().m_60955_().m_60978_(1.0f).m_60999_().m_60918_(SoundType.f_56742_).m_284180_(MapColor.f_283774_));
        this.material = material;
    }

    public int getBlockColor(BlockState state, @Nullable BlockGetter world, @Nullable BlockPos pos, int i) {
        return i == 0 ? 14451270 : (i == 1 ? this.material.getRGB() : (i == 2 ? 0xFFFF00 : -1));
    }

    public int getItemColor(ItemStack stack, @Nullable Block block, int i) {
        return i == 0 ? 14451270 : (i == 1 ? this.material.getRGB() : (i == 2 ? 0xFFFF00 : -1));
    }

    public void onBlockModelBuild(Block block, GTBlockStateProvider prov) {
        prov.simpleBlock(block, () -> prov.existing("gtcore", "block/mortar"));
    }

    public void onItemModelBuild(ItemLike item, GTItemModelProvider prov) {
        ((GTItemModelBuilder)prov.getBuilder(item).parent(prov.existing("gtcore", "block/mortar"))).build();
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return FULL_SHAPE;
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        Vec3 location = hit.m_82450_();
        double x = location.m_7096_() - (double)pos.m_123341_();
        double z = location.m_7094_() - (double)pos.m_123343_();
        if (hit.m_82434_() == Direction.UP && x > 0.125 && x < 0.25 && z > 0.125 && z < 0.25) {
            if (level.m_5776_()) {
                GTLibXEIPlugin.showCategories((ResourceLocation[])new ResourceLocation[]{GTCoreRecipeMaps.MORTAR.getLoc()});
            }
            return InteractionResult.m_19078_((boolean)level.m_5776_());
        }
        ItemStack stack = player.m_21120_(hand);
        IRecipe recipe = GTCoreRecipeMaps.MORTAR.find(new ItemStack[]{stack}, new FluidStack[0], Tier.NONE, r -> true);
        if (recipe != null) {
            if (!level.m_5776_()) {
                for (ItemStack outputItem : recipe.getOutputItems()) {
                    if (player.m_36356_(outputItem.m_41777_())) continue;
                    player.m_36176_(outputItem.m_41777_(), false);
                }
                stack.m_41774_(((Ingredient)recipe.getInputItems().get(0)).m_43908_()[0].m_41613_());
                level.m_5594_(null, pos, SoundEvents.f_12447_, SoundSource.BLOCKS, 1.0f, 1.0f);
            }
            return InteractionResult.m_19078_((boolean)level.m_5776_());
        }
        return super.m_6227_(state, level, pos, player, hand, hit);
    }
}

