/*
 * Decompiled with CFR 0.152.
 */
package org.gtreimagined.gtcore.tree;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BiomeTags;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.level.LevelSimulatedReader;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeSpecialEffects;
import net.minecraft.world.level.biome.Biomes;
import net.minecraft.world.level.biome.MobSpawnSettings;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.TreeFeature;
import net.minecraft.world.level.levelgen.feature.configurations.TreeConfiguration;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraftforge.common.world.BiomeGenerationSettingsBuilder;
import net.minecraftforge.common.world.BiomeModifier;
import org.gtreimagined.gtcore.tree.RubberTreeWorldGen;
import org.gtreimagined.gtlib.GTAPI;
import org.gtreimagined.gtlib.util.TagUtils;
import org.gtreimagined.gtlib.worldgen.feature.IGTFeature;

public class RubberTreeFeature
extends TreeFeature
implements IGTFeature {
    public RubberTreeFeature() {
        super(TreeConfiguration.f_68184_);
    }

    public String getId() {
        return "rubber_tree";
    }

    public Feature<?> asFeature() {
        return this;
    }

    public void build(BiomeModifier.Phase phase, Holder<Biome> biomeHolder, Biome.ClimateSettings climate, BiomeSpecialEffects effects, BiomeGenerationSettingsBuilder gen, MobSpawnSettings.Builder spawns, Registry<PlacedFeature> registry) {
        if (GTAPI.isModLoaded((String)"tfc") || phase != BiomeModifier.Phase.ADD) {
            return;
        }
        if (biomeHolder.m_203565_(Biomes.f_48207_) || biomeHolder.m_203565_(Biomes.f_220595_)) {
            gen.m_255419_(GenerationStep.Decoration.VEGETAL_DECORATION, this.getPlacedFeatureFromKey(registry, RubberTreeWorldGen.TREE_SWAMP));
        } else if (biomeHolder.m_203656_(BiomeTags.f_207610_)) {
            gen.m_255419_(GenerationStep.Decoration.VEGETAL_DECORATION, this.getPlacedFeatureFromKey(registry, RubberTreeWorldGen.TREE_JUNGLE));
        } else {
            gen.m_255419_(GenerationStep.Decoration.VEGETAL_DECORATION, this.getPlacedFeatureFromKey(registry, RubberTreeWorldGen.TREE));
        }
    }

    protected Holder<PlacedFeature> getPlacedFeatureFromKey(Registry<PlacedFeature> registry, ResourceKey<PlacedFeature> key) {
        PlacedFeature placedFeature = (PlacedFeature)registry.m_6246_(key);
        if (placedFeature == null) {
            return null;
        }
        return Holder.m_205709_((Object)placedFeature);
    }

    public int m_67215_(LevelSimulatedReader level, int trunkHeight, BlockPos topPosition, TreeConfiguration config) {
        boolean treeGrows;
        boolean isFluid = level.m_142433_(topPosition.m_7494_(), state -> state.m_205070_(FluidTags.f_13131_));
        if (isFluid) {
            return 0;
        }
        boolean bl = treeGrows = !GTAPI.isModLoaded((String)"tfc") || level.m_7433_(topPosition.m_7495_(), state -> state.m_204336_(TagUtils.getBlockTag((ResourceLocation)new ResourceLocation("tfc", "tree_grows_on"))));
        if (!treeGrows) {
            return 0;
        }
        return super.m_67215_(level, trunkHeight, topPosition, config);
    }
}

