/*
 * Decompiled with CFR 0.152.
 */
package org.gtreimagined.gtcore.machine;

import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.world.item.ItemStack;
import org.gtreimagined.gtcore.blockentity.BlockEntityMassStorage;
import org.gtreimagined.gtcore.item.ItemBlockMassStorage;
import org.gtreimagined.gtcore.machine.MaterialMachine;
import org.gtreimagined.gtlib.GTAPI;
import org.gtreimagined.gtlib.machine.MachineState;
import org.gtreimagined.gtlib.machine.Tier;
import org.gtreimagined.gtlib.material.IMaterialTag;
import org.gtreimagined.gtlib.material.Material;
import org.gtreimagined.gtlib.material.MaterialTags;
import org.gtreimagined.gtlib.registration.IGTObject;
import org.gtreimagined.gtlib.texture.Texture;
import org.gtreimagined.gtlib.util.Utils;

public class MassStorageMachine
extends MaterialMachine {
    final int capacity;

    public MassStorageMachine(String domain, Material material, String suffix, int capacity) {
        super(domain, material.getId() + "_" + suffix, material);
        this.setTiers(new Tier[]{Tier.NONE});
        this.setTile((m, p, s) -> new BlockEntityMassStorage(this, p, s));
        this.setItemBlock(ItemBlockMassStorage::new);
        this.addTooltipInfo((machine, stack, world, tooltip, flag) -> {
            tooltip.add(Utils.translatable((String)"machine.mass_storage.capacity", (Object[])new Object[]{capacity}));
            CompoundTag nbt = stack.m_41783_();
            if (nbt != null) {
                if (nbt.m_128441_("inventories")) {
                    ItemStack contained;
                    CompoundTag item;
                    ListTag items;
                    CompoundTag unlimited;
                    CompoundTag inventories = nbt.m_128469_("inventories");
                    if (inventories.m_128441_("unlimited")) {
                        unlimited = inventories.m_128469_("unlimited");
                        items = unlimited.m_128437_("Items", 10);
                        item = items.m_128728_(0);
                        contained = ItemStack.m_41712_((CompoundTag)item);
                        contained.m_41764_(item.m_128451_("count"));
                        tooltip.add(Utils.translatable((String)"machine.mass_storage.contains", (Object[])new Object[]{item.m_128451_("count"), contained.m_41786_()}));
                    }
                    if (inventories.m_128441_("display")) {
                        unlimited = inventories.m_128469_("display");
                        items = unlimited.m_128437_("Items", 10);
                        item = items.m_128728_(0);
                        contained = ItemStack.m_41712_((CompoundTag)item);
                        tooltip.add(Utils.translatable((String)"machine.mass_storage.display", (Object[])new Object[]{contained.m_41786_()}));
                    }
                }
                if (nbt.m_128441_("output")) {
                    tooltip.add(Utils.translatable((String)"machine.mass_storage.output", (Object[])new Object[0]));
                }
                if (nbt.m_128441_("outputOverflow")) {
                    tooltip.add(Utils.translatable((String)"machine.mass_storage.output_overflow", (Object[])new Object[0]));
                }
            }
        });
        this.capacity = capacity;
        this.setRenderAsTesr();
        this.setClientTicking();
        String barrel = material.has(new IMaterialTag[]{MaterialTags.WOOD}) ? "item_storage" : (material.has(new IMaterialTag[]{MaterialTags.RUBBERTOOLS}) ? "plastic_storage" : "mass_storage");
        this.setBaseTexture((m, t, s) -> new Texture[]{new Texture("gtcore", "block/machine/base/" + barrel + "/bottom"), new Texture("gtcore", "block/machine/base/" + barrel + "/top"), new Texture("gtcore", "block/machine/base/" + barrel + "/side"), new Texture("gtcore", "block/machine/base/" + barrel + "/side"), new Texture("gtcore", "block/machine/base/" + barrel + "/side"), new Texture("gtcore", "block/machine/base/" + barrel + "/side")});
        this.setOverlayTextures((m, s, t, i) -> {
            String stateDir = (s = s.getTextureState()) == MachineState.IDLE ? "" : s.getId() + "/";
            return new Texture[]{new Texture(domain, "block/machine/overlay/" + barrel + "/" + stateDir + "bottom"), new Texture(domain, "block/machine/overlay/" + barrel + "/" + stateDir + "top"), new Texture(domain, "block/machine/overlay/" + barrel + "/" + stateDir + "back"), new Texture(domain, "block/machine/overlay/" + barrel + "/" + stateDir + "front"), new Texture(domain, "block/machine/overlay/" + barrel + "/" + stateDir + "side"), new Texture(domain, "block/machine/overlay/" + barrel + "/" + stateDir + "side")};
        });
        GTAPI.register(MassStorageMachine.class, (IGTObject)this);
    }

    public int getCapacity() {
        return this.capacity;
    }
}

