/*
 * Decompiled with CFR 0.152.
 */
package org.gtreimagined.gtcore.cover;

import java.util.concurrent.ExecutionException;
import java.util.function.BiConsumer;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.gtreimagined.gtcore.blockentity.BlockEntityRedstoneWire;
import org.gtreimagined.gtcore.data.GTCoreCables;
import org.gtreimagined.gtlib.capability.ICoverHandler;
import org.gtreimagined.gtlib.cover.BaseCover;
import org.gtreimagined.gtlib.cover.CoverFactory;
import org.gtreimagined.gtlib.machine.Tier;
import org.gtreimagined.gtlib.pipe.BlockPipe;
import org.gtreimagined.gtlib.pipe.PipeSize;
import org.gtreimagined.gtlib.texture.Texture;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CoverRepeater
extends BaseCover {
    public CoverRepeater(@NotNull ICoverHandler<?> source, @Nullable Tier tier, Direction side, CoverFactory factory) {
        super(source, tier, side, factory);
    }

    public boolean canPlace() {
        return this.source().getTile() instanceof BlockEntityRedstoneWire;
    }

    public void onPlace() {
        BlockEntityRedstoneWire wire = (BlockEntityRedstoneWire)this.source().getTile();
        wire.clearConnection(this.side);
    }

    public boolean blockConnection(Direction side) {
        return true;
    }

    public int getStrongPower() {
        BlockEntityRedstoneWire wire = (BlockEntityRedstoneWire)this.source().getTile();
        return wire.getRedstoneValue() > 0L ? 15 : 0;
    }

    public int getWeakPower() {
        BlockEntityRedstoneWire wire = (BlockEntityRedstoneWire)this.source().getTile();
        return wire.getRedstoneValue() > 0L ? 15 : 0;
    }

    public void setTextures(BiConsumer<String, Texture> texer) {
        BlockEntityRedstoneWire wire = (BlockEntityRedstoneWire)this.source().getTile();
        texer.accept("bottom", (Texture)this.factory.getTextures().get(wire.getRedstoneValue() > 0L ? 0 : 1));
        texer.accept("top", (Texture)this.factory.getTextures().get(wire.getRedstoneValue() > 0L ? 1 : 0));
        texer.accept("middle", (Texture)this.factory.getTextures().get(1));
    }

    public ResourceLocation getModel(String type, Direction dir) {
        return new ResourceLocation("gtcore:block/cover/" + this.getRenderId());
    }

    public VoxelShape getShape(Direction side) throws ExecutionException {
        int config = 1 << side.m_122411_();
        BlockPipe pipe = (BlockPipe)GTCoreCables.WIRE_RED_ALLOY.getBlock(PipeSize.VTINY);
        return (VoxelShape)pipe.getPipeShapes().get((Object)config, () -> pipe.makeShapes((short)config));
    }

    public ResourceLocation getIdForCache() {
        return new ResourceLocation("gtcore", "torches");
    }
}

