/*
 * Decompiled with CFR 0.152.
 */
package org.gtreimagined.gtcore.block;

import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.MapColor;
import org.gtreimagined.gtcore.block.RedstoneWire;
import org.gtreimagined.gtcore.blockentity.BlockEntityRedstoneWire;
import org.gtreimagined.gtlib.blockentity.pipe.BlockEntityPipe;
import org.gtreimagined.gtlib.data.GTTools;
import org.gtreimagined.gtlib.pipe.BlockPipe;
import org.gtreimagined.gtlib.pipe.PipeSize;
import org.gtreimagined.gtlib.texture.Texture;
import org.gtreimagined.gtlib.tool.GTToolType;
import org.gtreimagined.gtlib.util.Utils;
import org.jetbrains.annotations.Nullable;

public class BlockRedstoneWire<T extends RedstoneWire<T>>
extends BlockPipe<T> {
    public static final int INSULATION_COLOR = 0x604040;
    public static final IntegerProperty LIGHT = IntegerProperty.m_61631_((String)"light", (int)0, (int)15);
    protected final StateDefinition<Block, BlockState> stateContainer;

    public BlockRedstoneWire(T type, PipeSize size) {
        super(((RedstoneWire)((Object)type)).getType(), type, size, 2, BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283913_).m_60913_(1.0f, 3.0f).m_60999_().m_60991_((blockState, blockGetter, blockPos) -> BlockRedstoneWire.isEmissive(size, blockState, blockGetter, blockPos)).m_60953_(BlockRedstoneWire::getLightEmission));
        String prefix = size == PipeSize.TINY ? "cable" : "wire";
        this.side = new Texture("gtlib", "block/pipe/" + prefix + "_side");
        this.faces = new Texture[]{new Texture("gtlib", "block/pipe/wire_vtiny"), new Texture("gtlib", "block/pipe/wire_tiny"), new Texture("gtlib", "block/pipe/wire_small"), new Texture("gtlib", "block/pipe/wire_normal"), new Texture("gtlib", "block/pipe/wire_large"), new Texture("gtlib", "block/pipe/wire_huge")};
        StateDefinition.Builder builder = new StateDefinition.Builder((Object)this);
        this.m_7926_((StateDefinition.Builder<Block, BlockState>)builder);
        this.stateContainer = builder.m_61101_(Block::m_49966_, BlockState::new);
        if (((RedstoneWire)((Object)type)).emitsLight && size == PipeSize.VTINY) {
            this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)this.m_49965_().m_61090_()).m_61124_((Property)BlockStateProperties.f_61362_, (Comparable)Boolean.valueOf(false))).m_61124_((Property)TICKING, (Comparable)Boolean.valueOf(false))).m_61124_((Property)LIGHT, (Comparable)Integer.valueOf(0)));
        } else {
            this.m_49959_((BlockState)((BlockState)((BlockState)this.m_49965_().m_61090_()).m_61124_((Property)BlockStateProperties.f_61362_, (Comparable)Boolean.valueOf(false))).m_61124_((Property)TICKING, (Comparable)Boolean.valueOf(false)));
        }
    }

    public StateDefinition<Block, BlockState> m_49965_() {
        if (this.stateContainer != null) {
            return this.stateContainer;
        }
        return super.m_49965_();
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        if (this.type == null) {
            return;
        }
        if (((RedstoneWire)this.type).emitsLight && this.size == PipeSize.VTINY) {
            builder.m_61104_(new Property[]{LIGHT});
        }
    }

    private static boolean isEmissive(PipeSize size, BlockState blockState, BlockGetter blockGetter, BlockPos blockPos) {
        BlockEntityRedstoneWire wire;
        BlockEntity blockEntity;
        return size == PipeSize.VTINY && (blockEntity = blockGetter.m_7702_(blockPos)) instanceof BlockEntityRedstoneWire && (wire = (BlockEntityRedstoneWire)blockEntity).getRedstoneValue() > 0L;
    }

    public static int getLightEmission(BlockState state) {
        if (state.m_61138_((Property)LIGHT)) {
            return (Integer)state.m_61143_((Property)LIGHT);
        }
        return 0;
    }

    public void m_5871_(ItemStack stack, @Nullable BlockGetter level, List<Component> tooltip, TooltipFlag flag) {
        super.m_5871_(stack, level, tooltip, flag);
        tooltip.add((Component)Utils.translatable((String)"tooltip.gtcore.redstone_wire_range", (Object[])new Object[]{((RedstoneWire)this.type).getRange()}));
        if (((RedstoneWire)this.type).isEmitsLight() && this.size == PipeSize.VTINY) {
            tooltip.add((Component)Utils.translatable((String)"tooltip.gtcore.redstone_wire_light", (Object[])new Object[0]));
        }
    }

    public GTToolType getToolType() {
        return GTTools.WIRE_CUTTER;
    }

    public boolean onBlockPlacedTo(Level world, BlockPos pos, Direction face) {
        BlockEntityRedstoneWire<?> tile = BlockRedstoneWire.getTilePipeRedstone((BlockGetter)world, pos);
        if (tile != null && !world.m_5776_()) {
            BlockEntityPipe side = tile.getPipe(face.m_122424_());
            if (side != null && side.blocksSide(face)) {
                return false;
            }
            tile.setConnection(face.m_122424_());
            return true;
        }
        return false;
    }

    protected static BlockEntityRedstoneWire<?> getTilePipeRedstone(BlockGetter world, BlockPos pos) {
        BlockEntityRedstoneWire wire;
        BlockEntity tile = world.m_7702_(pos);
        return tile instanceof BlockEntityRedstoneWire ? (wire = (BlockEntityRedstoneWire)tile) : null;
    }

    public int getBlockColor(BlockState state, @Nullable BlockGetter world, @Nullable BlockPos pos, int i) {
        if (world == null || pos == null) {
            return -1;
        }
        BlockEntityPipe pipe = BlockRedstoneWire.getTilePipe((BlockGetter)world, (BlockPos)pos);
        if (!(pipe instanceof BlockEntityRedstoneWire)) {
            return -1;
        }
        BlockEntityRedstoneWire redstoneWire = (BlockEntityRedstoneWire)pipe;
        if (this.size == PipeSize.TINY && pipe.getPipeColor() != -1 && i == 0) {
            return pipe.getPipeColor();
        }
        if (i == 1 && redstoneWire.getRedstoneValue() > 0L) {
            return ((RedstoneWire)this.getType()).getOnColor();
        }
        if (this.size == PipeSize.TINY) {
            return i == 1 ? this.getRGB() : (i == 0 ? 0x604040 : -1);
        }
        return i == 0 || i == 1 ? this.getRGB() : -1;
    }

    public int getItemColor(ItemStack stack, @Nullable Block block, int i) {
        if (this.size == PipeSize.TINY && stack.m_41783_() != null && stack.m_41783_().m_128441_("co") && i == 0) {
            return stack.m_41783_().m_128451_("co");
        }
        return this.size == PipeSize.TINY ? (i == 1 ? this.getRGB() : (i == 0 ? 0x604040 : -1)) : this.getRGB();
    }

    public int m_6378_(BlockState state, BlockGetter level, BlockPos pos, Direction direction) {
        BlockEntity be = level.m_7702_(pos);
        if (be instanceof BlockEntityRedstoneWire) {
            BlockEntityRedstoneWire wire = (BlockEntityRedstoneWire)be;
            return wire.getWeakPower(direction.m_122424_());
        }
        return super.m_6378_(state, level, pos, direction);
    }

    public int m_6376_(BlockState state, BlockGetter level, BlockPos pos, Direction direction) {
        BlockEntity be = level.m_7702_(pos);
        if (be instanceof BlockEntityRedstoneWire) {
            BlockEntityRedstoneWire wire = (BlockEntityRedstoneWire)be;
            return wire.getStrongPower(direction.m_122424_());
        }
        return super.m_6376_(state, level, pos, direction);
    }

    public int m_6782_(BlockState state, Level level, BlockPos pos) {
        return super.m_6782_(state, level, pos);
    }

    public boolean m_7899_(BlockState state) {
        return true;
    }
}

