/*
 * Decompiled with CFR 0.152.
 */
package org.gtreimagined.gtcore.machine;

import java.util.List;
import net.minecraft.resources.ResourceLocation;
import org.gtreimagined.gtcore.blockentity.BlockEntitySteamMachine;
import org.gtreimagined.gtlib.Data;
import org.gtreimagined.gtlib.gui.MenuHandler;
import org.gtreimagined.gtlib.gui.SlotData;
import org.gtreimagined.gtlib.gui.SlotType;
import org.gtreimagined.gtlib.gui.screen.GTContainerScreen;
import org.gtreimagined.gtlib.gui.slot.ISlotProvider;
import org.gtreimagined.gtlib.gui.widget.MachineStateWidget;
import org.gtreimagined.gtlib.gui.widget.ProgressWidget;
import org.gtreimagined.gtlib.gui.widget.TextWidget;
import org.gtreimagined.gtlib.gui.widget.WidgetSupplier;
import org.gtreimagined.gtlib.machine.Tier;
import org.gtreimagined.gtlib.machine.types.Machine;

public class SteamMachine
extends Machine<SteamMachine> {
    int durationMultiplier = 1;
    int euMultiplier = 2;

    public SteamMachine(String domain, String id) {
        super(domain, id);
        String bSuffix;
        this.setTile(BlockEntitySteamMachine::new);
        this.addFlags(new String[]{"basic", "steam", "coverable"});
        this.setGUI((MenuHandler)Data.BASIC_MENU_HANDLER);
        this.setClientTicking();
        this.getGuiData().getMachineData().setMachineStateLocation(Tier.BRONZE, "bronze_machine_state").setMachineStateLocation(Tier.STEEL, "steel_machine_state");
        String suffix = id.contains("furnace") || id.contains("smelter") || id.contains("boiler") ? "default" : id.replace("steam_", "");
        this.getGuiData().getMachineData().setProgressLocation(Tier.BRONZE, "bronze_" + suffix).setProgressLocation(Tier.STEEL, "steel_" + suffix);
        String string = bSuffix = id.contains("macerator") || id.contains("forge_hammer") ? id.replace("steam", "") : "";
        if (id.contains("boiler")) {
            this.getGuiData().setBackgroundTexture(Tier.BRONZE, id + "_bronze").setBackgroundTexture(Tier.STEEL, id + "_steel");
        } else {
            this.getGuiData().setBackgroundTexture(Tier.BRONZE, "machine_bronze" + bSuffix).setBackgroundTexture(Tier.STEEL, "machine_steel" + bSuffix);
        }
    }

    public int getDurationMultiplier() {
        return this.durationMultiplier;
    }

    public int getEuMultiplier() {
        return this.euMultiplier;
    }

    public SteamMachine setEuMultiplier(int euMultiplier) {
        this.euMultiplier = euMultiplier;
        return this;
    }

    public SteamMachine setDurationMultiplier(int durationMultiplier) {
        this.durationMultiplier = durationMultiplier;
        return this;
    }

    protected void setupGui() {
        super.setupGui();
        this.addGuiCallback(t -> {
            t.addWidget(WidgetSupplier.build((a, b) -> TextWidget.build((String)((GTContainerScreen)b).m_96636_().getString(), (int)0x404040, (boolean)false).build(a, b)).setPos(9, 5).clientSide());
            if (this.has("recipe") && !this.getId().contains("boiler")) {
                t.addWidget(ProgressWidget.build()).addWidget(MachineStateWidget.build());
            }
        });
    }

    public Machine<SteamMachine> add(ISlotProvider<?> provider) {
        List list = provider.getAnySlots();
        for (SlotData slot : list) {
            String suffix = slot.getType() == SlotType.FL_IN ? "fluid" : "item";
            this.add(Tier.BRONZE, slot.getType(), slot.getX(), slot.getY(), new ResourceLocation(this.domain, "bronze_" + suffix));
            this.add(Tier.STEEL, slot.getType(), slot.getX(), slot.getY(), new ResourceLocation(this.domain, "steel_" + suffix));
        }
        return this;
    }

    public Machine<SteamMachine> add(SlotType<?> type, int x, int y) {
        String suffix = type == SlotType.FL_IN ? "fluid" : "item";
        this.add(Tier.BRONZE, type, x, y, new ResourceLocation(this.domain, "bronze_" + suffix));
        this.add(Tier.STEEL, type, x, y, new ResourceLocation(this.domain, "steel_" + suffix));
        return this;
    }
}

