/*
 * Decompiled with CFR 0.152.
 */
package org.gtreimagined.gtcore.blockentity;

import com.teamresourceful.resourcefullib.common.networking.base.Packet;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.items.IItemHandler;
import org.gtreimagined.gtcore.blockentity.BlockEntityMaterial;
import org.gtreimagined.gtcore.blockentity.IInventorySyncTile;
import org.gtreimagined.gtcore.data.SlotTypes;
import org.gtreimagined.gtcore.item.ItemTape;
import org.gtreimagined.gtcore.machine.MassStorageItemHandler;
import org.gtreimagined.gtcore.machine.MassStorageMachine;
import org.gtreimagined.gtcore.network.MessageTriggerInventorySync;
import org.gtreimagined.gtlib.capability.item.ITrackedHandler;
import org.gtreimagined.gtlib.capability.item.TrackedItemHandler;
import org.gtreimagined.gtlib.capability.machine.MachineItemHandler;
import org.gtreimagined.gtlib.data.GTTools;
import org.gtreimagined.gtlib.gui.SlotType;
import org.gtreimagined.gtlib.machine.MachineState;
import org.gtreimagined.gtlib.machine.event.IMachineEvent;
import org.gtreimagined.gtlib.network.GTLibNetwork;
import org.gtreimagined.gtlib.tool.GTToolType;
import org.gtreimagined.gtlib.util.Utils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BlockEntityMassStorage
extends BlockEntityMaterial<BlockEntityMassStorage>
implements IInventorySyncTile {
    boolean output = false;
    boolean outputOverflow = false;
    boolean syncSlots;
    public boolean keepFilter = true;

    public BlockEntityMassStorage(MassStorageMachine type, BlockPos pos, BlockState state) {
        super(type, pos, state);
        this.itemHandler.set(() -> new MassStorageItemHandler(this));
    }

    public MassStorageMachine getMassStorageMachine() {
        return (MassStorageMachine)this.type;
    }

    public int getMaxLimit() {
        return this.getMassStorageMachine().getCapacity();
    }

    public int getItemAmount() {
        return this.itemHandler.map(i -> i.getHandler(SlotTypes.UNLIMITED).getStackInSlot(0).m_41613_()).orElse(0);
    }

    public void onDrop(BlockState state, LootParams.Builder builder, List<ItemStack> drops) {
        if (!drops.isEmpty() && this.getMachineState() == MachineState.ACTIVE) {
            ItemStack massStorage = drops.get(0);
            CompoundTag nbt = new CompoundTag();
            this.itemHandler.ifPresent(handler -> handler.getAll().forEach((f, i) -> {
                if (i instanceof TrackedItemHandler) {
                    TrackedItemHandler t = (TrackedItemHandler)i;
                    if (t.isEmpty()) {
                        return;
                    }
                    nbt.m_128365_(f.getId(), (Tag)t.serializeNBT());
                }
            }));
            if (!nbt.m_128456_()) {
                massStorage.m_41784_().m_128365_("inventories", (Tag)nbt);
            }
            massStorage.m_41784_().m_128379_("taped", true);
            if (this.output) {
                massStorage.m_41784_().m_128379_("output", this.output);
            }
            if (this.outputOverflow) {
                massStorage.m_41784_().m_128379_("outputOverflow", this.outputOverflow);
            }
        }
    }

    public void dropInventory(BlockState state, LootParams.Builder builder, List<ItemStack> drops) {
        if (this.getMachineState() != MachineState.ACTIVE) {
            this.itemHandler.ifPresent(t -> {
                ItemStack held = t.getHandler(SlotTypes.UNLIMITED).getStackInSlot(0);
                int amountToExtract = held.m_41613_();
                if (amountToExtract > 0) {
                    if (amountToExtract > held.m_41741_()) {
                        ItemStack toAdd;
                        for (int toExtract = amountToExtract; toExtract > 0; toExtract -= toAdd.m_41613_()) {
                            toAdd = Utils.ca((int)Math.min(held.m_41741_(), toExtract), (ItemStack)held);
                            drops.add(toAdd);
                        }
                    } else {
                        ItemStack toAdd = Utils.ca((int)amountToExtract, (ItemStack)held);
                        drops.add(toAdd);
                    }
                }
            });
        }
    }

    public void onPlacedBy(Level world, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        super.onPlacedBy(world, pos, state, placer, stack);
        CompoundTag nbt = stack.m_41783_();
        if (nbt != null && nbt.m_128441_("taped")) {
            if (nbt.m_128441_("inventories")) {
                CompoundTag inventories = nbt.m_128469_("inventories");
                this.itemHandler.ifPresent(handler -> handler.getAll().forEach((f, i) -> {
                    if (!inventories.m_128441_(f.getId())) {
                        return;
                    }
                    if (i instanceof TrackedItemHandler) {
                        TrackedItemHandler t = (TrackedItemHandler)i;
                        t.deserializeNBT(inventories.m_128469_(f.getId()));
                    }
                }));
                this.setMachineState(MachineState.ACTIVE);
            }
            if (nbt.m_128441_("output") && nbt.m_128471_("output")) {
                this.output = true;
            }
            if (nbt.m_128441_("outputOverflow") && nbt.m_128471_("outputOverflow")) {
                this.outputOverflow = true;
            }
        }
    }

    public InteractionResult onInteractServer(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit, @Nullable GTToolType type) {
        if ((type == GTTools.KNIFE || type == GTTools.SCISSORS) && this.getMachineState() == MachineState.ACTIVE) {
            this.setMachineState(MachineState.IDLE);
            Utils.damageStack((ItemStack)player.m_21120_(hand), (InteractionHand)hand, (LivingEntity)player);
            return InteractionResult.SUCCESS;
        }
        if (this.getMachineState() == MachineState.ACTIVE) {
            return super.onInteractServer(state, world, pos, player, hand, hit, type);
        }
        Vec3 vec = hit.m_82450_();
        ITrackedHandler handler = this.itemHandler.map(i -> i.getHandler(SlotTypes.UNLIMITED)).orElse(null);
        ItemStack stack = player.m_21120_(hand);
        Item item = stack.m_41720_();
        if (item instanceof ItemTape) {
            int count;
            ItemTape tape = (ItemTape)item;
            if (stack.m_41763_() && ((count = handler.getStackInSlot(0).m_41613_()) == 0 || count <= stack.m_41776_() - stack.m_41773_())) {
                int damage = count == 0 ? 1 : count;
                this.setMachineState(MachineState.ACTIVE);
                if (!player.m_7500_()) {
                    stack.m_41622_(damage, (LivingEntity)player, player2 -> {
                        player2.m_21190_(hand);
                        if (!player2.m_36356_(new ItemStack((ItemLike)tape.getEmpty()))) {
                            player2.m_36176_(new ItemStack((ItemLike)tape.getEmpty()), true);
                        }
                    });
                }
                return InteractionResult.SUCCESS;
            }
        }
        if (type == GTTools.WIRE_CUTTER) {
            this.outputOverflow = !this.outputOverflow;
            player.m_5661_((Component)Utils.literal((String)(this.outputOverflow ? "Outputs overflow" : "Doesn't output overflow")), false);
            Utils.damageStack((ItemStack)player.m_21120_(hand), (InteractionHand)hand, (LivingEntity)player);
            return InteractionResult.SUCCESS;
        }
        if (type == GTTools.WRENCH_ALT) {
            this.output = !this.output;
            player.m_5661_((Component)Utils.literal((String)(this.output ? "Auto output on" : "Auto output off")), false);
            Utils.damageStack((ItemStack)player.m_21120_(hand), (InteractionHand)hand, (LivingEntity)player);
            return InteractionResult.SUCCESS;
        }
        if (type == GTTools.SCREWDRIVER && this.coverHandler.map(c -> c.get(Utils.getInteractSide((BlockHitResult)hit)).isEmpty()).orElse(true).booleanValue()) {
            this.keepFilter = !this.keepFilter;
            player.m_5661_((Component)Utils.literal((String)("Filter " + (this.keepFilter ? "Stays" : "Resets") + " when empty")), false);
            Utils.damageStack((ItemStack)player.m_21120_(hand), (InteractionHand)hand, (LivingEntity)player);
            if (!this.keepFilter) {
                this.itemHandler.ifPresent(i -> i.getHandler(SlotType.DISPLAY).setStackInSlot(0, ItemStack.f_41583_));
            }
            return InteractionResult.SUCCESS;
        }
        if (hit.m_82434_().m_122434_().m_122479_() && hit.m_82434_() == this.getFacing() && handler != null) {
            double x = hit.m_82434_().m_122434_() == Direction.Axis.Z ? vec.m_7096_() - (double)hit.m_82425_().m_123341_() : vec.m_7094_() - (double)hit.m_82425_().m_123343_();
            double y = vec.m_7098_() - (double)hit.m_82425_().m_123342_();
            int amountToExtract = 0;
            if (x > 0.0625 && x < 0.1875) {
                if (y > 0.125 && y < 0.25) {
                    int n = amountToExtract = hit.m_82434_().m_122416_() > 1 ? 16 : 1;
                }
                if (y > 0.3125 && y < 0.4375) {
                    int n = amountToExtract = hit.m_82434_().m_122416_() > 1 ? 32 : 4;
                }
                if (y > 0.5 && y < 0.625) {
                    amountToExtract = hit.m_82434_().m_122416_() > 1 ? 64 : 8;
                }
            } else if (x > 0.8125 && x < 0.9375) {
                if (y > 0.125 && y < 0.25) {
                    int n = amountToExtract = hit.m_82434_().m_122416_() > 1 ? 1 : 16;
                }
                if (y > 0.3125 && y < 0.4375) {
                    int n = amountToExtract = hit.m_82434_().m_122416_() > 1 ? 4 : 32;
                }
                if (y > 0.5 && y < 0.625) {
                    amountToExtract = hit.m_82434_().m_122416_() > 1 ? 8 : 64;
                }
            } else if (x > 0.25 && x < 0.75 && y > 0.125 && y < 0.625) {
                ItemStack stored = handler.getStackInSlot(0);
                ItemStack displayed = this.itemHandler.map(i -> i.getHandler(SlotType.DISPLAY).getStackInSlot(0)).orElse(ItemStack.f_41583_);
                if (type == GTTools.SOFT_HAMMER) {
                    amountToExtract = stored.m_41613_();
                    Utils.damageStack((ItemStack)stack, (InteractionHand)hand, (LivingEntity)player);
                    ((MachineItemHandler)this.itemHandler.get()).getHandler(SlotType.DISPLAY).setStackInSlot(0, ItemStack.f_41583_);
                } else if (!stack.m_41619_()) {
                    ItemStack leftover = handler.insertItem(0, stack.m_41777_(), true);
                    if (leftover.m_41613_() < stack.m_41613_()) {
                        handler.insertItem(0, stack.m_41777_(), false);
                        stack.m_41774_(stack.m_41613_() - leftover.m_41613_());
                        return InteractionResult.SUCCESS;
                    }
                } else if (!stored.m_41619_() || !displayed.m_41619_()) {
                    boolean sucess = false;
                    for (int i2 = 0; i2 < player.m_150109_().f_35974_.size(); ++i2) {
                        ItemStack stack1 = (ItemStack)player.m_150109_().f_35974_.get(i2);
                        if (!Utils.equals((ItemStack)stack1, (ItemStack)displayed) && !Utils.equals((ItemStack)stack1, (ItemStack)stored)) continue;
                        ItemStack inserted = handler.insertItem(0, stack1.m_41777_(), false);
                        stack1.m_41774_(stack1.m_41613_() - inserted.m_41613_());
                        sucess = true;
                        if (inserted.m_41613_() > 0) break;
                    }
                    if (sucess) {
                        return InteractionResult.SUCCESS;
                    }
                }
            }
            ItemStack held = handler.getStackInSlot(0);
            if (amountToExtract > 0 && !held.m_41619_()) {
                int extract = Math.min(amountToExtract, held.m_41613_());
                if (extract > held.m_41741_()) {
                    ItemStack toAdd;
                    for (int toExtract = extract; toExtract > 0; toExtract -= toAdd.m_41613_()) {
                        toAdd = Utils.ca((int)Math.min(held.m_41741_(), toExtract), (ItemStack)held);
                        if (player.m_36356_(toAdd)) continue;
                        player.m_36176_(toAdd, true);
                    }
                } else {
                    ItemStack toAdd = Utils.ca((int)extract, (ItemStack)held);
                    if (!player.m_36356_(toAdd)) {
                        player.m_36176_(toAdd, true);
                    }
                }
                handler.extractItem(0, extract, false);
                world.m_5594_(null, this.m_58899_(), SoundEvents.f_12019_, SoundSource.PLAYERS, 1.0f, 1.0f);
                return InteractionResult.SUCCESS;
            }
            return InteractionResult.CONSUME;
        }
        return super.onInteractServer(state, world, pos, player, hand, hit, type);
    }

    public void onFirstTickClient(Level level, BlockPos pos, BlockState state) {
        super.onFirstTickClient(level, pos, state);
        GTLibNetwork.NETWORK.sendToServer((Packet)new MessageTriggerInventorySync(this.m_58899_()));
    }

    public void serverTick(Level level, BlockPos pos, BlockState state) {
        super.serverTick(level, pos, state);
        if (this.getMachineState() != MachineState.ACTIVE && this.output && level.m_46467_() % 10L == 0L) {
            this.processItemOutput(ItemStack.f_41583_, false);
        }
        if (this.syncSlots) {
            this.syncSlots();
            this.syncSlots = false;
        }
    }

    @NotNull
    public CompoundTag m_5995_() {
        CompoundTag nbt = super.m_5995_();
        this.itemHandler.ifPresent(e -> {
            CompoundTag in = new CompoundTag();
            e.getAll().forEach((f, i) -> in.m_128365_(f.getId(), (Tag)this.serializeWithEmpty((IItemHandler)i, new CompoundTag())));
            nbt.m_128365_("it", (Tag)in);
        });
        return nbt;
    }

    public CompoundTag serializeWithEmpty(IItemHandler container, CompoundTag nbt) {
        ListTag nbtTagList = new ListTag();
        for (int i = 0; i < container.getSlots(); ++i) {
            CompoundTag itemTag = new CompoundTag();
            itemTag.m_128405_("Slot", i);
            container.getStackInSlot(i).m_41739_(itemTag);
            itemTag.m_128405_("count", container.getStackInSlot(i).m_41613_());
            nbtTagList.add((Object)itemTag);
        }
        nbt.m_128365_("Items", (Tag)nbtTagList);
        return nbt;
    }

    @Override
    public void setSyncSlots(boolean syncSlots) {
        this.syncSlots = syncSlots;
    }

    public void syncSlots() {
        if (this.m_58904_() != null && this.isServerSide()) {
            this.sidedSync(true);
        }
    }

    public void processItemOutput(ItemStack itemStack, boolean simulate) {
        Direction outputDir = Direction.DOWN;
        BlockEntity adjTile = this.getCachedBlockEntity(outputDir);
        if (adjTile == null) {
            return;
        }
        if (!itemStack.m_41619_()) {
            adjTile.getCapability(ForgeCapabilities.ITEM_HANDLER, outputDir.m_122424_()).ifPresent(adjHandler -> {
                ItemStack transferred = Utils.insertItem((IItemHandler)adjHandler, (ItemStack)itemStack.m_41777_(), (boolean)simulate);
                itemStack.m_41774_(itemStack.m_41613_() - transferred.m_41613_());
            });
        } else if (!simulate) {
            adjTile.getCapability(ForgeCapabilities.ITEM_HANDLER, outputDir.m_122424_()).ifPresent(adjHandler -> this.itemHandler.ifPresent(h -> Utils.transferItems((IItemHandler)h.getHandler(SlotTypes.UNLIMITED), (IItemHandler)adjHandler, (boolean)true)));
        }
    }

    public boolean canPlayerOpenGui(Player playerEntity) {
        return playerEntity.m_7500_();
    }

    public void onMachineEvent(IMachineEvent event, Object ... data) {
        if (event instanceof SlotType && data.length > 0 && data[0] instanceof Integer && this.isServerSide() && this.m_58904_() != null) {
            this.sidedSync(true);
        }
        super.onMachineEvent(event, data);
    }

    public boolean isOutputOverflow() {
        return this.outputOverflow;
    }

    public boolean isOutput() {
        return this.output;
    }

    public void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128379_("outputOverflow", this.outputOverflow);
        tag.m_128379_("output", this.output);
        tag.m_128379_("keepFilter", this.keepFilter);
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.outputOverflow = tag.m_128471_("outputOverflow");
        this.output = tag.m_128471_("output");
        boolean bl = this.keepFilter = !tag.m_128441_("keepFilter") || tag.m_128471_("keepFilter");
        if (this.f_58857_ != null && this.isClientSide()) {
            this.sidedSync(true);
        }
    }

    public List<String> getInfo(boolean simple) {
        List list = super.getInfo(simple);
        list.add("Auto Outputs: " + this.output);
        list.add("Keeps Filter: " + this.keepFilter);
        list.add("Outputs Overflow: " + this.outputOverflow);
        return list;
    }
}

