/*
 * Decompiled with CFR 0.152.
 */
package org.gtreimagined.gtcore;

import com.google.common.collect.ImmutableMap;
import it.unimi.dsi.fastutil.Pair;
import it.unimi.dsi.fastutil.objects.Object2ObjectMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import org.gtreimagined.gtcore.data.GTCoreItems;
import org.gtreimagined.gtcore.item.ItemSelectorTag;
import org.gtreimagined.gtlib.GTAPI;
import org.gtreimagined.gtlib.item.ItemBasic;
import org.gtreimagined.gtlib.util.RegistryUtils;

public class BookRegistration {
    private static final Object2ObjectMap<Item, Pair<ResourceLocation, ResourceLocation>> TEXTURE_MAP = new Object2ObjectOpenHashMap();

    public static Map<Item, Pair<ResourceLocation, ResourceLocation>> getTextureMap() {
        return ImmutableMap.copyOf(TEXTURE_MAP);
    }

    public static void registerBookTexture(Item item, ResourceLocation back, ResourceLocation side) {
        TEXTURE_MAP.put((Object)item, (Object)Pair.of((Object)back, (Object)side));
    }

    private static void registerBookTexture(Item item, String id) {
        BookRegistration.registerBookTexture(item, new ResourceLocation("gtcore", "block/books/" + id + "_back"), new ResourceLocation("gtcore", "block/books/" + id + "_side"));
    }

    public static void registerBooks() {
        Item[] records;
        BookRegistration.registerBookTexture(Items.f_42517_, "book_vanilla");
        BookRegistration.registerBookTexture(Items.f_42615_, "book_vanilla");
        BookRegistration.registerBookTexture(Items.f_42614_, "book_vanilla");
        BookRegistration.registerBookTexture(Items.f_42690_, "book_enchanted");
        BookRegistration.registerBookTexture(Items.f_42487_, "frame");
        BookRegistration.registerBookTexture(Items.f_42516_, "folder");
        BookRegistration.registerBookTexture(Items.f_42656_, "folder");
        BookRegistration.registerBookTexture(Items.f_42676_, "folder");
        BookRegistration.registerBookTexture(Items.f_42573_, "folder_red");
        BookRegistration.registerBookTexture(Items.f_42617_, "frame");
        for (Item item : records = new Item[]{Items.f_42752_, Items.f_42701_, Items.f_42702_, Items.f_42703_, Items.f_42704_, Items.f_42705_, Items.f_42706_, Items.f_42707_, Items.f_42708_, Items.f_42709_, Items.f_42710_, Items.f_42711_, Items.f_186363_, Items.f_42712_}) {
            BookRegistration.registerBookTexture(item, "record");
        }
        BookRegistration.registerBookTexture(GTCoreItems.EmptyShape, "extruder_shape");
        GTAPI.all(ItemBasic.class, (String)"gtcore").forEach(i -> {
            if (i.getId().endsWith("_shape") || i.getId().endsWith("_mold")) {
                BookRegistration.registerBookTexture((Item)i, "extruder_shape");
            }
        });
        GTAPI.all(ItemSelectorTag.class, (String)"gtcore").forEach(i -> BookRegistration.registerBookTexture((Item)i, "tablet_computer_metallic"));
        BookRegistration.registerBookTexture(GTCoreItems.Tape, "tape_white");
        BookRegistration.registerBookTexture(GTCoreItems.TapeEmpty, "tape_white");
        BookRegistration.registerBookTexture(GTCoreItems.DuctTape, "tape_gray");
        BookRegistration.registerBookTexture(GTCoreItems.DuctTapeEmpty, "tape_gray");
        BookRegistration.registerBookTexture(GTCoreItems.FALDuctTape, "tape_black");
        BookRegistration.registerBookTexture(GTCoreItems.FALDuctTapeEmpty, "tape_black");
        BookRegistration.registerBookTexture(GTCoreItems.EmptyBlueprint, "folder");
        BookRegistration.registerBookTexture(GTCoreItems.Blueprint, "folder_blue");
        if (GTAPI.isModLoaded((String)"bic_clipboard")) {
            BookRegistration.registerBookTexture(RegistryUtils.getItemFromID((String)"bic_clipboard", (String)"clipboard"), "clipboard");
        }
        if (GTAPI.isModLoaded((String)"twilightforest")) {
            BookRegistration.registerBookTexture(RegistryUtils.getItemFromID((String)"twilightforest", (String)"magic_map"), "folder");
            BookRegistration.registerBookTexture(RegistryUtils.getItemFromID((String)"twilightforest", (String)"maze_map"), "folder");
            BookRegistration.registerBookTexture(RegistryUtils.getItemFromID((String)"twilightforest", (String)"ore_map"), "folder");
            BookRegistration.registerBookTexture(RegistryUtils.getItemFromID((String)"twilightforest", (String)"filled_magic_map"), "folder_red");
            BookRegistration.registerBookTexture(RegistryUtils.getItemFromID((String)"twilightforest", (String)"filled_maze_map"), "folder_red");
            BookRegistration.registerBookTexture(RegistryUtils.getItemFromID((String)"twilightforest", (String)"filled_ore_map"), "folder_red");
            BookRegistration.registerBookTexture(RegistryUtils.getItemFromID((String)"twilightforest", (String)"tower_key"), "book_vanilla");
        }
        if (GTAPI.isModLoaded((String)"computercraft")) {
            BookRegistration.registerBookTexture(RegistryUtils.getItemFromID((String)"computercraft", (String)"pocket_computer_normal"), "tablet_computer_metallic");
            BookRegistration.registerBookTexture(RegistryUtils.getItemFromID((String)"computercraft", (String)"pocket_computer_advanced"), "tablet_computer_gold");
            BookRegistration.registerBookTexture(RegistryUtils.getItemFromID((String)"computercraft", (String)"disk"), "floppy");
            BookRegistration.registerBookTexture(RegistryUtils.getItemFromID((String)"computercraft", (String)"printed_page"), "folder_red");
            BookRegistration.registerBookTexture(RegistryUtils.getItemFromID((String)"computercraft", (String)"printed_pages"), "folder_red");
            BookRegistration.registerBookTexture(RegistryUtils.getItemFromID((String)"computercraft", (String)"printed_book"), "book_vanilla");
        }
        if (GTAPI.isModLoaded((String)"ae2")) {
            String[] types;
            BookRegistration.registerBookTexture(RegistryUtils.getItemFromID((String)"ae2", (String)"biometric_card"), "id");
            BookRegistration.registerBookTexture(RegistryUtils.getItemFromID((String)"ae2", (String)"memory_card"), "ae_handheld");
            for (String string : types = new String[]{"1k", "4k", "16k", "64k", "256k"}) {
                BookRegistration.registerBookTexture(RegistryUtils.getItemFromID((String)"ae2", (String)("portable_item_cell_" + string)), "ae_handheld");
                BookRegistration.registerBookTexture(RegistryUtils.getItemFromID((String)"ae2", (String)("portable_fluid_cell_" + string)), "ae_handheld");
                BookRegistration.registerBookTexture(RegistryUtils.getItemFromID((String)"ae2", (String)("item_storage_cell_" + string)), "ae_cell");
                BookRegistration.registerBookTexture(RegistryUtils.getItemFromID((String)"ae2", (String)("fluid_storage_cell_" + string)), "ae_cell");
                if (GTAPI.isModLoaded((String)"megacells")) {
                    BookRegistration.registerBookTexture(RegistryUtils.getItemFromID((String)"megacells", (String)("portable_item_cell_" + string.replace('k', 'm'))), "ae_handheld");
                    BookRegistration.registerBookTexture(RegistryUtils.getItemFromID((String)"megacells", (String)("portable_fluid_cell_" + string.replace('k', 'm'))), "ae_handheld");
                    BookRegistration.registerBookTexture(RegistryUtils.getItemFromID((String)"megacells", (String)("item_storage_cell_" + string.replace('k', 'm'))), "ae_cell");
                    BookRegistration.registerBookTexture(RegistryUtils.getItemFromID((String)"megacells", (String)("fluid_storage_cell_" + string.replace('k', 'm'))), "ae_cell");
                }
                if (GTAPI.isModLoaded((String)"appbot")) {
                    BookRegistration.registerBookTexture(RegistryUtils.getItemFromID((String)"appbot", (String)("portable_mana_storage_cell_" + string)), "ae_handheld");
                    BookRegistration.registerBookTexture(RegistryUtils.getItemFromID((String)"appbot", (String)("mana_storage_cell_" + string)), "ae_cell");
                    if (GTAPI.isModLoaded((String)"megacells")) {
                        BookRegistration.registerBookTexture(RegistryUtils.getItemFromID((String)"megacells", (String)("portable_mana_cell_" + string.replace('k', 'm'))), "ae_handheld");
                        BookRegistration.registerBookTexture(RegistryUtils.getItemFromID((String)"megacells", (String)("mana_storage_cell_" + string.replace('k', 'm'))), "ae_cell");
                    }
                }
                if (!GTAPI.isModLoaded((String)"appmek")) continue;
                BookRegistration.registerBookTexture(RegistryUtils.getItemFromID((String)"appmek", (String)("portable_chemical_storage_cell_" + string)), "ae_handheld");
                BookRegistration.registerBookTexture(RegistryUtils.getItemFromID((String)"appmek", (String)("chemical_storage_cell_" + string)), "ae_cell");
                if (!GTAPI.isModLoaded((String)"megacells")) continue;
                BookRegistration.registerBookTexture(RegistryUtils.getItemFromID((String)"megacells", (String)("portable_chemical_cell_" + string.replace('k', 'm'))), "ae_handheld");
                BookRegistration.registerBookTexture(RegistryUtils.getItemFromID((String)"megacells", (String)("chemical_storage_cell_" + string.replace('k', 'm'))), "ae_cell");
            }
            for (String string : DyeColor.values()) {
                BookRegistration.registerBookTexture(RegistryUtils.getItemFromID((String)"ae2", (String)("memory_card_" + string.m_7912_())), "ae_handheld");
            }
            if (GTAPI.isModLoaded((String)"megacells")) {
                BookRegistration.registerBookTexture(RegistryUtils.getItemFromID((String)"megacells", (String)"mega_item_cell_housing"), "ae_cell");
                BookRegistration.registerBookTexture(RegistryUtils.getItemFromID((String)"megacells", (String)"mega_fluid_cell_housing"), "ae_cell");
            }
            if (GTAPI.isModLoaded((String)"appbot")) {
                BookRegistration.registerBookTexture(RegistryUtils.getItemFromID((String)"appbot", (String)"mana_cell_housing"), "ae_cell");
                BookRegistration.registerBookTexture(RegistryUtils.getItemFromID((String)"appbot", (String)"creative_mana_cell"), "ae_cell");
                if (GTAPI.isModLoaded((String)"megacells")) {
                    BookRegistration.registerBookTexture(RegistryUtils.getItemFromID((String)"megacells", (String)"mega_mana_cell_housing"), "ae_cell");
                }
            }
            if (GTAPI.isModLoaded((String)"appmek")) {
                BookRegistration.registerBookTexture(RegistryUtils.getItemFromID((String)"appmek", (String)"chemical_cell_housing"), "ae_cell");
                BookRegistration.registerBookTexture(RegistryUtils.getItemFromID((String)"appmek", (String)"creative_chemical_cell"), "ae_cell");
                if (GTAPI.isModLoaded((String)"megacells")) {
                    BookRegistration.registerBookTexture(RegistryUtils.getItemFromID((String)"megacells", (String)"mega_chemical_cell_housing"), "ae_cell");
                }
            }
            BookRegistration.registerBookTexture(RegistryUtils.getItemFromID((String)"ae2", (String)"creative_item_cell"), "ae_cell");
            BookRegistration.registerBookTexture(RegistryUtils.getItemFromID((String)"ae2", (String)"creative_fluid_cell"), "ae_cell");
            BookRegistration.registerBookTexture(RegistryUtils.getItemFromID((String)"ae2", (String)"item_cell_housing"), "ae_cell");
            BookRegistration.registerBookTexture(RegistryUtils.getItemFromID((String)"ae2", (String)"fluid_cell_housing"), "ae_cell");
            BookRegistration.registerBookTexture(RegistryUtils.getItemFromID((String)"ae2", (String)"view_cell"), "ae_handheld");
            BookRegistration.registerBookTexture(RegistryUtils.getItemFromID((String)"ae2", (String)"wireless_terminal"), "ae_handheld");
            BookRegistration.registerBookTexture(RegistryUtils.getItemFromID((String)"ae2", (String)"wireless_crafting_terminal"), "ae_handheld");
            BookRegistration.registerBookTexture(RegistryUtils.getItemFromID((String)"ae2", (String)"spatial_storage_cell_2"), "ae_cell");
            BookRegistration.registerBookTexture(RegistryUtils.getItemFromID((String)"ae2", (String)"spatial_storage_cell_16"), "ae_cell");
            BookRegistration.registerBookTexture(RegistryUtils.getItemFromID((String)"ae2", (String)"spatial_storage_cell_128"), "ae_cell");
            BookRegistration.registerBookTexture(RegistryUtils.getItemFromID((String)"ae2", (String)"calculation_processor_press"), "ae_press");
            BookRegistration.registerBookTexture(RegistryUtils.getItemFromID((String)"ae2", (String)"engineering_processor_press"), "ae_press");
            BookRegistration.registerBookTexture(RegistryUtils.getItemFromID((String)"ae2", (String)"logic_processor_press"), "ae_press");
            BookRegistration.registerBookTexture(RegistryUtils.getItemFromID((String)"ae2", (String)"silicon_press"), "ae_press");
            BookRegistration.registerBookTexture(RegistryUtils.getItemFromID((String)"ae2", (String)"name_press"), "ae_press");
        }
    }
}

