/*
 * Decompiled with CFR 0.152.
 */
package org.gtreimagined.gtcore.tree;

import com.google.common.collect.ImmutableList;
import com.mojang.serialization.Codec;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.List;
import java.util.Random;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.Vec3i;
import net.minecraft.data.worldgen.features.FeatureUtils;
import net.minecraft.data.worldgen.placement.PlacementUtils;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.blockpredicates.BlockPredicate;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.TreeConfiguration;
import net.minecraft.world.level.levelgen.feature.featuresize.FeatureSize;
import net.minecraft.world.level.levelgen.feature.featuresize.TwoLayersFeatureSize;
import net.minecraft.world.level.levelgen.feature.foliageplacers.FoliagePlacer;
import net.minecraft.world.level.levelgen.feature.stateproviders.BlockStateProvider;
import net.minecraft.world.level.levelgen.feature.treedecorators.LeaveVineDecorator;
import net.minecraft.world.level.levelgen.feature.trunkplacers.TrunkPlacer;
import net.minecraft.world.level.levelgen.placement.BiomeFilter;
import net.minecraft.world.level.levelgen.placement.BlockPredicateFilter;
import net.minecraft.world.level.levelgen.placement.InSquarePlacement;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraft.world.level.levelgen.placement.PlacementContext;
import net.minecraft.world.level.levelgen.placement.PlacementModifier;
import net.minecraft.world.level.levelgen.placement.PlacementModifierType;
import net.minecraft.world.level.levelgen.placement.SurfaceWaterDepthFilter;
import org.gtreimagined.gtcore.data.GTCoreBlocks;
import org.gtreimagined.gtcore.tree.RubberFoliagePlacer;
import org.gtreimagined.gtcore.tree.RubberTree;
import org.gtreimagined.gtcore.tree.RubberTrunkPlacer;
import org.gtreimagined.gtlib.mixin.BiomeAccessor;
import org.gtreimagined.gtlib.util.TagUtils;

public class RubberTreeWorldGen {
    public static Holder<PlacedFeature> TREE;
    public static Holder<PlacedFeature> TREE_SWAMP;
    public static Holder<PlacedFeature> TREE_JUNGLE;
    public static Holder<ConfiguredFeature<TreeConfiguration, ?>> TREE_FEATURE_CONFIG;
    public static Holder<ConfiguredFeature<TreeConfiguration, ?>> TREE_FEATURE_SWAMP_CONFIG;
    public static Holder<ConfiguredFeature<TreeConfiguration, ?>> TREE_FEATURE_JUNGLE_CONFIG;
    static final TreeConfiguration RUBBER_TREE_CONFIG_SWAMP;
    static final TreeConfiguration RUBBER_TREE_CONFIG_JUNGLE;
    static final TreeConfiguration RUBBER_TREE_CONFIG_NORMAL;
    public static final PlacementModifierType<RubberTreePlacementModifier> RUBBER_TREE_PLACEMENT_MODIFIER;

    public static Predicate<Biome.BiomeCategory> getValidBiomesStatic() {
        ObjectOpenHashSet blacklist = new ObjectOpenHashSet();
        blacklist.add(Biome.BiomeCategory.DESERT);
        blacklist.add(Biome.BiomeCategory.TAIGA);
        blacklist.add(Biome.BiomeCategory.EXTREME_HILLS);
        blacklist.add(Biome.BiomeCategory.ICY);
        blacklist.add(Biome.BiomeCategory.THEEND);
        blacklist.add(Biome.BiomeCategory.OCEAN);
        blacklist.add(Biome.BiomeCategory.NETHER);
        blacklist.add(Biome.BiomeCategory.PLAINS);
        return arg_0 -> RubberTreeWorldGen.lambda$getValidBiomesStatic$0((Set)blacklist, arg_0);
    }

    public static void init() {
        TREE_FEATURE_CONFIG = FeatureUtils.m_206488_((String)"gtcore:rubber_tree_normal", (Feature)RubberTree.TREE_FEATURE, (FeatureConfiguration)RUBBER_TREE_CONFIG_NORMAL);
        TREE_FEATURE_SWAMP_CONFIG = FeatureUtils.m_206488_((String)"gtcore:rubber_tree_jungle", (Feature)RubberTree.TREE_FEATURE, (FeatureConfiguration)RUBBER_TREE_CONFIG_JUNGLE);
        TREE_FEATURE_JUNGLE_CONFIG = FeatureUtils.m_206488_((String)"gtcore:rubber_tree_swamp", (Feature)RubberTree.TREE_FEATURE, (FeatureConfiguration)RUBBER_TREE_CONFIG_SWAMP);
        TREE = PlacementUtils.m_206513_((String)"gtcore:rubber", TREE_FEATURE_CONFIG, (PlacementModifier[])new PlacementModifier[]{new RubberTreePlacementModifier(), InSquarePlacement.m_191715_(), SurfaceWaterDepthFilter.m_191950_((int)0), PlacementUtils.f_195355_, BiomeFilter.m_191561_(), BlockPredicateFilter.m_191576_((BlockPredicate)BlockPredicate.m_190399_((BlockState)GTCoreBlocks.RUBBER_SAPLING.m_49966_(), (Vec3i)BlockPos.f_121853_))});
        TREE_JUNGLE = PlacementUtils.m_206513_((String)"gtcore:rubber_jungle", TREE_FEATURE_JUNGLE_CONFIG, (PlacementModifier[])new PlacementModifier[]{new RubberTreePlacementModifier(), InSquarePlacement.m_191715_(), SurfaceWaterDepthFilter.m_191950_((int)0), PlacementUtils.f_195355_, BiomeFilter.m_191561_(), BlockPredicateFilter.m_191576_((BlockPredicate)BlockPredicate.m_190399_((BlockState)GTCoreBlocks.RUBBER_SAPLING.m_49966_(), (Vec3i)BlockPos.f_121853_))});
        TREE_SWAMP = PlacementUtils.m_206513_((String)"gtcore:rubber_swamp", TREE_FEATURE_SWAMP_CONFIG, (PlacementModifier[])new PlacementModifier[]{new RubberTreePlacementModifier(), InSquarePlacement.m_191715_(), SurfaceWaterDepthFilter.m_191950_((int)2), PlacementUtils.f_195355_, BiomeFilter.m_191561_(), BlockPredicateFilter.m_191576_((BlockPredicate)BlockPredicate.m_190399_((BlockState)GTCoreBlocks.RUBBER_SAPLING.m_49966_(), (Vec3i)BlockPos.f_121853_))});
        Registry.m_122965_((Registry)Registry.f_122859_, (ResourceLocation)new ResourceLocation("gtcore", "rubber_trunk_placer"), RubberTrunkPlacer.RUBBER);
        Registry.m_122965_((Registry)Registry.f_194570_, (ResourceLocation)new ResourceLocation("gtcore", "rubber_tree_placement_modifier"), RUBBER_TREE_PLACEMENT_MODIFIER);
    }

    private static /* synthetic */ boolean lambda$getValidBiomesStatic$0(Set blacklist, Biome.BiomeCategory b) {
        return !blacklist.contains(b);
    }

    static {
        RUBBER_TREE_CONFIG_SWAMP = new TreeConfiguration.TreeConfigurationBuilder((BlockStateProvider)RubberTree.TRUNK_BLOCKS, (TrunkPlacer)new RubberTrunkPlacer(5, 2, 2), (BlockStateProvider)BlockStateProvider.m_191384_((BlockState)GTCoreBlocks.RUBBER_LEAVES.m_49966_()), (FoliagePlacer)new RubberFoliagePlacer(), (FeatureSize)new TwoLayersFeatureSize(1, 0, 2)).m_68244_().m_68249_((List)ImmutableList.of((Object)new LeaveVineDecorator())).m_68251_();
        RUBBER_TREE_CONFIG_JUNGLE = new TreeConfiguration.TreeConfigurationBuilder((BlockStateProvider)RubberTree.TRUNK_BLOCKS, (TrunkPlacer)new RubberTrunkPlacer(7, 2, 2), (BlockStateProvider)BlockStateProvider.m_191384_((BlockState)GTCoreBlocks.RUBBER_LEAVES.m_49966_()), (FoliagePlacer)new RubberFoliagePlacer(), (FeatureSize)new TwoLayersFeatureSize(1, 0, 2)).m_68244_().m_68249_((List)ImmutableList.of((Object)new LeaveVineDecorator())).m_68251_();
        RUBBER_TREE_CONFIG_NORMAL = new TreeConfiguration.TreeConfigurationBuilder((BlockStateProvider)RubberTree.TRUNK_BLOCKS, (TrunkPlacer)new RubberTrunkPlacer(5, 2, 2), (BlockStateProvider)BlockStateProvider.m_191384_((BlockState)GTCoreBlocks.RUBBER_LEAVES.m_49966_()), (FoliagePlacer)new RubberFoliagePlacer(), (FeatureSize)new TwoLayersFeatureSize(1, 0, 2)).m_68244_().m_68251_();
        RUBBER_TREE_PLACEMENT_MODIFIER = () -> RubberTreePlacementModifier.CODEC;
    }

    public static class RubberTreePlacementModifier
    extends PlacementModifier {
        public static final Codec<RubberTreePlacementModifier> CODEC = Codec.unit(RubberTreePlacementModifier::new);

        public Stream<BlockPos> m_183381_(PlacementContext context, Random random, BlockPos pos) {
            BiomeAccessor biome = (BiomeAccessor)context.m_191831_().m_204166_(pos).m_203334_();
            if (context.m_191831_().m_204166_(pos).m_203656_(TagUtils.getBiomeTag((ResourceLocation)new ResourceLocation("gtcore", "is_invalid_rubber")))) {
                return Stream.empty();
            }
            float p = 0.15f;
            if (biome.getClimateSettings().f_47681_ > 0.8f) {
                p = 0.04f;
                if (biome.getClimateSettings().f_47680_ == Biome.Precipitation.RAIN) {
                    p += 0.04f;
                }
            }
            float finalp = p;
            int i = 0;
            if (random.nextDouble() < (double)finalp) {
                i = random.nextInt(1) + 1;
            }
            return IntStream.range(0, i).mapToObj(ix -> {
                int j = random.nextInt(16) + pos.m_123341_();
                int k = random.nextInt(16) + pos.m_123343_();
                return new BlockPos(j, context.m_191824_(Heightmap.Types.MOTION_BLOCKING, j, k), k);
            });
        }

        public PlacementModifierType<?> m_183327_() {
            return RUBBER_TREE_PLACEMENT_MODIFIER;
        }
    }
}

