/*
 * Decompiled with CFR 0.152.
 */
package org.gtreimagined.gtcore.machine;

import net.minecraft.resources.ResourceLocation;
import org.gtreimagined.gtcore.blockentity.BlockEntityWorkbench;
import org.gtreimagined.gtcore.data.MenuHandlers;
import org.gtreimagined.gtcore.data.SlotTypes;
import org.gtreimagined.gtcore.machine.ChargingMachine;
import org.gtreimagined.gtlib.GTAPI;
import org.gtreimagined.gtlib.gui.ButtonOverlay;
import org.gtreimagined.gtlib.gui.MenuHandler;
import org.gtreimagined.gtlib.gui.SlotData;
import org.gtreimagined.gtlib.gui.SlotType;
import org.gtreimagined.gtlib.gui.widget.SlotWidget;
import org.gtreimagined.gtlib.material.Material;
import org.gtreimagined.gtlib.registration.IGTObject;

public class WorkbenchMachine
extends ChargingMachine {
    public WorkbenchMachine(String domain, Material material, boolean charge) {
        super(domain, material, "workbench", charge);
        int x;
        int y;
        this.setGUI((MenuHandler)MenuHandlers.WORKBENCH_HANDLER);
        this.addFlags(new String[]{"item", "gui"});
        this.setTile(BlockEntityWorkbench::new);
        for (y = 0; y < 4; ++y) {
            for (x = 0; x < 4; ++x) {
                this.add(SlotType.STORAGE, 8 + x * 18, 8 + y * 18);
            }
        }
        for (y = 0; y < 3; ++y) {
            for (x = 0; x < 3; ++x) {
                this.add(SlotTypes.CRAFTING, 82 + x * 18, 28 + y * 18);
            }
        }
        for (int x2 = 0; x2 < 5; ++x2) {
            this.add(charge ? SlotTypes.TOOL_CHARGE : SlotTypes.TOOLS, 82 + x2 * 18, 8);
        }
        this.add(SlotTypes.BLUEPRINT, 136, 28);
        this.add(SlotTypes.EXPORT, 154, 28);
        this.add(SlotTypes.PARK, 154, 64);
        this.addGuiCallback(t -> {
            t.addButton(136, 46, new ButtonOverlay("gtcore", "to_inv", 18, 18));
            t.addButton(154, 46, new ButtonOverlay("gtcore", "to_player", 18, 18));
            t.addWidget(SlotWidget.build((SlotData)new SlotData(SlotType.STORAGE, 136, 64, new ResourceLocation("gtcore", "textures/gui/slots/crafting_output.png"))));
        });
        this.removeFlags(new String[]{"coverable"});
        GTAPI.register(WorkbenchMachine.class, (IGTObject)this);
    }
}

