/*
 * Decompiled with CFR 0.152.
 */
package org.gtreimagined.gtcore.machine;

import com.gtnewhorizon.structurelib.structure.IStructureElement;
import com.gtnewhorizon.structurelib.structure.StructureUtility;
import java.util.function.Supplier;
import net.minecraft.world.level.block.Block;
import org.gtreimagined.gtcore.blockentity.BlockEntityLargeTank;
import org.gtreimagined.gtcore.machine.MaterialBasicMultiMachine;
import org.gtreimagined.gtlib.GTAPI;
import org.gtreimagined.gtlib.machine.Tier;
import org.gtreimagined.gtlib.material.IMaterialTag;
import org.gtreimagined.gtlib.material.Material;
import org.gtreimagined.gtlib.material.MaterialTags;
import org.gtreimagined.gtlib.registration.IGTObject;
import org.gtreimagined.gtlib.structure.FakeTileElement;
import org.gtreimagined.gtlib.texture.Texture;
import org.gtreimagined.gtlib.util.Utils;

public class MultiblockTankMachine
extends MaterialBasicMultiMachine {
    final int capacity;
    final boolean small;
    final Supplier<Block> casing;
    boolean acidProof;
    boolean gasProof;
    int maxHeat = Integer.MAX_VALUE;

    public MultiblockTankMachine(String domain, Material material, boolean small, int capacity, Supplier<Block> casing) {
        super(domain, (small ? "small" : "large") + "_" + material.getId() + "_tank_main_valve", material);
        this.setTiers(new Tier[]{Tier.NONE});
        if (small) {
            this.setStructure(BlockEntityLargeTank.class, b -> b.part("main").of(new String[]{"CCC", "CCC", "CCC"}).of(new String[]{"C~C", "C-C", "CCC"}).of(0).build().atElement('C', (IStructureElement)StructureUtility.lazy(t -> new FakeTileElement(t.getCasing()))).offset(1, 1, 0).build());
        } else {
            this.setStructure(BlockEntityLargeTank.class, b -> b.part("main").of(new String[]{"CCCCC", "CCCCC", "CCCCC", "CCCCC", "CCCCC"}).of(new String[]{"CCCCC", "C---C", "C---C", "C---C", "CCCCC"}).of(new String[]{"CC~CC", "C---C", "C---C", "C---C", "CCCCC"}).of(1).of(0).build().atElement('C', (IStructureElement)StructureUtility.lazy(t -> new FakeTileElement(t.getCasing()))).offset(2, 2, 0).build());
        }
        this.addTooltipInfo((machine, stack, world, tooltip, flag) -> {
            tooltip.add(Utils.translatable((String)"tooltip.gtcore.large_tank.0", (Object[])new Object[]{machine.m_49954_()}));
            tooltip.add(Utils.translatable((String)("tooltip.gtcore." + (small ? "small" : "large") + "_tank.1"), (Object[])new Object[]{((Block)casing.get()).m_49954_()}));
            tooltip.add(Utils.translatable((String)"machine.drum.capacity", (Object[])new Object[]{capacity}));
        });
        this.addFlags(new String[]{"fluid"});
        this.setTile((type1, pos, state1) -> new BlockEntityLargeTank(this, pos, state1));
        this.capacity = capacity;
        this.small = small;
        this.casing = casing;
        String prefix = material.has(new IMaterialTag[]{MaterialTags.WOOD}) ? "wood" : "metal";
        this.setBaseTexture(new Texture("gtcore", "block/casing/wall/" + prefix));
        this.setOverlayTextures((type, state, tier, i) -> {
            Texture blank = new Texture("gtcore", "block/machine/empty");
            return new Texture[]{blank, blank, blank, new Texture("gtcore", "block/casing/wall/" + prefix + "_tank_side_overlay"), blank, blank};
        });
        this.setVerticalFacingAllowed(true);
        GTAPI.register(MultiblockTankMachine.class, (IGTObject)this);
    }

    public int getCapacity() {
        return this.capacity;
    }

    public boolean isSmall() {
        return this.small;
    }

    public Supplier<Block> getCasing() {
        return this.casing;
    }

    public MultiblockTankMachine acidProof() {
        this.acidProof = true;
        return this;
    }

    public boolean isAcidProof() {
        return this.acidProof;
    }

    public MultiblockTankMachine gasProof() {
        this.gasProof = true;
        return this;
    }

    public boolean isGasProof() {
        return this.gasProof;
    }

    public MultiblockTankMachine maxHeat(int maxHeat) {
        this.maxHeat = maxHeat;
        return this;
    }

    public int getMaxHeat() {
        return this.maxHeat;
    }
}

