/*
 * Decompiled with CFR 0.152.
 */
package org.gtreimagined.gtcore.machine;

import java.util.function.BiPredicate;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.ItemStack;
import org.gtreimagined.gtcore.blockentity.BlockEntityMassStorage;
import org.gtreimagined.gtcore.blockentity.BlockEntityPlasticBin;
import org.gtreimagined.gtlib.capability.IGuiHandler;
import org.gtreimagined.gtlib.capability.item.ITrackedHandler;
import org.gtreimagined.gtlib.capability.item.TrackedItemHandler;
import org.gtreimagined.gtlib.capability.machine.MachineItemHandler;
import org.gtreimagined.gtlib.gui.SlotType;
import org.gtreimagined.gtlib.machine.MachineState;
import org.gtreimagined.gtlib.util.Utils;
import org.jetbrains.annotations.NotNull;

public class InfiniteSlotTrackedHandler<T extends IGuiHandler>
extends TrackedItemHandler<T> {
    public InfiniteSlotTrackedHandler(T tile, SlotType<?> type, int size, boolean output, boolean input, BiPredicate<IGuiHandler, ItemStack> validator, int limit) {
        super(tile, type, size, output, input, validator, limit);
    }

    protected int getStackLimit(int slot, @NotNull ItemStack stack) {
        return this.getSlotLimit(slot);
    }

    public int getSlotLimit(int slot) {
        IGuiHandler iGuiHandler = this.getTile();
        if (iGuiHandler instanceof BlockEntityPlasticBin) {
            BlockEntityPlasticBin bin = (BlockEntityPlasticBin)iGuiHandler;
            return bin.getMaxLimit();
        }
        return super.getSlotLimit(slot);
    }

    @NotNull
    public ItemStack insertItem(int slot, @NotNull ItemStack stack, boolean simulate) {
        IGuiHandler iGuiHandler = this.getTile();
        if (iGuiHandler instanceof BlockEntityMassStorage) {
            BlockEntityMassStorage barrel = (BlockEntityMassStorage)iGuiHandler;
            if (barrel.itemHandler.isPresent()) {
                if (barrel.getMachineState() == MachineState.ACTIVE) {
                    return stack;
                }
                ITrackedHandler handler = ((MachineItemHandler)barrel.itemHandler.get()).getHandler(SlotType.DISPLAY);
                if (barrel.keepFilter && !handler.getStackInSlot(0).m_41619_() && !Utils.equals((ItemStack)stack, (ItemStack)handler.getStackInSlot(0))) {
                    return stack;
                }
                if (barrel.keepFilter && handler.getStackInSlot(0).m_41619_() && !simulate) {
                    barrel.itemHandler.ifPresent(i -> i.getHandler(SlotType.DISPLAY).setStackInSlot(0, Utils.ca((int)1, (ItemStack)stack)));
                }
                if (barrel.isOutputOverflow()) {
                    ItemStack leftover = super.insertItem(slot, stack.m_41777_(), simulate);
                    if (leftover.m_41613_() > 0) {
                        barrel.processItemOutput(leftover, simulate);
                    }
                    return leftover;
                }
            }
        }
        return super.insertItem(slot, stack, simulate);
    }

    @NotNull
    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        if (amount == 0) {
            return ItemStack.f_41583_;
        }
        this.validateSlotIndex(slot);
        ItemStack existing = (ItemStack)this.stacks.get(slot);
        if (existing.m_41619_()) {
            return ItemStack.f_41583_;
        }
        if (existing.m_41613_() <= amount) {
            if (!simulate) {
                this.stacks.set(slot, (Object)ItemStack.f_41583_);
                IGuiHandler iGuiHandler = this.getTile();
                if (iGuiHandler instanceof BlockEntityMassStorage) {
                    ItemStack display;
                    BlockEntityMassStorage barrel = (BlockEntityMassStorage)iGuiHandler;
                    if (barrel.itemHandler.isPresent() && !barrel.keepFilter && !(display = ((MachineItemHandler)barrel.itemHandler.get()).getHandler(SlotType.DISPLAY).getStackInSlot(0)).m_41619_()) {
                        ((MachineItemHandler)barrel.itemHandler.get()).getHandler(SlotType.DISPLAY).setStackInSlot(0, ItemStack.f_41583_);
                    }
                }
                this.onContentsChanged(slot);
                return existing;
            }
            return existing.m_41777_();
        }
        if (!simulate) {
            this.stacks.set(slot, (Object)Utils.ca((int)(existing.m_41613_() - amount), (ItemStack)existing));
            this.onContentsChanged(slot);
        }
        return Utils.ca((int)amount, (ItemStack)existing);
    }

    public CompoundTag serializeNBT() {
        CompoundTag nbt = new CompoundTag();
        ListTag nbtTagList = new ListTag();
        for (int i = 0; i < this.stacks.size(); ++i) {
            if (((ItemStack)this.stacks.get(i)).m_41619_()) continue;
            CompoundTag itemTag = new CompoundTag();
            itemTag.m_128405_("Slot", i);
            ((ItemStack)this.stacks.get(i)).m_41739_(itemTag);
            itemTag.m_128344_("Count", (byte)1);
            itemTag.m_128405_("count", ((ItemStack)this.stacks.get(i)).m_41613_());
            nbtTagList.add((Object)itemTag);
        }
        nbt.m_128365_("Items", (Tag)nbtTagList);
        return nbt;
    }

    public void deserializeNBT(CompoundTag nbt) {
        ListTag tagList = nbt.m_128437_("Items", 10);
        for (int i = 0; i < tagList.size(); ++i) {
            CompoundTag itemTags = tagList.m_128728_(i);
            int slot = itemTags.m_128451_("Slot");
            if (slot < 0 || slot >= this.stacks.size()) continue;
            this.stacks.set(slot, (Object)ItemStack.m_41712_((CompoundTag)itemTags));
            ((ItemStack)this.stacks.get(slot)).m_41764_(itemTags.m_128451_("count"));
        }
        this.onLoad();
    }
}

