/*
 * Decompiled with CFR 0.152.
 */
package org.gtreimagined.gtcore.machine;

import net.minecraft.network.chat.Component;
import org.gtreimagined.gtcore.block.BlockGTHopper;
import org.gtreimagined.gtcore.blockentity.BlockEntityGTHopper;
import org.gtreimagined.gtcore.machine.MaterialMachine;
import org.gtreimagined.gtlib.GTAPI;
import org.gtreimagined.gtlib.gui.SlotType;
import org.gtreimagined.gtlib.machine.Tier;
import org.gtreimagined.gtlib.material.Material;
import org.gtreimagined.gtlib.registration.IGTObject;
import org.gtreimagined.gtlib.util.Utils;

public class HopperMachine
extends MaterialMachine {
    public HopperMachine(String domain, Material material, int slots) {
        super(domain, material.getId() + "_hopper", material);
        int rows;
        int startY;
        this.setTiers(new Tier[]{Tier.NONE});
        this.setItemBlockClass(() -> BlockGTHopper.class);
        this.setBlock((type, tier) -> new BlockGTHopper(this, (Tier)tier));
        this.setTile(BlockEntityGTHopper::new);
        this.addFlags(new String[]{"item", "gui"});
        this.removeFlags(new String[]{"coverable"});
        this.addTooltipInfo((Component)Utils.translatable((String)"machine.gtcore.hopper.slots", (Object[])new Object[]{slots}));
        this.addTooltipInfo((Component)Utils.translatable((String)"machine.gtcore.hopper.screwdriver", (Object[])new Object[0]));
        if (slots <= 0) {
            throw new IllegalArgumentException("slots cannot be <= 0!");
        }
        if (slots > 36) {
            throw new IllegalArgumentException("slots cannot be > 36!");
        }
        GTAPI.register(HopperMachine.class, (IGTObject)this);
        if (slots > 27 || slots == 16 || slots == 20) {
            startY = 8;
            rows = 4;
        } else if (slots > 18 || slots == 9 || slots == 15) {
            startY = 17;
            rows = 3;
        } else if (slots > 9 || slots == 8 || slots == 6 || slots == 4) {
            startY = 26;
            rows = 2;
        } else {
            startY = 35;
            rows = 1;
        }
        int startX = 8;
        int columns = 9;
        if (slots == 32) {
            startX = 17;
            columns = 8;
        } else if (slots % 8 == 0) {
            startX = 53;
            columns = 4;
        } else if (slots != 36 && slots % 12 == 0) {
            startX = 35;
            columns = 6;
        } else if (slots % 5 == 0 && slots <= 20) {
            startX = 44;
            columns = 5;
        } else if (slots % 7 == 0) {
            startX = 26;
            columns = 7;
        } else if (slots == 9 || slots == 6 || slots == 3) {
            startX = 62;
            columns = 3;
        } else if (slots == 4 || slots == 2) {
            startX = 71;
            columns = 2;
        } else if (slots == 1) {
            startX = 80;
            columns = 1;
        }
        int i = 0;
        block0: for (int y = 0; y < rows; ++y) {
            for (int x = 0; x < columns; ++x) {
                if (i == slots) break block0;
                this.add(SlotType.STORAGE, startX + 18 * x, startY + 18 * y);
                ++i;
            }
        }
    }
}

