/*
 * Decompiled with CFR 0.152.
 */
package org.gtreimagined.gtcore.item;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import org.gtreimagined.gtcore.data.GTCoreItems;
import org.gtreimagined.gtlib.capability.energy.ItemEnergyHandler;
import org.gtreimagined.gtlib.item.ItemBasic;
import org.gtreimagined.gtlib.material.Material;
import org.gtreimagined.gtlib.registration.IColorHandler;
import org.gtreimagined.gtlib.texture.Texture;
import org.gtreimagined.gtlib.util.Utils;
import org.gtreimagined.tesseract.TesseractCapUtils;
import org.gtreimagined.tesseract.api.context.TesseractItemContext;
import org.gtreimagined.tesseract.api.eu.IEnergyHandlerItem;
import org.gtreimagined.tesseract.api.eu.IEnergyItem;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ItemPowerUnit
extends ItemBasic<ItemPowerUnit>
implements IColorHandler,
IEnergyItem {
    Material material;

    public ItemPowerUnit(String domain, String id, Material material) {
        super(domain, id);
        this.material = material;
    }

    public Material getMaterial() {
        return this.material;
    }

    public Material getMaterial(ItemStack stack) {
        CompoundTag nbt = stack.m_41783_();
        if (nbt == null || !nbt.m_128441_("M")) {
            return this.material;
        }
        return Material.get((String)nbt.m_128461_("M"));
    }

    public void setMaterial(Material mat, ItemStack stack) {
        CompoundTag nbt = stack.m_41784_();
        nbt.m_128359_("M", mat.getId());
    }

    public int getItemColor(ItemStack stack, @Nullable Block block, int i) {
        return this.getMaterial(stack).getRGB();
    }

    public void m_7373_(ItemStack stack, @Nullable Level worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        if (flagIn.m_7050_()) {
            tooltip.add((Component)Utils.literal((String)("Energy: " + this.getCurrentEnergy(stack) + " / " + this.getMaxEnergy(stack))));
        }
        super.m_7373_(stack, worldIn, tooltip, flagIn);
    }

    public int m_142158_(@NotNull ItemStack stack) {
        long currentEnergy = this.getCurrentEnergy(stack);
        if (currentEnergy > 0L) {
            double maxAmount = this.getMaxEnergy(stack);
            return (int)(13.0 * ((double)currentEnergy / maxAmount));
        }
        return super.m_142158_(stack);
    }

    public int m_142159_(@NotNull ItemStack stack) {
        return 49151;
    }

    public boolean m_142522_(@NotNull ItemStack stack) {
        return true;
    }

    public IEnergyHandlerItem createEnergyHandler(TesseractItemContext context) {
        return new ItemEnergyHandler(context, 10000L, 0L, 32L, 0, 1);
    }

    public long getCurrentEnergy(ItemStack stack) {
        return this.getDataTag(stack).m_128454_("e");
    }

    public CompoundTag getDataTag(ItemStack stack) {
        CompoundTag dataTag = stack.m_41737_("ied");
        return dataTag != null ? dataTag : this.validateTag(stack, 0L, 100000L);
    }

    public CompoundTag validateTag(ItemStack stack, long startingEnergy, long maxEnergy) {
        CompoundTag dataTag = stack.m_41698_("ied");
        IEnergyHandlerItem handler = TesseractCapUtils.INSTANCE.getEnergyHandlerItem(stack).orElse(null);
        if (handler != null) {
            handler.setEnergy(startingEnergy);
            handler.setCapacity(maxEnergy);
            stack.m_41751_(handler.getContainer().getTag());
        } else {
            dataTag.m_128356_("e", startingEnergy);
            dataTag.m_128356_("me", maxEnergy);
        }
        return dataTag;
    }

    public long getMaxEnergy(ItemStack stack) {
        return this.getDataTag(stack).m_128454_("me");
    }

    public Texture[] getTextures() {
        String id = this.getId().startsWith("power_unit") ? "power_unit" : this.getId();
        ArrayList<Texture> list = new ArrayList<Texture>();
        list.add(new Texture(this.getDomain(), "item/basic/" + id));
        if (this == GTCoreItems.SmallPowerUnit) {
            list.add(new Texture(this.getDomain(), "item/basic/" + id + "_overlay"));
        }
        return list.toArray(new Texture[0]);
    }
}

